/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class SaveComparisonModel
extends AbstractHandler {
    private static final ImmutableList<String> DIALOG_BUTTON_LABELS = ImmutableList.of((Object)"Replace", (Object)"Cancel");
    private CompareConfiguration configuration;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object editorInput = HandlerUtil.getVariable((ExecutionEvent)event, (String)"activeEditorInput");
        if (editorInput instanceof CompareEditorInput) {
            this.configuration = ((CompareEditorInput)editorInput).getCompareConfiguration();
            Shell parent = this.configuration.getContainer().getWorkbenchPart().getSite().getShell();
            FileDialog fileDialog = new FileDialog(parent, 8192);
            String filePath = fileDialog.open();
            if (filePath != null) {
                File file = new File(filePath);
                if (file.exists()) {
                    MessageDialog messageDialog = new MessageDialog(parent, "File already exists", null, "File \"" + file.toString() + "\" already exists. Do you want to replace the existing one?", 4, (String[])DIALOG_BUTTON_LABELS.toArray((Object[])new String[0]), 1);
                    int open = messageDialog.open();
                    if (open == DIALOG_BUTTON_LABELS.indexOf((Object)"Replace")) {
                        this.saveComparison(file);
                    }
                } else {
                    this.saveComparison(file);
                }
            }
        }
        return null;
    }

    private void saveComparison(File file) {
        Comparison comparison = (Comparison)this.configuration.getProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT");
        XMIResourceImpl resource = new XMIResourceImpl(URI.createFileURI((String)file.getAbsolutePath()));
        EcoreUtil.Copier copier = new EcoreUtil.Copier(false);
        EObject comparisonCopy = copier.copy((EObject)comparison);
        copier.copyReferences();
        resource.getContents().add((Object)comparisonCopy);
        try {
            resource.save((Map)Maps.newHashMap());
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof NotSerializableException) {
                Status status = new Status(4, "org.eclipse.emf.compare.rcp.ui", EMFCompareRCPUIMessages.getString((String)"resource.not.serializable"), (Throwable)e);
                StatusManager.getManager().handle(new StatusAdapter((IStatus)status), 2);
            } else {
                EMFCompareRCPUIPlugin.getDefault().log((Throwable)e);
            }
        }
        catch (IOException e) {
            EMFCompareRCPUIPlugin.getDefault().log((Throwable)e);
        }
    }
}

