/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.match;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.EMFCompareRCPMessages;

public class MatchEngineFactoryRegistryListener
extends AbstractRegistryEventListener {
    private static final String TAG_ENGINE_FACTORY = "engineFactory";
    private static final String ATT_CLASS = "class";
    private static final String ATT_RANKING = "ranking";
    private final IMatchEngine.Factory.Registry matchEngineFactoryRegistry;

    public MatchEngineFactoryRegistryListener(String pluginID, String extensionPointID, ILog log, IMatchEngine.Factory.Registry registry) {
        super(pluginID, extensionPointID, log);
        this.matchEngineFactoryRegistry = registry;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean ret;
        if (TAG_ENGINE_FACTORY.equals(element.getName())) {
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                ret = false;
            } else if (element.getAttribute(ATT_RANKING) == null) {
                this.logMissingAttribute(element, ATT_RANKING);
                ret = false;
            } else if (element.getAttribute(ATT_RANKING) != null) {
                String rankingStr = element.getAttribute(ATT_RANKING);
                try {
                    Integer.parseInt(rankingStr);
                }
                catch (NumberFormatException numberFormatException) {
                    this.log(4, element, EMFCompareRCPMessages.getString("malformed.extension.attribute", ATT_RANKING));
                    return false;
                }
                ret = true;
            } else {
                ret = true;
            }
        } else {
            ret = false;
        }
        return ret;
    }

    protected boolean addedValid(IConfigurationElement element) {
        try {
            IMatchEngine.Factory matchEngineFactory = (IMatchEngine.Factory)element.createExecutableExtension(ATT_CLASS);
            matchEngineFactory.setRanking(Integer.parseInt(element.getAttribute(ATT_RANKING)));
            IMatchEngine.Factory previous = this.matchEngineFactoryRegistry.add(matchEngineFactory);
            if (previous != null) {
                this.log(2, element, EMFCompareRCPMessages.getString("duplicate.extension", this.matchEngineFactoryRegistry.getClass().getName()));
            }
        }
        catch (CoreException e) {
            this.log(4, element, e.getMessage());
        }
        return true;
    }

    protected boolean removedValid(IConfigurationElement element) {
        this.matchEngineFactoryRegistry.remove(element.getAttribute(ATT_CLASS));
        return true;
    }
}

