/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractViewerWrapper
extends StructuredViewer {
    private StructuredViewer fViewer;
    private final Control fControl;
    private ISelectionChangedListener fWrappedViewerListener;
    private final CompareConfiguration fConfiguration;

    public AbstractViewerWrapper(Composite parent, CompareConfiguration config) {
        this.fConfiguration = config;
        this.fControl = this.createControl(parent, config);
        this.hookControl(this.fControl);
        this.fWrappedViewerListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AbstractViewerWrapper.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AbstractViewerWrapper.this, event.getSelection()));
            }
        };
        this.fViewer.addSelectionChangedListener(this.fWrappedViewerListener);
        this.setLabelProvider(this.fViewer.getLabelProvider());
        this.setContentProvider(this.fViewer.getContentProvider());
    }

    protected abstract Control createControl(Composite var1, CompareConfiguration var2);

    public void addOpenListener(IOpenListener listener) {
        this.fViewer.addOpenListener(listener);
    }

    public void removeOpenListener(IOpenListener listener) {
        this.fViewer.removeOpenListener(listener);
    }

    public void update(Object element, String[] properties) {
        this.fViewer.update(element, properties);
    }

    public Control getControl() {
        return this.fControl;
    }

    public Object getInput() {
        return super.getInput();
    }

    public ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void refresh() {
        this.fViewer.refresh();
    }

    public void refresh(boolean updateLabels) {
        this.fViewer.refresh(updateLabels);
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.fViewer.setSelection(selection, reveal);
    }

    public void reveal(Object element) {
        this.fViewer.reveal(element);
    }

    public IContentProvider getContentProvider() {
        return super.getContentProvider();
    }

    public void setContentProvider(IContentProvider provider) {
        super.setContentProvider(provider);
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        super.setLabelProvider(labelProvider);
    }

    protected Widget doFindInputItem(Object element) {
        return null;
    }

    protected Widget doFindItem(Object element) {
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
    }

    protected List getSelectionFromWidget() {
        return null;
    }

    protected void internalRefresh(Object element) {
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    protected void hookControl(Control control) {
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                AbstractViewerWrapper.this.handleDispose(event);
            }
        });
    }

    protected void handleDispose(DisposeEvent event) {
        this.fViewer.removeSelectionChangedListener(this.fWrappedViewerListener);
    }

    protected StructuredViewer getViewer() {
        return this.fViewer;
    }

    protected void setViewer(StructuredViewer viewer) {
        this.fViewer = viewer;
    }

    public CompareConfiguration getCompareConfiguration() {
        return this.fConfiguration;
    }
}

