/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject.internal;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ScopeQuery;
import org.eclipse.emf.compare.match.eobject.internal.MatchAheadOfTime;
import org.eclipse.emf.compare.match.eobject.internal.ProximityIndex;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByTypeIndex
implements EObjectIndex,
MatchAheadOfTime {
    private Map<String, EObjectIndex> allIndexes;
    private ProximityEObjectMatcher.DistanceFunction meter;
    private ScopeQuery scope;

    public ByTypeIndex(ProximityEObjectMatcher.DistanceFunction meter, ScopeQuery scope) {
        this.meter = meter;
        this.scope = scope;
        this.allIndexes = Maps.newHashMap();
    }

    @Override
    public Iterable<EObject> getValuesStillThere(EObjectIndex.Side side) {
        ArrayList allLists = Lists.newArrayList();
        for (EObjectIndex typeSpecificIndex : this.allIndexes.values()) {
            allLists.add(typeSpecificIndex.getValuesStillThere(side));
        }
        return Iterables.concat((Iterable)allLists);
    }

    @Override
    public Map<EObjectIndex.Side, EObject> findClosests(Comparison inProgress, EObject obj, EObjectIndex.Side side) {
        EObjectIndex typeSpecificIndex = this.getOrCreate(obj);
        return typeSpecificIndex.findClosests(inProgress, obj, side);
    }

    private EObjectIndex getOrCreate(EObject obj) {
        String key = this.eClassKey(obj);
        EObjectIndex found = this.allIndexes.get(key);
        if (found == null) {
            found = new ProximityIndex(this.meter, this.scope);
            this.allIndexes.put(key, found);
        }
        return found;
    }

    private String eClassKey(EObject obj) {
        EClass clazz = obj.eClass();
        if (clazz.getEPackage() != null) {
            return String.valueOf(clazz.getEPackage().getNsURI()) + ":" + clazz.getName();
        }
        return clazz.getName();
    }

    @Override
    public void remove(EObject obj, EObjectIndex.Side side) {
        EObjectIndex typeSpecificIndex = this.getOrCreate(obj);
        typeSpecificIndex.remove(obj, side);
    }

    @Override
    public void index(EObject eObjs, EObjectIndex.Side side) {
        EObjectIndex typeSpecificIndex = this.getOrCreate(eObjs);
        typeSpecificIndex.index(eObjs, side);
    }

    @Override
    public Iterable<EObject> getValuesToMatchAhead(EObjectIndex.Side side) {
        ArrayList allLists = Lists.newArrayList();
        for (MatchAheadOfTime typeSpecificIndex : Iterables.filter(this.allIndexes.values(), MatchAheadOfTime.class)) {
            allLists.add(typeSpecificIndex.getValuesToMatchAhead(side));
        }
        return Iterables.concat((Iterable)allLists);
    }
}

