/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatureFilter {
    public Iterator<EReference> getReferencesToCheck(final Match match) {
        EClass clazz = match.getLeft() != null ? match.getLeft().eClass() : (match.getRight() != null ? match.getRight().eClass() : match.getOrigin().eClass());
        return Iterators.filter((Iterator)clazz.getEAllReferences().iterator(), (Predicate)new Predicate<EReference>(){

            public boolean apply(EReference input) {
                return !FeatureFilter.this.isIgnoredReference(match, input);
            }
        });
    }

    public Iterator<EAttribute> getAttributesToCheck(Match match) {
        EClass clazz = match.getLeft() != null ? match.getLeft().eClass() : (match.getRight() != null ? match.getRight().eClass() : match.getOrigin().eClass());
        return Iterators.filter((Iterator)clazz.getEAllAttributes().iterator(), (Predicate)new Predicate<EAttribute>(){

            public boolean apply(EAttribute input) {
                return !FeatureFilter.this.isIgnoredAttribute(input);
            }
        });
    }

    public boolean checkForOrderingChanges(EStructuralFeature feature) {
        if (feature.isMany()) {
            return feature.isOrdered() || feature instanceof EReference && ((EReference)feature).isContainment();
        }
        return false;
    }

    protected boolean referenceIsSet(EReference reference, Match match) {
        if (match.getLeft() != null && match.getLeft().eIsSet((EStructuralFeature)reference)) {
            return true;
        }
        boolean isSet = false;
        String featureName = reference.getName();
        if (match.getRight() != null) {
            EStructuralFeature rightRef = match.getRight().eClass().getEStructuralFeature(featureName);
            isSet = match.getRight().eIsSet(rightRef);
        }
        if (!isSet && match.getOrigin() != null) {
            EStructuralFeature originRef = match.getOrigin().eClass().getEStructuralFeature(featureName);
            isSet = match.getOrigin().eIsSet(originRef);
        }
        return isSet;
    }

    protected boolean isIgnoredReference(Match match, EReference reference) {
        boolean toIgnore;
        if (reference != null) {
            if (!(reference.isDerived() || reference.isContainer() || reference.isTransient())) {
                boolean isGenericType;
                boolean isGenericTypeWithoutArguments = false;
                boolean bl = isGenericType = reference.getEType() == EcorePackage.eINSTANCE.getEGenericType();
                if (isGenericType) {
                    isGenericTypeWithoutArguments = EMFComparePredicates.IS_EGENERIC_TYPE_WITHOUT_PARAMETERS.apply((Object)match.getLeft()) && EMFComparePredicates.IS_EGENERIC_TYPE_WITHOUT_PARAMETERS.apply((Object)match.getRight()) && EMFComparePredicates.IS_EGENERIC_TYPE_WITHOUT_PARAMETERS.apply((Object)match.getOrigin());
                }
                toIgnore = isGenericTypeWithoutArguments || !this.referenceIsSet(reference, match);
            } else {
                toIgnore = !ReferenceUtil.isFeatureMapDerivedFeature(reference);
            }
        } else {
            toIgnore = true;
        }
        return toIgnore;
    }

    protected boolean isIgnoredAttribute(EAttribute attribute) {
        return attribute == null || attribute.isDerived() || attribute.isTransient();
    }
}

