/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.rcp.internal.policy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.rcp.policy.ILoadOnDemandPolicy;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.uml2.uml.UMLPlugin;

public class UMLLoadOnDemandPolicy
implements ILoadOnDemandPolicy {
    public boolean isAuthorizing(URI uri) {
        ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
        URI normalizedURI = uriConverter.normalize(uri);
        return this.isConventionalURIForUMLProfile(normalizedURI) || this.isRegisteredUMLProfile(normalizedURI, (URIConverter)uriConverter);
    }

    private boolean isRegisteredUMLProfile(URI normalizedURI, final URIConverter uriConverter) {
        Collection normalizedURIs = Collections2.transform(UMLPlugin.getEPackageNsURIToProfileLocationMap().values(), (Function)new Function<URI, URI>(){

            public URI apply(URI t) {
                return uriConverter.normalize(t).trimFragment();
            }
        });
        return Iterables.tryFind((Iterable)normalizedURIs, (Predicate)Predicates.equalTo((Object)normalizedURI.trimFragment())).isPresent();
    }

    private boolean isConventionalURIForUMLProfile(URI normalizedURI) {
        URI withoutFirstFileExtension;
        String secondFileExtension;
        URI noFragmentURI = normalizedURI.trimFragment();
        String firstFileExtension = noFragmentURI.fileExtension();
        return "uml".equals(firstFileExtension) && "profile".equals(secondFileExtension = (withoutFirstFileExtension = noFragmentURI.trimFileExtension()).fileExtension());
    }
}

