/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.postprocessor;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.CompareUIPapyrusMessages;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.postprocessor.MatchResourcePredicates;
import org.eclipse.emf.compare.diagram.ide.ui.papyrus.internal.postprocessor.PapyrusPostProcessor;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMergeRenamingMatchResources {
    protected final Comparison comparison;
    protected final Monitor monitor;
    protected final Multimap<URI, MatchResource> index = LinkedHashMultimap.create();
    protected final Map<URI, MatchResource> renamingMatches = Maps.newLinkedHashMap();

    public AbstractMergeRenamingMatchResources(Comparison comparison, Monitor monitor) {
        this.comparison = (Comparison)Preconditions.checkNotNull((Object)comparison);
        this.checkComparison();
        this.monitor = (Monitor)Preconditions.checkNotNull((Object)monitor);
    }

    public final void run() {
        this.monitor.subTask(CompareUIPapyrusMessages.getString("MergeRenamingResources.TaskLabel"));
        this.checkComparison();
        this.indexMatchResources();
        for (MatchResource matchResource : this.renamingMatches.values()) {
            this.handleRenamingMatchResource(matchResource);
        }
    }

    protected abstract void checkComparison();

    protected abstract Resource getBaseResource(MatchResource var1);

    protected IStorageProviderAccessor.DiffSide getBaseSide() {
        return IStorageProviderAccessor.DiffSide.SOURCE;
    }

    protected void indexMatchResources() {
        for (MatchResource matchResource : this.comparison.getMatchedResources()) {
            Resource originResource = this.getBaseResource(matchResource);
            if (originResource == null) {
                this.indexPapyrusMatchResource(matchResource, null);
                continue;
            }
            URI originURI = originResource.getURI();
            if (!this.handles(originURI)) continue;
            this.index.put((Object)originURI.trimFileExtension(), (Object)matchResource);
            this.indexPapyrusMatchResource(matchResource, originURI);
        }
    }

    protected boolean handles(URI uri) {
        return uri != null && PapyrusPostProcessor.FILE_EXTENSIONS.contains(uri.fileExtension());
    }

    protected void indexPapyrusMatchResource(MatchResource matchResource, URI baseURI) {
        Resource right = matchResource.getRight();
        if (right != null && this.handles(right.getURI()) && !right.getURI().equals(baseURI)) {
            this.index.put((Object)right.getURI().trimFileExtension(), (Object)matchResource);
            if (baseURI != null) {
                this.renamingMatches.put(baseURI.trimFileExtension(), matchResource);
            }
        }
    }

    protected void handleRenamingMatchResource(MatchResource matchResource) {
        URI originURI = this.getBaseResource(matchResource).getURI();
        Resource right = matchResource.getRight();
        if (right != null && right.getURI() != null && !originURI.equals(right.getURI())) {
            URI rightTrimmedURI = right.getURI().trimFileExtension();
            for (MatchResource similarMatchResource : this.findSimilarMatchResources(matchResource)) {
                String fileExtension;
                URI candidateURI;
                Iterator<MatchResource> iterator = this.findMatchResources(similarMatchResource, candidateURI = rightTrimmedURI.appendFileExtension(fileExtension = this.getBaseResource(similarMatchResource).getURI().fileExtension()), false).iterator();
                if (!iterator.hasNext()) continue;
                MatchResource renamedMatchResource = iterator.next();
                similarMatchResource.setRight(renamedMatchResource.getRight());
                similarMatchResource.setRightURI(renamedMatchResource.getRightURI());
                this.comparison.getMatchedResources().remove((Object)renamedMatchResource);
            }
        }
    }

    protected Iterable<MatchResource> findSimilarMatchResources(MatchResource matchResource) {
        URI originURI = this.getBaseResource(matchResource).getURI();
        URI trimmedURI = originURI.trimFileExtension();
        return Iterables.filter((Iterable)this.index.get((Object)trimmedURI), (Predicate)Predicates.and((Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)matchResource)), MatchResourcePredicates.hasSameTrimmedURI(matchResource, this.getBaseSide())));
    }

    protected Iterable<MatchResource> findMatchResources(MatchResource candidate, URI expectedURI, boolean left) {
        if (left) {
            return Iterables.filter((Iterable)this.index.get((Object)expectedURI.trimFileExtension()), (Predicate)Predicates.and((Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)candidate)), MatchResourcePredicates.hasSameURI(expectedURI, IStorageProviderAccessor.DiffSide.SOURCE)));
        }
        return Iterables.filter((Iterable)this.index.get((Object)expectedURI.trimFileExtension()), (Predicate)Predicates.and((Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)candidate)), MatchResourcePredicates.hasSameURI(expectedURI, IStorageProviderAccessor.DiffSide.REMOTE)));
    }
}

