/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.AbstractMergeRunnable;
import org.eclipse.emf.compare.internal.merge.MergeDependenciesUtil;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.merge.MergeOperation;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeRunnableImpl
extends AbstractMergeRunnable
implements IMergeRunnable {
    public MergeRunnableImpl(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode) {
        super(isLeftEditable, isRightEditable, mergeMode);
    }

    public void merge(List<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        Preconditions.checkState((this.getMergeMode().isLeftToRight(this.isLeftEditable(), this.isRightEditable()) == leftToRight ? 1 : 0) != 0);
        if (this.getMergeMode() == MergeMode.LEFT_TO_RIGHT || this.getMergeMode() == MergeMode.RIGHT_TO_LEFT) {
            this.mergeAll(differences, leftToRight, mergerRegistry);
        } else if (this.getMergeMode() == MergeMode.ACCEPT || this.getMergeMode() == MergeMode.REJECT) {
            ArrayList diffToMarkAsMerged = Lists.newArrayList();
            ArrayList diffToCopyFromLeftToRight = Lists.newArrayList();
            ArrayList diffToCopyFromRightToLeft = Lists.newArrayList();
            for (Diff diff : differences) {
                MergeOperation mergeAction = this.getMergeMode().getMergeAction(diff, this.isLeftEditable(), this.isRightEditable());
                if (mergeAction == MergeOperation.MARK_AS_MERGE) {
                    diffToMarkAsMerged.add(diff);
                    continue;
                }
                if (this.isLeftEditable() && leftToRight) {
                    diffToCopyFromRightToLeft.add(diff);
                    continue;
                }
                diffToCopyFromLeftToRight.add(diff);
            }
            this.mergeAll(diffToCopyFromLeftToRight, leftToRight, mergerRegistry);
            this.mergeAll(diffToCopyFromRightToLeft, !leftToRight, mergerRegistry);
            this.markAllAsMerged(diffToMarkAsMerged, this.getMergeMode(), mergerRegistry);
        } else {
            throw new IllegalStateException();
        }
    }

    private void mergeAll(Collection<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        BatchMerger merger = new BatchMerger(mergerRegistry);
        if (leftToRight) {
            merger.copyAllLeftToRight(differences, (Monitor)new BasicMonitor());
        } else {
            merger.copyAllRightToLeft(differences, (Monitor)new BasicMonitor());
        }
        for (Diff diff : differences) {
            IMerger diffMerger = mergerRegistry.getHighestRankingMerger(diff);
            if (diffMerger instanceof IMerger2) {
                Set resultingMerges = MergeDependenciesUtil.getAllResultingMerges((Diff)diff, (IMerger.Registry)mergerRegistry, (!leftToRight ? 1 : 0) != 0);
                this.addOrUpdateMergeData(resultingMerges, this.getMergeMode());
                Set resultingRejections = MergeDependenciesUtil.getAllResultingRejections((Diff)diff, (IMerger.Registry)mergerRegistry, (!leftToRight ? 1 : 0) != 0);
                if (this.getMergeMode() == MergeMode.LEFT_TO_RIGHT || this.getMergeMode() == MergeMode.RIGHT_TO_LEFT) {
                    this.addOrUpdateMergeData(resultingRejections, this.getMergeMode());
                    continue;
                }
                this.addOrUpdateMergeData(resultingRejections, this.getMergeMode().inverse());
                continue;
            }
            this.addOrUpdateMergeData(Collections.singleton(diff), this.getMergeMode());
        }
    }
}

