/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.resource;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.resource.IResourceMatchingStrategy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootIDMatchingStrategy
implements IResourceMatchingStrategy {
    @Override
    public List<MatchResource> matchResources(Iterable<? extends Resource> left, Iterable<? extends Resource> right, Iterable<? extends Resource> origin) {
        List<Resource> matchingLefts;
        List<Resource> matchingOrigins;
        ArrayList mappings = Lists.newArrayList();
        ArrayList leftCopy = Lists.newArrayList(left);
        ArrayList rightCopy = Lists.newArrayList(right);
        ArrayList originCopy = Lists.newArrayList(origin);
        LinkedHashMap<Resource, List<Resource>> leftRightMap = new LinkedHashMap<Resource, List<Resource>>();
        LinkedHashMap<Resource, List<Resource>> leftOriginMap = new LinkedHashMap<Resource, List<Resource>>();
        LinkedHashMap<Resource, List<Resource>> rightOriginMap = new LinkedHashMap<Resource, List<Resource>>();
        for (Resource leftResource : leftCopy) {
            List<Resource> matchingRights = this.findMatches(leftResource, rightCopy);
            leftRightMap.put(leftResource, matchingRights);
            matchingOrigins = this.findMatches(leftResource, originCopy);
            leftOriginMap.put(leftResource, matchingOrigins);
        }
        for (Resource rightResource : rightCopy) {
            matchingLefts = this.findMatches(rightResource, leftCopy);
            leftRightMap.put(rightResource, matchingLefts);
            matchingOrigins = this.findMatches(rightResource, originCopy);
            rightOriginMap.put(rightResource, matchingOrigins);
        }
        for (Resource originResource : originCopy) {
            matchingLefts = this.findMatches(originResource, leftCopy);
            leftOriginMap.put(originResource, matchingLefts);
            List<Resource> matchingRights = this.findMatches(originResource, rightCopy);
            rightOriginMap.put(originResource, matchingRights);
        }
        for (Resource leftResource : leftCopy) {
            Resource rightCandidate;
            List rightObjects = (List)leftRightMap.get(leftResource);
            Resource rightResource = null;
            Resource originResource = null;
            if (rightObjects.size() > 1) {
                rightCopy.removeAll(rightObjects);
                continue;
            }
            if (rightObjects.size() == 1 && ((List)leftRightMap.get(rightCandidate = (Resource)rightObjects.get(0))).size() == 1) {
                rightResource = rightCandidate;
            }
            if (!originCopy.isEmpty()) {
                HashSet originObjects = Sets.newHashSet();
                originObjects.addAll((Collection)leftOriginMap.get(leftResource));
                if (rightResource != null) {
                    originObjects.addAll((Collection)rightOriginMap.get(rightResource));
                }
                if (originObjects.size() > 1) {
                    rightCopy.remove(rightResource);
                    continue;
                }
                if (originObjects.size() == 1) {
                    Resource originCandidate = (Resource)originObjects.iterator().next();
                    HashSet mappedResources = Sets.newHashSet();
                    mappedResources.addAll((Collection)leftOriginMap.get(originCandidate));
                    mappedResources.addAll((Collection)rightOriginMap.get(originCandidate));
                    mappedResources.add(leftResource);
                    mappedResources.add(rightResource);
                    if (mappedResources.size() > 2) {
                        rightCopy.remove(rightResource);
                        continue;
                    }
                    originResource = originCandidate;
                }
            }
            if (rightResource == null && originResource == null) continue;
            mappings.add(this.createMatchResource(leftResource, rightResource, originResource));
            rightCopy.remove(rightResource);
        }
        if (!originCopy.isEmpty()) {
            for (Resource rightResource : rightCopy) {
                List leftCandidates;
                Resource leftResource = null;
                Resource originResource = null;
                List originObjects = (List)rightOriginMap.get(rightResource);
                if (originObjects.size() != 1 || ((List)rightOriginMap.get(originResource = (Resource)originObjects.get(0))).size() > 1 || (leftCandidates = (List)leftOriginMap.get(originResource)).size() > 1) continue;
                if (leftCandidates.size() == 1) {
                    Resource leftCandidate = (Resource)leftCandidates.get(0);
                    if (((List)leftOriginMap.get(leftCandidate)).size() > 1 || !((List)leftRightMap.get(leftCandidate)).isEmpty()) continue;
                    leftResource = leftCandidate;
                }
                mappings.add(this.createMatchResource(leftResource, rightResource, originResource));
            }
        }
        return mappings;
    }

    protected List<Resource> findMatches(Resource reference, Iterable<Resource> candidates) {
        Set<String> referenceIDs = this.getResourceIdentifiers(reference);
        if (referenceIDs.isEmpty()) {
            return Lists.newArrayList();
        }
        ArrayList<Resource> matches = new ArrayList<Resource>(2);
        Iterator<Resource> candidateIterator = candidates.iterator();
        while (candidateIterator.hasNext() && matches.size() < 2) {
            Resource candidate = candidateIterator.next();
            Set<String> candidateIDs = this.getResourceIdentifiers(candidate);
            if (candidateIDs.isEmpty() || Sets.intersection(candidateIDs, referenceIDs).isEmpty()) continue;
            matches.add(candidate);
        }
        return matches;
    }

    @Deprecated
    protected Resource findMatch(Resource reference, Iterable<Resource> candidates) {
        Set<String> referenceIDs = this.getResourceIdentifiers(reference);
        if (referenceIDs.isEmpty()) {
            return null;
        }
        Resource match = null;
        Iterator<Resource> candidateIterator = candidates.iterator();
        while (candidateIterator.hasNext() && match == null) {
            Resource candidate = candidateIterator.next();
            Set<String> candidateIDs = this.getResourceIdentifiers(candidate);
            if (candidateIDs.isEmpty() || Sets.intersection(candidateIDs, referenceIDs).isEmpty()) continue;
            match = candidate;
        }
        return match;
    }

    protected Set<String> getResourceIdentifiers(Resource resource) {
        HashSet identifiers = Sets.newHashSet();
        for (EObject root : resource.getContents()) {
            String rootID;
            String resourceId;
            if (resource instanceof XMIResource && (resourceId = ((XMIResource)resource).getID(root)) != null) {
                identifiers.add(resourceId);
            }
            if ((rootID = EcoreUtil.getID((EObject)root)) == null) continue;
            identifiers.add(rootID);
        }
        return identifiers;
    }

    protected MatchResource createMatchResource(Resource left, Resource right, Resource origin) {
        MatchResource match = CompareFactory.eINSTANCE.createMatchResource();
        match.setLeft(left);
        match.setRight(right);
        match.setOrigin(origin);
        if (left != null && left.getURI() != null) {
            match.setLeftURI(left.getURI().toString());
        }
        if (right != null && right.getURI() != null) {
            match.setRightURI(right.getURI().toString());
        }
        if (origin != null && origin.getURI() != null) {
            match.setOriginURI(origin.getURI().toString());
        }
        return match;
    }
}

