/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.AbstractDifferenceFilter;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TechnicalitiesFilter
extends AbstractDifferenceFilter {
    private static final Predicate<? super EObject> PREDICATE_EMPTY_MATCH_RESOURCES = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            TreeNode treeNode;
            boolean ret = false;
            if (input instanceof TreeNode && (treeNode = (TreeNode)input).getData() instanceof MatchResource) {
                ret = treeNode.getChildren().isEmpty();
            }
            return ret;
        }
    };
    private static final Predicate<? super EObject> PREDICATE_FEATURE_MAP = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            EObject data;
            boolean ret = false;
            if (input instanceof TreeNode && (data = ((TreeNode)input).getData()) instanceof FeatureMapChange) {
                ret = ((FeatureMapChange)data).getEquivalence() != null;
            }
            return ret;
        }
    };
    private static final Predicate<? super EObject> PREDICATE_PSEUDO_CONFLICT = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            Diff diff;
            TreeNode treeNode;
            EObject data;
            boolean ret = false;
            if (input instanceof TreeNode && (data = (treeNode = (TreeNode)input).getData()) instanceof Diff && (diff = (Diff)data).getMatch().getComparison().isThreeWay()) {
                ret = TechnicalitiesFilter.isConsideredAsPseudoConflicting(diff);
            }
            return ret;
        }
    };
    private static final Predicate<? super EObject> PREDICATE_IDENTICAL_ELEMENTS = new Predicate<EObject>(){

        public boolean apply(EObject input) {
            TreeNode treeNode;
            EObject data;
            if (input instanceof TreeNode && (data = (treeNode = (TreeNode)input).getData()) instanceof Match) {
                return !Iterators.any((Iterator)treeNode.eAllContents(), (Predicate)DATA_IS_DIFF);
            }
            return false;
        }
    };
    private static final Predicate<? super EObject> PREDICATE_WHEN_SELECTED = Predicates.or((Predicate[])new Predicate[]{PREDICATE_EMPTY_MATCH_RESOURCES, PREDICATE_FEATURE_MAP, PREDICATE_IDENTICAL_ELEMENTS, PREDICATE_PSEUDO_CONFLICT});
    private static final Predicate<EObject> DATA_IS_DIFF = new Predicate<EObject>(){

        public boolean apply(EObject treeNode) {
            return treeNode instanceof TreeNode && ((TreeNode)treeNode).getData() instanceof Diff;
        }
    };

    private static boolean isConsideredAsPseudoConflicting(Diff diff) {
        return EMFComparePredicates.allAtomicRefining((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})).apply((Object)diff) && EMFComparePredicates.hasNoDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)diff);
    }

    @Override
    public Predicate<? super EObject> getPredicateWhenSelected() {
        return PREDICATE_WHEN_SELECTED;
    }
}

