/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.BasicDifferenceGroupImpl;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.DiffNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchNode;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.nodes.MatchResourceNode;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.AbstractDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeNode;

public class ByResourceGroupProvider
extends AbstractDifferenceGroupProvider {
    @Override
    protected Collection<? extends IDifferenceGroup> buildGroups(Comparison comparison2) {
        ResourceGroup group = new ResourceGroup(comparison2, this.getCrossReferenceAdapter());
        group.buildSubTree();
        return ImmutableList.of((Object)group);
    }

    public static class ResourceGroup
    extends BasicDifferenceGroupImpl {
        private Set<Match> roots;

        public ResourceGroup(Comparison comparison, ECrossReferenceAdapter crossReferenceAdapter) {
            super(comparison, (Predicate<? super Diff>)Predicates.alwaysTrue(), crossReferenceAdapter);
        }

        @Override
        public void buildSubTree() {
            this.roots = new LinkedHashSet<Match>();
            for (Match match : this.getComparison().getMatches()) {
                this.recursiveFindRoots(match);
            }
            super.buildSubTree();
        }

        private void recursiveFindRoots(Match match) {
            if (this.hasRootSide(match)) {
                this.roots.add(match);
            }
            for (Match subMatch : match.getSubmatches()) {
                this.recursiveFindRoots(subMatch);
            }
        }

        private boolean hasRootSide(Match match) {
            boolean hasRoot = match.getLeft() instanceof InternalEObject && ((InternalEObject)match.getLeft()).eDirectResource() != null;
            hasRoot = hasRoot || match.getRight() instanceof InternalEObject && ((InternalEObject)match.getRight()).eDirectResource() != null;
            hasRoot = hasRoot || match.getOrigin() instanceof InternalEObject && ((InternalEObject)match.getOrigin()).eDirectResource() != null;
            return hasRoot;
        }

        @Override
        protected List<TreeNode> buildMatchTrees() {
            return new ArrayList<TreeNode>();
        }

        @Override
        protected MatchResourceNode buildSubTree(MatchResource matchResource, Set<ResourceAttachmentChange> attachmentChanges) {
            MatchResourceNode matchResourceNode = this.createMatchResourceNode(matchResource);
            for (ResourceAttachmentChange attachmentChange : attachmentChanges) {
                DiffNode diffNode = this.createDiffNode((Diff)attachmentChange);
                matchResourceNode.addDiffNode(diffNode);
            }
            for (Match match : this.roots) {
                if (!this.isUnderResourceWithURI(match.getLeft(), matchResource.getLeftURI()) && !this.isUnderResourceWithURI(match.getRight(), matchResource.getRightURI()) && !this.isUnderResourceWithURI(match.getOrigin(), matchResource.getOriginURI())) continue;
                MatchNode matchNode = this.createMatchNode(match);
                this.populateMatchNode(matchNode);
                matchResourceNode.addMatchNode(matchNode);
            }
            return matchResourceNode;
        }

        private boolean isUnderResourceWithURI(EObject eObject, String uri) {
            if (eObject != null && uri != null) {
                Resource resource = eObject.eResource();
                return resource != null && uri.equals(resource.getURI().toString());
            }
            return false;
        }
    }
}

