/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.postprocessor;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.IItemRegistry;
import org.eclipse.emf.compare.rcp.internal.extension.impl.AbstractItemDescriptor;
import org.eclipse.emf.compare.rcp.internal.extension.impl.ItemUtil;
import org.eclipse.emf.compare.rcp.internal.extension.impl.WrapperItemDescriptor;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.osgi.service.prefs.Preferences;

public class PostProcessorRegistryImpl
implements IPostProcessor.Descriptor.Registry<String> {
    private static final String EMPTY_STRING = "";
    private final IItemRegistry<IPostProcessor.Descriptor> baseRegisty;

    public PostProcessorRegistryImpl(IItemRegistry<IPostProcessor.Descriptor> baseRegisty) {
        this.baseRegisty = baseRegisty;
    }

    public IPostProcessor.Descriptor put(String key, IPostProcessor.Descriptor descriptor) {
        WrapperItemDescriptor<IPostProcessor.Descriptor> newDescriptor = new WrapperItemDescriptor<IPostProcessor.Descriptor>(EMPTY_STRING, EMPTY_STRING, descriptor.getOrdinal(), descriptor.getInstanceClassName(), descriptor);
        IItemDescriptor<IPostProcessor.Descriptor> oldDescriptor = this.baseRegisty.add(newDescriptor);
        if (oldDescriptor != null) {
            return oldDescriptor.getItem();
        }
        return null;
    }

    public void clear() {
        this.baseRegisty.clear();
    }

    public List<IPostProcessor.Descriptor> getDescriptors() {
        List<IItemDescriptor<IPostProcessor.Descriptor>> itemDescriptors = this.baseRegisty.getItemDescriptors();
        Collections.sort(itemDescriptors);
        Collection activeDescriptor = Collections2.filter(itemDescriptors, (Predicate)Predicates.not((Predicate)Predicates.in(this.getDisabledEngines())));
        Collection descriptors = Collections2.transform((Collection)activeDescriptor, AbstractItemDescriptor.getItemFunction());
        return Lists.newArrayList((Iterable)descriptors);
    }

    private Collection<IItemDescriptor<IPostProcessor.Descriptor>> getDisabledEngines() {
        List<IItemDescriptor<Object>> result = ItemUtil.getItemsDescriptor(this.baseRegisty, "org.eclipse.emf.compare.preference.postprocessor.disabled", (Preferences)EMFCompareRCPPlugin.getDefault().getEMFComparePreferences());
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }

    public IPostProcessor.Descriptor remove(String key) {
        IItemDescriptor<IPostProcessor.Descriptor> oldDescriptor = this.baseRegisty.remove(key);
        if (oldDescriptor != null) {
            return oldDescriptor.getItem();
        }
        return null;
    }

    public List<IPostProcessor> getPostProcessors(IComparisonScope scope) {
        ImmutableList.Builder processors = ImmutableList.builder();
        block0: for (IPostProcessor.Descriptor factory : this.getDescriptors()) {
            Pattern resourceURIPattern;
            Pattern nsURIPattern = factory.getNsURI();
            if (nsURIPattern != null) {
                for (String nsURI : scope.getNsURIs()) {
                    if (!nsURIPattern.matcher(nsURI).matches()) continue;
                    processors.add((Object)factory.getPostProcessor());
                    break;
                }
            }
            if ((resourceURIPattern = factory.getResourceURI()) == null) continue;
            for (String resourceURI : scope.getResourceURIs()) {
                if (!resourceURIPattern.matcher(resourceURI).matches()) continue;
                processors.add((Object)factory.getPostProcessor());
                continue block0;
            }
        }
        return processors.build();
    }
}

