/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.ide.IAdditiveResourceMappingMerger;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.ComparisonScopeBuilder;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMapping;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFResourceMappingMerger;
import org.eclipse.emf.compare.ide.ui.internal.logical.IdenticalResourceMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.AdditiveMergeCriterion;
import org.eclipse.emf.compare.merge.ComputeDiffsToMerge;
import org.eclipse.emf.compare.merge.DelegatingMerger;
import org.eclipse.emf.compare.merge.IMergeCriterion;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.MergeBlockedByConflictException;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IMergeContext;

public class AdditiveResourceMappingMerger
extends EMFResourceMappingMerger
implements IAdditiveResourceMappingMerger {
    @Override
    protected void mergeMapping(ResourceMapping mapping, IMergeContext mergeContext, Set<ResourceMapping> failingMappings, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        SynchronizationModel syncModel = ((EMFResourceMapping)mapping).getLatestModel();
        this.removeNonExistingStorages(syncModel.getLeftTraversal());
        LinkedHashSet resources = Sets.newLinkedHashSet(syncModel.getResources());
        IdenticalResourceMinimizer minimizer = new IdenticalResourceMinimizer();
        minimizer.minimize(syncModel, (IProgressMonitor)subMonitor.newChild(1));
        IComparisonScope scope = ComparisonScopeBuilder.create(syncModel, (IProgressMonitor)subMonitor.newChild(3));
        EMFCompare.Builder builder = EMFCompare.builder();
        EMFCompareBuilderConfigurator.createDefault().configure(builder);
        Comparison comparison = builder.build().compare(scope, BasicMonitor.toMonitor((IProgressMonitorWithBlocking)SubMonitor.convert((IProgressMonitor)subMonitor.newChild(1), (int)10)));
        EMFResourceMappingMerger.ResourceAdditionAndDeletionTracker resourceTracker = new EMFResourceMappingMerger.ResourceAdditionAndDeletionTracker();
        Set<URI> conflictingURIs = this.performPreMerge(comparison, subMonitor.newChild(3));
        this.save(scope.getLeft(), syncModel.getLeftTraversal(), syncModel.getRightTraversal(), syncModel.getOriginTraversal());
        if (!conflictingURIs.isEmpty()) {
            failingMappings.add(mapping);
            this.markResourcesAsMerged(mergeContext, resources, conflictingURIs, subMonitor.newChild(2));
        } else {
            this.delegateMergeOfUnmergedResourcesAndMarkDiffsAsMerged(syncModel, mergeContext, resourceTracker, subMonitor.newChild(2));
        }
        scope.getLeft().eAdapters().remove((Object)resourceTracker);
        subMonitor.setWorkRemaining(0);
    }

    private Set<URI> performPreMerge(Comparison comparison, SubMonitor subMonitor) {
        Monitor emfMonitor = BasicMonitor.toMonitor((IProgressMonitorWithBlocking)subMonitor);
        LinkedHashSet<URI> conflictingURIs = new LinkedHashSet<URI>();
        ComputeDiffsToMerge computer = new ComputeDiffsToMerge(true, MERGER_REGISTRY, (IMergeCriterion)AdditiveMergeCriterion.INSTANCE).failOnRealConflictUnless(EMFComparePredicates.isAdditiveConflict());
        for (Diff next : comparison.getDifferences()) {
            this.doMergeForDiff(next, computer, emfMonitor, conflictingURIs);
        }
        return conflictingURIs;
    }

    private void doMergeForDiff(Diff diff, ComputeDiffsToMerge computer, Monitor emfMonitor, Set<URI> conflictingURIs) {
        if (AbstractMerger.isInTerminalState((Diff)diff)) {
            return;
        }
        try {
            Set diffsToMerge = computer.getAllDiffsToMerge(diff);
            for (Diff toMerge : diffsToMerge) {
                this.atomicMerge(toMerge, emfMonitor);
            }
        }
        catch (MergeBlockedByConflictException e) {
            conflictingURIs.addAll(this.collectConflictingResources(e.getConflictingDiffs().iterator()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void atomicMerge(Diff diff, Monitor emfMonitor) {
        if (EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)diff)) {
            if (!this.isOnlyInAdditiveConflicts(diff)) throw new IllegalStateException();
            if (diff.getSource() == DifferenceSource.LEFT) {
                if (this.isRequiredByDeletion(diff)) {
                    DelegatingMerger delegatingMerger = AbstractMerger.getMergerDelegate((Diff)diff, (IMerger.Registry2)MERGER_REGISTRY, (IMergeCriterion)AdditiveMergeCriterion.INSTANCE);
                    delegatingMerger.copyRightToLeft(diff, emfMonitor);
                    return;
                } else {
                    diff.setState(DifferenceState.MERGED);
                }
                return;
            } else if (this.isRequiredByDeletion(diff)) {
                diff.setState(DifferenceState.DISCARDED);
                return;
            } else {
                AbstractMerger.getMergerDelegate((Diff)diff, (IMerger.Registry2)MERGER_REGISTRY, (IMergeCriterion)AdditiveMergeCriterion.INSTANCE).copyRightToLeft(diff, emfMonitor);
            }
            return;
        } else if (this.isPseudoConflicting(diff)) {
            EList conflictingDiffs = diff.getConflict().getDifferences();
            for (Diff conflictingDiff : conflictingDiffs) {
                conflictingDiff.setState(DifferenceState.MERGED);
            }
            return;
        } else if (diff.getSource() == DifferenceSource.LEFT) {
            if (this.isRequiredByDeletion(diff)) {
                AbstractMerger.getMergerDelegate((Diff)diff, (IMerger.Registry2)MERGER_REGISTRY, (IMergeCriterion)AdditiveMergeCriterion.INSTANCE).copyRightToLeft(diff, emfMonitor);
                return;
            } else {
                diff.setState(DifferenceState.MERGED);
            }
            return;
        } else if (this.isRequiredByDeletion(diff)) {
            diff.setState(DifferenceState.DISCARDED);
            return;
        } else {
            AbstractMerger.getMergerDelegate((Diff)diff, (IMerger.Registry2)MERGER_REGISTRY, (IMergeCriterion)AdditiveMergeCriterion.INSTANCE).copyRightToLeft(diff, emfMonitor);
        }
    }

    @Override
    protected void delegateMergeOfUnmergedResourcesAndMarkDiffsAsMerged(SynchronizationModel syncModel, IMergeContext mergeContext, EMFResourceMappingMerger.ResourceAdditionAndDeletionTracker resourceTracker, SubMonitor subMonitor) throws CoreException {
        IDiff diff;
        IPath fullPath;
        for (IFile deletedFile : resourceTracker.getDeletedIFiles()) {
            IDiff diff2 = mergeContext.getDiffTree().getDiff((IResource)deletedFile);
            this.markAsMerged(diff2, mergeContext, subMonitor);
        }
        for (IStorage storage : syncModel.getLeftTraversal().getStorages()) {
            fullPath = ResourceUtil.getFixedPath((IStorage)storage);
            if (fullPath == null) {
                EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.ide.ui", EMFCompareIDEUIMessages.getString("EMFResourceMappingMerger.mergeIncomplete")));
                continue;
            }
            diff = mergeContext.getDiffTree().getDiff(fullPath);
            if (diff == null) continue;
            this.markAsMerged(diff, mergeContext, subMonitor.newChild(1));
        }
        for (IStorage rightStorage : syncModel.getRightTraversal().getStorages()) {
            fullPath = ResourceUtil.getFixedPath((IStorage)rightStorage);
            if (fullPath == null || (diff = mergeContext.getDiffTree().getDiff(fullPath)) == null || 1 != diff.getKind()) continue;
            if (!resourceTracker.containsAddedResource(fullPath)) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath);
                IProject project = file.getProject();
                if (project.isAccessible()) {
                    this.merge(diff, mergeContext, subMonitor.newChild(1));
                    continue;
                }
                try {
                    Throwable throwable = null;
                    Object var12_14 = null;
                    try {
                        InputStream inputStream = rightStorage.getContents();
                        try {
                            try (FileOutputStream outputStream = new FileOutputStream(ResourceUtil.getAbsolutePath((IStorage)rightStorage).toFile());){
                                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                            }
                            if (inputStream == null) continue;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                }
                continue;
            }
            this.markAsMerged(diff, mergeContext, subMonitor.newChild(1));
        }
    }

    private boolean isRequiredByDeletion(Diff diff) {
        if (diff.getKind() == DifferenceKind.DELETE) {
            return true;
        }
        EList requiredBy = diff.getRequiredBy();
        for (Diff requiredDiff : requiredBy) {
            if (!this.isRequiredByDeletion(requiredDiff)) continue;
            return true;
        }
        return false;
    }

    private boolean isPseudoConflicting(Diff diff) {
        Conflict conflict = diff.getConflict();
        return conflict != null && conflict.getKind() == ConflictKind.PSEUDO;
    }

    private boolean isOnlyInAdditiveConflicts(Diff diff) {
        LinkedHashSet<Conflict> checkedConflicts = new LinkedHashSet<Conflict>();
        Conflict conflict = diff.getConflict();
        boolean result = false;
        if (conflict != null && conflict.getKind() == ConflictKind.REAL && checkedConflicts.add(conflict)) {
            if (EMFComparePredicates.isAdditiveConflict().apply((Object)conflict)) {
                result = true;
            } else {
                return false;
            }
        }
        Set allRefiningDiffs = DiffUtil.getAllRefiningDiffs((Diff)diff);
        for (Diff refiningDiff : allRefiningDiffs) {
            conflict = refiningDiff.getConflict();
            if (conflict == null || conflict.getKind() != ConflictKind.REAL || !checkedConflicts.add(conflict)) continue;
            if (EMFComparePredicates.isAdditiveConflict().apply((Object)conflict)) {
                result = true;
                continue;
            }
            return false;
        }
        return result;
    }
}

