/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.graph.IGraphView;
import org.eclipse.emf.compare.internal.spec.EObjectUtil;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.match.impl.NotLoadedFragmentMatch;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.ResourceAttachmentChangeMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.internal.util.ResourceUIUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.Objects;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

public class MergeViewerItem
extends AdapterImpl
implements IMergeViewerItem {
    private final Object fLeft;
    private final Object fRight;
    private final Object fAncestor;
    private final Diff fDiff;
    private final Comparison fComparison;
    private final IMergeViewer.MergeViewerSide fSide;
    private final AdapterFactory fAdapterFactory;

    public MergeViewerItem(Comparison comparison, Diff diff, Object left, Object right, Object ancestor, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        this.fLeft = left;
        this.fRight = right;
        this.fAncestor = ancestor;
        this.fDiff = diff;
        this.fSide = side;
        this.fAdapterFactory = adapterFactory;
        this.fComparison = comparison;
    }

    public MergeViewerItem(Comparison comparison, Diff diff, Match match, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        this(comparison, diff, match.getLeft(), match.getRight(), match.getOrigin(), side, adapterFactory);
    }

    @Override
    public final Diff getDiff() {
        return this.fDiff;
    }

    @Override
    public final Object getAncestor() {
        return this.fAncestor;
    }

    @Override
    public final Object getLeft() {
        return this.fLeft;
    }

    @Override
    public final Object getRight() {
        return this.fRight;
    }

    @Override
    public final IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    @Override
    public final Object getSideValue(IMergeViewer.MergeViewerSide side) {
        switch (side) {
            case LEFT: {
                return this.fLeft;
            }
            case RIGHT: {
                return this.fRight;
            }
            case ANCESTOR: {
                return this.fAncestor;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public IMergeViewerItem.Container getParent() {
        IMergeViewerItem.Container ret = null;
        if (this.getDiff() instanceof ResourceAttachmentChange) {
            ret = this.createBasicContainer((ResourceAttachmentChange)this.getDiff());
        } else {
            Object parent;
            Object sideValue = this.getBestSideValue();
            ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.fAdapterFactory.adapt(sideValue, ITreeItemContentProvider.class);
            Object object = parent = treeItemContentProvider != null ? treeItemContentProvider.getParent(sideValue) : null;
            if (parent instanceof EObject) {
                ret = this.createBasicContainer((EObject)parent);
            }
        }
        return ret;
    }

    public IMergeViewerItem cloneAsOpposite() {
        return new MergeViewerItem(this.getComparison(), this.getDiff(), this.getLeft(), this.getRight(), this.getAncestor(), this.getSide(), this.getAdapterFactory());
    }

    protected final Object getBestSideValue() {
        Object sideValue;
        if (this.fSide != IMergeViewer.MergeViewerSide.ANCESTOR) {
            sideValue = this.getSideValue(this.fSide);
            if (sideValue == null && (sideValue = this.getSideValue(this.fSide.opposite())) == null) {
                sideValue = this.getSideValue(IMergeViewer.MergeViewerSide.ANCESTOR);
            }
        } else {
            sideValue = this.getSideValue(IMergeViewer.MergeViewerSide.ANCESTOR);
            if (sideValue == null && (sideValue = this.getSideValue(IMergeViewer.MergeViewerSide.LEFT)) == null) {
                sideValue = this.getSideValue(IMergeViewer.MergeViewerSide.RIGHT);
            }
        }
        return sideValue;
    }

    @Override
    public boolean isInsertionPoint() {
        return this.getSideValue(this.getSide()) == null && this.getDiff() != null;
    }

    public String toString() {
        String className = this.getClass().getName();
        int start = className.lastIndexOf(46);
        return Objects.toStringHelper((Object)className.substring(start + 1)).add("ancestor", (Object)EObjectUtil.getLabel((EObject)((EObject)this.getAncestor()))).add("left", (Object)EObjectUtil.getLabel((EObject)((EObject)this.getLeft()))).add("right", (Object)EObjectUtil.getLabel((EObject)((EObject)this.getRight()))).add("side", (Object)this.getSide()).add("diff", (Object)this.getDiff()).toString();
    }

    public final Comparison getComparison() {
        return this.fComparison;
    }

    protected final AdapterFactory getAdapterFactory() {
        return this.fAdapterFactory;
    }

    @Deprecated
    protected final IMergeViewerItem.Container createBasicContainer(EObject eObject) {
        IMergeViewerItem.Container ret = null;
        Match parentMatch = this.fComparison.getMatch(eObject);
        if (parentMatch == null) {
            return null;
        }
        EObject expectedValue = MergeViewerUtil.getEObject(parentMatch, this.fSide);
        if (expectedValue != null) {
            Iterable<? extends Diff> diffs = this.getDiffsWithValue(expectedValue, parentMatch);
            Diff diff = (Diff)Iterables.getFirst(diffs, null);
            ret = new Container(this.fComparison, diff, parentMatch, this.fSide, this.fAdapterFactory);
        } else {
            expectedValue = MergeViewerUtil.getEObject(parentMatch, this.fSide.opposite());
            Iterable<Object> diffs = Lists.newArrayList();
            if (expectedValue != null) {
                diffs = this.getDiffsWithValue(expectedValue, parentMatch);
            }
            if (Iterables.isEmpty((Iterable)diffs) && (expectedValue = MergeViewerUtil.getEObject(parentMatch, IMergeViewer.MergeViewerSide.ANCESTOR)) != null) {
                diffs = this.getDiffsWithValue(expectedValue, parentMatch);
            }
            if (!Iterables.isEmpty((Iterable)diffs)) {
                Diff diff = (Diff)diffs.iterator().next();
                ret = diff instanceof ResourceAttachmentChange ? new Container(this.fComparison, diff, parentMatch, this.fSide, this.fAdapterFactory) : this.createInsertionPoint(diff, this.fSide, this.fAdapterFactory);
            }
        }
        return ret;
    }

    private Iterable<? extends Diff> getDiffsWithValue(EObject expectedValue, Match parentMatch) {
        Iterable diffs = Iterables.filter((Iterable)this.fComparison.getDifferences(expectedValue), (Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE);
        if (Iterables.size((Iterable)diffs) > 1 && this.fSide != IMergeViewer.MergeViewerSide.ANCESTOR && Iterables.size((Iterable)(diffs = Iterables.filter((Iterable)diffs, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)this.fSide.convertToDifferenceSource())))) > 1) {
            throw new IllegalStateException("Should not have more than one ReferenceChange on each Match for a side");
        }
        Diff referenceChange = (Diff)Iterables.getFirst((Iterable)diffs, null);
        if (referenceChange == null) {
            diffs = Iterables.filter((Iterable)parentMatch.getDifferences(), (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class));
        }
        return diffs;
    }

    @Deprecated
    protected final IMergeViewerItem.Container createBasicContainer(ResourceAttachmentChange diff) {
        Comparison comparison = this.getComparison();
        Resource left = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.LEFT, (Diff)diff);
        Resource right = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.RIGHT, (Diff)diff);
        Resource ancestor = MergeViewerUtil.getResource(comparison, IMergeViewer.MergeViewerSide.ANCESTOR, (Diff)diff);
        ResourceAttachmentChangeMergeViewerItem ret = new ResourceAttachmentChangeMergeViewerItem(comparison, null, left, right, ancestor, this.getSide(), this.getAdapterFactory());
        return ret;
    }

    @Deprecated
    protected final List<IMergeViewerItem> createInsertionPoints(Comparison comparison, EStructuralFeature eStructuralFeature, List<? extends IMergeViewerItem> values, List<? extends Diff> differences) {
        ArrayList ret = Lists.newArrayList(values);
        if (differences.isEmpty()) {
            return ret;
        }
        List sideContent = ReferenceUtil.getAsList((EObject)((EObject)this.getSideValue(this.getSide())), (EStructuralFeature)eStructuralFeature);
        List oppositeContent = ReferenceUtil.getAsList((EObject)((EObject)this.getSideValue(this.getSide().opposite())), (EStructuralFeature)eStructuralFeature);
        for (Diff diff : Lists.reverse(differences)) {
            EObject value = (EObject)MergeViewerUtil.getDiffValue(diff);
            Match match = this.getComparison().getMatch(value);
            if (this.isPseudoAddConflict(diff) || !this.isAddOnOppositeSide(diff) && !this.isDeleteOnSameSide(diff) && !this.isInsertOnBothSides(diff, match)) continue;
            if (match == null && AbstractMerger.isInTerminalState((Diff)diff)) {
                EObject bestSideValue = (EObject)this.getBestSideValue();
                match = this.getComparison().getMatch(bestSideValue);
                match = this.getMatchWithNullValues(match);
            }
            if (match == null || this.isRealAddConflict(diff, match)) continue;
            Container insertionPoint = new Container(this.getComparison(), diff, match.getLeft(), match.getRight(), match.getOrigin(), this.getSide(), this.getAdapterFactory());
            int insertionIndex = match.getLeft() == null && match.getRight() == null && diff.getConflict() != null && diff.getConflict().getKind() == ConflictKind.PSEUDO ? ReferenceUtil.getAsList((EObject)((EObject)this.getSideValue(IMergeViewer.MergeViewerSide.ANCESTOR)), (EStructuralFeature)eStructuralFeature).indexOf(value) : Math.min(DiffUtil.findInsertionIndex((Comparison)comparison, (List)oppositeContent, (List)sideContent, (Object)value), ret.size());
            int realIndex = 0;
            int index = 0;
            while (index < insertionIndex && realIndex < ret.size()) {
                if (!((IMergeViewerItem)ret.get(realIndex)).isInsertionPoint()) {
                    ++index;
                }
                ++realIndex;
            }
            ret.add(realIndex, insertionPoint);
        }
        return ret;
    }

    private boolean isAddOnOppositeSide(Diff diff) {
        if (!AbstractMerger.isInTerminalState((Diff)diff) && diff.getKind() == DifferenceKind.ADD) {
            DifferenceSource source = diff.getSource();
            IMergeViewer.MergeViewerSide side = this.getSide();
            return source == DifferenceSource.LEFT && side == IMergeViewer.MergeViewerSide.RIGHT || source == DifferenceSource.RIGHT && side == IMergeViewer.MergeViewerSide.LEFT;
        }
        return false;
    }

    private boolean isDeleteOnSameSide(Diff diff) {
        if (!AbstractMerger.isInTerminalState((Diff)diff) && diff.getKind() == DifferenceKind.DELETE) {
            DifferenceSource source = diff.getSource();
            IMergeViewer.MergeViewerSide side = this.getSide();
            return source == DifferenceSource.LEFT && side == IMergeViewer.MergeViewerSide.LEFT || source == DifferenceSource.RIGHT && side == IMergeViewer.MergeViewerSide.RIGHT;
        }
        return false;
    }

    private boolean isInsertOnBothSides(Diff diff, Match match) {
        return AbstractMerger.isInTerminalState((Diff)diff) && (match == null || match.getLeft() == null && match.getRight() == null);
    }

    private boolean isPseudoAddConflict(Diff diff) {
        Conflict conflict = diff.getConflict();
        return conflict != null && conflict.getKind() == ConflictKind.PSEUDO && diff.getKind() == DifferenceKind.ADD;
    }

    private boolean isRealAddConflict(Diff diff, Match match) {
        return match.getRight() != null && match.getLeft() != null && this.isAddOnOppositeSide(diff);
    }

    private Match getMatchWithNullValues(Match match) {
        for (Match subMatch : match.getSubmatches()) {
            if (subMatch.getLeft() != null || subMatch.getRight() != null) continue;
            return subMatch;
        }
        return null;
    }

    private IMergeViewerItem.Container createInsertionPoint(Diff diff, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
        Object left = MergeViewerUtil.getValueFromDiff(diff, IMergeViewer.MergeViewerSide.LEFT);
        Object right = MergeViewerUtil.getValueFromDiff(diff, IMergeViewer.MergeViewerSide.RIGHT);
        Container insertionPoint = null;
        if (left != null || right != null) {
            boolean rightEmptyBox;
            boolean leftEmptyBox = side == IMergeViewer.MergeViewerSide.LEFT && (left == null || !MergeViewerUtil.getValues(diff, side).contains(left));
            boolean bl = rightEmptyBox = side == IMergeViewer.MergeViewerSide.RIGHT && (right == null || !MergeViewerUtil.getValues(diff, side).contains(right));
            if (leftEmptyBox || rightEmptyBox) {
                Object ancestor = MergeViewerUtil.getValueFromDiff(diff, IMergeViewer.MergeViewerSide.ANCESTOR);
                insertionPoint = new Container(this.getComparison(), diff, left, right, ancestor, side, adapterFactory);
            }
        }
        return insertionPoint;
    }

    @Deprecated
    protected final List<IMergeViewerItem> createMergeViewerItemFrom(Collection<?> values) {
        ArrayList ret = Lists.newArrayListWithCapacity((int)values.size());
        for (EObject value : Iterables.filter(values, EObject.class)) {
            IMergeViewerItem valueToAdd;
            Match match = this.getComparison().getMatch(value);
            if (this.fDiff == null && (match == null || this.isMatchWithAllProxyData(match)) || (valueToAdd = this.createMergeViewerItemFrom(value)) == null) continue;
            ret.add(valueToAdd);
        }
        return ret;
    }

    @Deprecated
    protected boolean yieldsMergeViewerItem(Collection<?> values) {
        Iterable elements = Iterables.filter(values, EObject.class);
        if (this.fDiff != null && !Iterables.isEmpty((Iterable)elements)) {
            return true;
        }
        for (EObject element : elements) {
            Match match = this.getComparison().getMatch(element);
            if (match == null || this.isMatchWithAllProxyData(match)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    protected boolean yieldsInsertionPoint(Iterable<Diff> diffs) {
        return Iterables.any(diffs, (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                if (MergeViewerItem.this.isPseudoAddConflict(diff)) {
                    return false;
                }
                EObject value = (EObject)MergeViewerUtil.getDiffValue(diff);
                Match match = MergeViewerItem.this.getComparison().getMatch(value);
                if (MergeViewerItem.this.isAddOnOppositeSide(diff) || MergeViewerItem.this.isDeleteOnSameSide(diff) || MergeViewerItem.this.isInsertOnBothSides(diff, match)) {
                    if (match == null && AbstractMerger.isInTerminalState((Diff)diff)) {
                        EObject bestSideValue = (EObject)MergeViewerItem.this.getBestSideValue();
                        match = MergeViewerItem.this.getComparison().getMatch(bestSideValue);
                        match = MergeViewerItem.this.getMatchWithNullValues(match);
                    }
                    return match != null && !MergeViewerItem.this.isRealAddConflict(diff, match);
                }
                return false;
            }
        });
    }

    private boolean isMatchWithAllProxyData(Match match) {
        boolean proxy = false;
        EObject left = match.getLeft();
        EObject right = match.getRight();
        EObject origin = match.getOrigin();
        if (left != null && right != null && left.eIsProxy() && right.eIsProxy()) {
            proxy = true;
        }
        if (proxy && this.fComparison.isThreeWay() && (origin == null || !origin.eIsProxy())) {
            proxy = false;
        }
        return proxy;
    }

    @Deprecated
    protected IMergeViewerItem createMergeViewerItemFrom(EObject eObject) {
        Match match = this.getComparison().getMatch(eObject);
        ReferenceChange referenceChange = (ReferenceChange)Iterables.getFirst((Iterable)Iterables.filter((Iterable)this.getComparison().getDifferences(eObject), (Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE), null);
        if (match != null) {
            return new Container(this.getComparison(), (Diff)referenceChange, match, this.getSide(), this.getAdapterFactory());
        }
        switch (this.getSide()) {
            case LEFT: {
                return new Container(this.getComparison(), (Diff)referenceChange, eObject, null, null, this.getSide(), this.getAdapterFactory());
            }
            case RIGHT: {
                return new Container(this.getComparison(), (Diff)referenceChange, null, eObject, null, this.getSide(), this.getAdapterFactory());
            }
            case ANCESTOR: {
                return new Container(this.getComparison(), (Diff)referenceChange, null, null, eObject, this.getSide(), this.getAdapterFactory());
            }
        }
        throw new IllegalStateException();
    }

    @Deprecated
    protected List<? extends Diff> filteredDiffs(Iterable<? extends Diff> unfilteredDiffs, Predicate<? super EObject> predicate, IDifferenceGroupProvider groupProvider) {
        return Lists.newArrayList((Iterable)Iterables.filter(unfilteredDiffs, this.visibleInMergeViewer(predicate, groupProvider)));
    }

    @Deprecated
    protected Predicate<Diff> visibleInMergeViewer(final Predicate<? super EObject> predicate, final IDifferenceGroupProvider groupProvider) {
        if (predicate == null) {
            return Predicates.alwaysTrue();
        }
        return new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                return MergeViewerUtil.isVisibleInMergeViewer(diff, groupProvider, (Predicate<? super EObject>)predicate);
            }
        };
    }

    @Deprecated
    public static class Container
    extends MergeViewerItem
    implements IMergeViewerItem.Container {
        private static final IMergeViewerItem[] NO_ITEMS_ARR = new IMergeViewerItem[0];

        public Container(Comparison comparison, Diff diff, Object left, Object right, Object ancestor, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
            super(comparison, diff, left, right, ancestor, side, adapterFactory);
        }

        public Container(Comparison comparison, Diff diff, Match match, IMergeViewer.MergeViewerSide side, AdapterFactory adapterFactory) {
            super(comparison, diff, match, side, adapterFactory);
        }

        public static IMergeViewerItem[] getNoItemsArr() {
            return NO_ITEMS_ARR;
        }

        @Override
        public IMergeViewerItem.Container getParent() {
            IMergeViewerItem.Container ret = null;
            if (this.getDiff() instanceof ResourceAttachmentChange) {
                ret = this.createBasicContainer((ResourceAttachmentChange)this.getDiff());
            } else {
                Object parent;
                Object sideValue = this.getBestSideValue();
                ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.getAdapterFactory().adapt(sideValue, ITreeItemContentProvider.class);
                Object object = parent = treeItemContentProvider != null ? treeItemContentProvider.getParent(sideValue) : null;
                if (parent instanceof EObject) {
                    ret = this.createBasicContainer((EObject)parent);
                } else if (parent instanceof Resource) {
                    ret = this.getParent((Resource)parent);
                } else if (sideValue instanceof NotLoadedFragmentMatch) {
                    ret = this.getParent((NotLoadedFragmentMatch)sideValue);
                }
            }
            return ret;
        }

        private IMergeViewerItem.Container getParent(Resource resource) {
            Container parent;
            URI uri = resource.getURI();
            if (ResourceUIUtil.isFragment(uri)) {
                Object object = this.getBestSideValue();
                Match matchOfValue = this.getComparison().getMatch((EObject)object);
                NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch(matchOfValue);
                parent = new Container(this.getComparison(), this.getDiff(), notLoadedFragmentMatch, notLoadedFragmentMatch, notLoadedFragmentMatch, this.getSide(), this.getAdapterFactory());
            } else {
                parent = null;
            }
            return parent;
        }

        private IMergeViewerItem.Container getParent(NotLoadedFragmentMatch nlfm) {
            IMergeViewerItem.Container parent = null;
            Collection children = nlfm.getChildren();
            for (Match match : children) {
                URI uri = ResourceUIUtil.getDataURI(match, this.getSide());
                if (uri == null) continue;
                IGraphView<URI> graph = ResourceUIUtil.getResourcesURIGraph();
                URI parentData = (URI)graph.getParentData((Object)uri);
                ResourceSet rs = ResourceUIUtil.getDataResourceSet(match, this.getSide());
                Resource resourceParent = ResourceUIUtil.getParent(rs, uri);
                while (resourceParent == null && parentData != null) {
                    resourceParent = ResourceUIUtil.getParent(rs, parentData.trimFragment());
                    parentData = (URI)graph.getParentData((Object)parentData.trimFragment());
                }
                if (resourceParent != null && parentData != null) {
                    EObject eObjectParent = resourceParent.getEObject(parentData.fragment());
                    if (eObjectParent == null) continue;
                    parent = this.createBasicContainer(eObjectParent);
                    break;
                }
                parent = this.createNotLoadedFragmentContainer(rs, uri);
                if (parent != null) break;
            }
            return parent;
        }

        private IMergeViewerItem.Container createNotLoadedFragmentContainer(ResourceSet rs, URI uri) {
            Container parent;
            URI parentURI = ResourceUIUtil.getParentResourceURI(rs, uri);
            URI rootResourceURI = ResourceUIUtil.getRootResourceURI(uri);
            if (parentURI == null) {
                parentURI = rootResourceURI;
            }
            ArrayList notLoadedFragmentMatches = Lists.newArrayList();
            EList rootMatches = this.getComparison().getMatches();
            Collection<URI> uris = ResourceUIUtil.getDataURIs((Collection<Match>)rootMatches, this.getSide());
            for (Match rootMatch : rootMatches) {
                URI rootMatchDataURI = ResourceUIUtil.getDataURI(rootMatch, this.getSide());
                if (rootResourceURI.equals(rootMatchDataURI) || parentURI.equals(rootMatchDataURI) || !ResourceUIUtil.isChildOf(rootMatchDataURI, (Collection<URI>)ImmutableSet.of((Object)parentURI)) || ResourceUIUtil.isChildOf(rootMatchDataURI, uris)) continue;
                notLoadedFragmentMatches.add(new NotLoadedFragmentMatch(rootMatch));
            }
            if (notLoadedFragmentMatches.size() > 1) {
                NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch((Collection)notLoadedFragmentMatches);
                parent = new Container(this.getComparison(), this.getDiff(), notLoadedFragmentMatch, notLoadedFragmentMatch, notLoadedFragmentMatch, this.getSide(), this.getAdapterFactory());
            } else {
                parent = null;
            }
            return parent;
        }

        @Override
        public boolean hasChildren(IDifferenceGroupProvider groupProvider, Predicate<? super EObject> predicate) {
            if (this.getLeft() instanceof NotLoadedFragmentMatch) {
                NotLoadedFragmentMatch notLoadedFragmentMatch = (NotLoadedFragmentMatch)this.getLeft();
                return !notLoadedFragmentMatch.getChildren().isEmpty();
            }
            Object sideValue = this.getSideValue(this.getSide());
            EObject bestSideValue = (EObject)this.getBestSideValue();
            Match match = this.getComparison().getMatch(bestSideValue);
            ImmutableList differences = match == null ? Collections.emptyList() : ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)match.getDifferences(), (Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE));
            Collection<? extends EStructuralFeature> childrenFeatures = this.getChildrenFeatures(bestSideValue);
            for (EStructuralFeature eStructuralFeature : childrenFeatures) {
                if (!(eStructuralFeature instanceof EReference ? this.hasChildrenOfReference(groupProvider, predicate, sideValue, (Iterable<Diff>)differences, (EReference)eStructuralFeature) : FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature) && this.hasChildrenOfFeatureMap(groupProvider, predicate, sideValue, (Iterable<Diff>)differences, eStructuralFeature))) continue;
                return true;
            }
            return this.hasNotLoadedFragmentsItems(match);
        }

        private boolean hasChildrenOfReference(IDifferenceGroupProvider groupProvider, Predicate<? super EObject> predicate, Object container, Iterable<Diff> differences, EReference reference) {
            List featureContent = ReferenceUtil.getAsList((EObject)((EObject)container), (EStructuralFeature)reference);
            if (this.yieldsMergeViewerItem(featureContent)) {
                return true;
            }
            if (this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR) {
                Iterable differencesOnFeature = Iterables.filter(differences, (Predicate)EMFComparePredicates.onFeature((String)reference.getName()));
                Iterable filteredDiffs = Iterables.filter((Iterable)differencesOnFeature, this.visibleInMergeViewer(predicate, groupProvider));
                return this.yieldsInsertionPoint(filteredDiffs);
            }
            return true;
        }

        private boolean hasChildrenOfFeatureMap(IDifferenceGroupProvider groupProvider, Predicate<? super EObject> predicate, Object container, Iterable<Diff> differences, EStructuralFeature featureMap) {
            List mapContent = ReferenceUtil.getAsList((EObject)((EObject)container), (EStructuralFeature)featureMap);
            ArrayList featureContent = Lists.newArrayList();
            LinkedHashSet derivedFeatures = Sets.newLinkedHashSet();
            for (Object object : mapContent) {
                if (!(object instanceof FeatureMap.Entry)) continue;
                featureContent.add(((FeatureMap.Entry)object).getValue());
                derivedFeatures.add(((FeatureMap.Entry)object).getEStructuralFeature());
            }
            if (this.yieldsMergeViewerItem(featureContent)) {
                return true;
            }
            if (this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR) {
                Iterable differencesOnFeature = Iterables.filter(differences, this.onFeatures(derivedFeatures));
                Iterable filteredDiffs = Iterables.filter((Iterable)differencesOnFeature, this.visibleInMergeViewer(predicate, groupProvider));
                return this.yieldsInsertionPoint(filteredDiffs);
            }
            return false;
        }

        private boolean hasNotLoadedFragmentsItems(Match match) {
            Collection<Match> childrenMatches = ResourceUIUtil.getChildrenMatchWithNotLoadedParent(this.getComparison(), match, this.getSide());
            return !childrenMatches.isEmpty();
        }

        @Override
        public IMergeViewerItem.Container cloneAsOpposite() {
            return new Container(this.getComparison(), this.getDiff(), this.getLeft(), this.getRight(), this.getAncestor(), this.getSide(), this.getAdapterFactory());
        }

        @Override
        public IMergeViewerItem[] getChildren(IDifferenceGroupProvider group, Predicate<? super EObject> predicate) {
            ArrayList ret = Lists.newArrayList();
            if (this.getLeft() instanceof NotLoadedFragmentMatch) {
                ret.addAll(this.getChildren((NotLoadedFragmentMatch)this.getLeft()));
            } else {
                Object sideValue = this.getSideValue(this.getSide());
                EObject bestSideValue = (EObject)this.getBestSideValue();
                Collection<? extends EStructuralFeature> childrenFeatures = this.getChildrenFeatures(bestSideValue);
                Match match = this.getComparison().getMatch(bestSideValue);
                ImmutableList differences = match != null ? ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)match.getDifferences(), (Predicate)EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE)) : ImmutableList.of();
                for (EStructuralFeature eStructuralFeature : childrenFeatures) {
                    if (eStructuralFeature instanceof EReference) {
                        ret.addAll(this.getChildrenOfReference(group, predicate, sideValue, (ImmutableList<Diff>)differences, (EReference)eStructuralFeature));
                        continue;
                    }
                    if (!FeatureMapUtil.isFeatureMap((EStructuralFeature)eStructuralFeature)) continue;
                    ret.addAll(this.getChildrenOfFeatureMap(group, predicate, sideValue, (ImmutableList<Diff>)differences, eStructuralFeature));
                }
                ret.addAll(this.getNotLoadedFragmentsItems(match));
            }
            return ret.toArray(NO_ITEMS_ARR);
        }

        private List<IMergeViewerItem> getChildren(NotLoadedFragmentMatch nlfm) {
            ArrayList ret = Lists.newArrayList();
            Collection matches = nlfm.getChildren();
            for (Match match : matches) {
                Container container = match instanceof NotLoadedFragmentMatch ? new Container(this.getComparison(), this.getDiff(), match, match, match, this.getSide(), this.getAdapterFactory()) : new Container(this.getComparison(), this.getDiff(), match.getLeft(), match.getRight(), match.getOrigin(), this.getSide(), this.getAdapterFactory());
                ret.add(container);
            }
            return ret;
        }

        private List<IMergeViewerItem> getNotLoadedFragmentsItems(Match match) {
            ArrayList ret = Lists.newArrayList();
            Collection<Match> childrenMatches = ResourceUIUtil.getChildrenMatchWithNotLoadedParent(this.getComparison(), match, this.getSide());
            if (childrenMatches.size() > 0) {
                boolean setNames = childrenMatches.size() > 1;
                for (Match child : childrenMatches) {
                    NotLoadedFragmentMatch notLoadedFragmentMatch = new NotLoadedFragmentMatch(child);
                    if (setNames) {
                        notLoadedFragmentMatch.setName(ResourceUIUtil.getResourceName(notLoadedFragmentMatch));
                    }
                    Container notLoadedFragmentItem = new Container(this.getComparison(), null, notLoadedFragmentMatch, notLoadedFragmentMatch, notLoadedFragmentMatch, this.getSide(), this.getAdapterFactory());
                    ret.add(notLoadedFragmentItem);
                }
            }
            return ret;
        }

        private List<IMergeViewerItem> getChildrenOfReference(IDifferenceGroupProvider group, Predicate<? super EObject> predicate, Object container, ImmutableList<Diff> differences, EReference reference) {
            ArrayList ret = Lists.newArrayList();
            List featureContent = ReferenceUtil.getAsList((EObject)((EObject)container), (EStructuralFeature)reference);
            List<IMergeViewerItem> mergeViewerItem = this.createMergeViewerItemFrom(featureContent);
            if (this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR) {
                Iterable differencesOnFeature = Iterables.filter(differences, (Predicate)EMFComparePredicates.onFeature((String)reference.getName()));
                List<? extends Diff> filteredDiffs = this.filteredDiffs(differencesOnFeature, predicate, group);
                ret.addAll(this.createInsertionPoints(this.getComparison(), (EStructuralFeature)reference, mergeViewerItem, filteredDiffs));
            } else {
                ret.addAll(mergeViewerItem);
            }
            return ret;
        }

        private List<IMergeViewerItem> getChildrenOfFeatureMap(IDifferenceGroupProvider group, Predicate<? super EObject> predicate, Object container, ImmutableList<Diff> differences, EStructuralFeature featureMap) {
            ArrayList ret = Lists.newArrayList();
            List mapContent = ReferenceUtil.getAsList((EObject)((EObject)container), (EStructuralFeature)featureMap);
            ArrayList featureContent = Lists.newArrayList();
            LinkedHashSet derivedFeatures = Sets.newLinkedHashSet();
            for (Object object : mapContent) {
                if (!(object instanceof FeatureMap.Entry)) continue;
                featureContent.add(((FeatureMap.Entry)object).getValue());
                derivedFeatures.add(((FeatureMap.Entry)object).getEStructuralFeature());
            }
            List<IMergeViewerItem> mergeViewerItem = this.createMergeViewerItemFrom(featureContent);
            if (this.getSide() != IMergeViewer.MergeViewerSide.ANCESTOR) {
                Iterable differencesOnFeature = Iterables.filter(differences, this.onFeatures(derivedFeatures));
                List<? extends Diff> filteredDiffs = this.filteredDiffs(differencesOnFeature, predicate, group);
                ret.addAll(this.createInsertionPoints(this.getComparison(), featureMap, mergeViewerItem, filteredDiffs));
            } else {
                ret.addAll(mergeViewerItem);
            }
            return ret;
        }

        private Predicate<Diff> onFeatures(Iterable<EStructuralFeature> features) {
            return Predicates.or((Iterable)Iterables.transform(features, (Function)new Function<EStructuralFeature, Predicate<? super Diff>>(){

                public Predicate<? super Diff> apply(EStructuralFeature feature) {
                    return EMFComparePredicates.onFeature((String)feature.getName());
                }
            }));
        }

        protected Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
            Collection<Object> ret = Lists.newArrayList();
            Collection<? extends EStructuralFeature> childrenFeaturesFromItemProviderAdapter = this.getChildrenFeaturesFromItemProviderAdapter(object);
            ret = childrenFeaturesFromItemProviderAdapter == null ? this.getChildrenFeaturesFromEClass(object) : childrenFeaturesFromItemProviderAdapter;
            return ret;
        }

        protected Collection<EStructuralFeature> getChildrenFeaturesFromEClass(Object object) {
            ImmutableSet.Builder features = ImmutableSet.builder();
            if (object instanceof EObject) {
                for (EReference feature : ((EObject)object).eClass().getEAllContainments()) {
                    features.add((Object)feature);
                }
            }
            return features.build();
        }

        protected Collection<? extends EStructuralFeature> getChildrenFeaturesFromItemProviderAdapter(Object object) {
            Collection ret = null;
            Object treeItemContentProvider = this.getAdapterFactory().adapt(object, ITreeItemContentProvider.class);
            if (treeItemContentProvider instanceof ItemProviderAdapter) {
                ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)treeItemContentProvider;
                try {
                    Method method = itemProviderAdapter.getClass().getMethod("getChildrenFeatures", Object.class);
                    method.setAccessible(true);
                    ret = (Collection)method.invoke((Object)itemProviderAdapter, object);
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {}
            }
            return ret;
        }
    }
}

