/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.compare.INavigatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeNonConflictingRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MergeContainedNonConflictingAction
extends MergeAction {
    private Predicate<TreeNode> isFiltered;

    private static Function<TreeNode, Iterable<Diff>> treeNodesToLeafDiffs(final Predicate<TreeNode> isFiltered) {
        return new Function<TreeNode, Iterable<Diff>>(){

            public Iterable<Diff> apply(TreeNode input) {
                TreeIterator allContents = input.eAllContents();
                ImmutableList.Builder builder = new ImmutableList.Builder();
                while (allContents.hasNext()) {
                    TreeNode treeNode;
                    EObject data;
                    EObject eObject = (EObject)allContents.next();
                    if (!(eObject instanceof TreeNode) || !((data = (EObject)IDifferenceGroup.TREE_NODE_DATA.apply((Object)(treeNode = (TreeNode)eObject))) instanceof Diff) || isFiltered.apply((Object)treeNode)) continue;
                    builder.add((Object)((Diff)data));
                }
                return builder.build();
            }
        };
    }

    public MergeContainedNonConflictingAction(IEMFCompareConfiguration compareConfiguration, IMerger.Registry mergerRegistry, MergeMode mode, INavigatable navigatable, IStructuredSelection selection, Predicate<TreeNode> isFiltered) {
        super(compareConfiguration, mergerRegistry, mode, navigatable);
        this.isFiltered = isFiltered;
        this.updateSelection(selection);
    }

    @Override
    protected void initToolTipAndImage(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: {
                this.setText(EMFCompareIDEUIMessages.getString("merged.contained.to.right.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.contained.to.right.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_all_to_right.gif"));
                break;
            }
            case RIGHT_TO_LEFT: {
                this.setText(EMFCompareIDEUIMessages.getString("merged.contained.to.left.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.contained.to.left.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_all_to_left.gif"));
                break;
            }
            case ACCEPT: {
                this.setText(EMFCompareIDEUIMessages.getString("accept.contained.changes.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("accept.contained.changes.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/accept_all_changes.gif"));
                break;
            }
            case REJECT: {
                this.setText(EMFCompareIDEUIMessages.getString("reject.contained.changes.tooltip"));
                this.setToolTipText(EMFCompareIDEUIMessages.getString("reject.contained.changes.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/reject_all_changes.gif"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    protected IMergeRunnable createMergeRunnable(MergeMode mode, boolean isLeftEditable, boolean isRightEditable) {
        return new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mode);
    }

    @Override
    protected Iterable<Diff> getSelectedDifferences(IStructuredSelection selection) {
        List selectedObjects = selection.toList();
        Iterable selectedAdapters = Iterables.filter((Iterable)selectedObjects, Adapter.class);
        Iterable selectedNotifiers = Iterables.transform((Iterable)selectedAdapters, (Function)ADAPTER__TARGET);
        Iterable selectedTreeNodes = Iterables.filter((Iterable)selectedNotifiers, TreeNode.class);
        return Iterables.concat((Iterable)Iterables.transform((Iterable)selectedTreeNodes, MergeContainedNonConflictingAction.treeNodesToLeafDiffs(this.isFiltered)));
    }
}

