/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.AbstractDecoratorManager;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.DiagramMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.DecoratorFigure;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.EdgeFigure;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.NodeFigure;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.figures.NodeListFigure;
import org.eclipse.emf.compare.diagram.internal.extensions.DiagramDiff;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.ICompareColor;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class MarkerManager
extends AbstractDecoratorManager {
    private Multimap<Diff, Marker> fMarkerRegistry = HashMultimap.create();

    public MarkerManager(EMFCompareConfiguration compareConfiguration, DiagramMergeViewer left, DiagramMergeViewer right, DiagramMergeViewer ancestor, ICompareColor color) {
        super(compareConfiguration, left, right, ancestor, color);
    }

    @Override
    protected List<View> getReferenceViews(DiagramDiff difference) {
        ArrayList<View> result = new ArrayList<View>();
        Match matchValue = this.getCompareConfiguration().getComparison().getMatch(difference.getView());
        if (matchValue != null) {
            if (matchValue.getLeft() != null) {
                result.add((View)matchValue.getLeft());
            }
            if (matchValue.getRight() != null) {
                result.add((View)matchValue.getRight());
            }
            if (this.getCompareConfiguration().getComparison().isThreeWay()) {
                switch (difference.getKind()) {
                    case DELETE: 
                    case CHANGE: 
                    case MOVE: {
                        result.add((View)matchValue.getOrigin());
                        break;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public IMergeViewer.MergeViewerSide getTargetSide(Match match, View referenceView) {
        return this.getSide(referenceView);
    }

    @Override
    protected Marker createAndRegisterDecorator(Diff diff, View referenceView, IFigure referenceFigure, IMergeViewer.MergeViewerSide targetSide) {
        Marker marker = this.createMarker(diff, referenceView, referenceFigure, targetSide);
        if (marker != null) {
            this.fMarkerRegistry.put((Object)diff, (Object)marker);
        }
        return marker;
    }

    @Override
    public void removeDecorators(Diff difference) {
        this.fMarkerRegistry.removeAll((Object)difference);
    }

    @Override
    public void removeAll() {
        this.fMarkerRegistry.clear();
    }

    protected Collection<Marker> getDecorators(Diff difference) {
        return this.fMarkerRegistry.get((Object)difference);
    }

    @Override
    protected void handleAddDecorator(AbstractDecoratorManager.AbstractDecorator decorator, IFigure parent, IFigure toAdd, boolean isMain) {
        super.handleAddDecorator(decorator, parent, toAdd, isMain);
        DiagramMergeViewer viewer = this.getViewer(decorator.getSide());
        EditPart editPart = viewer.getEditPart((EObject)decorator.getOriginView());
        if (editPart != null) {
            viewer.getGraphicalViewer().reveal(editPart);
        }
    }

    @Override
    protected Predicate<Diff> goodCandidate() {
        return new Predicate<Diff>(){

            public boolean apply(Diff difference) {
                return Predicates.instanceOf(DiagramDiff.class).apply((Object)difference);
            }
        };
    }

    private Marker createMarker(Diff diff, View referenceView, IFigure referenceFigure, IMergeViewer.MergeViewerSide side) {
        IFigure referenceLayer = this.getLayer(referenceView, side);
        if (referenceLayer != null) {
            Rectangle referenceBounds = referenceFigure.getBounds().getCopy();
            this.translateCoordinates(referenceFigure, referenceLayer, referenceBounds);
            DecoratorFigure markerFigure = null;
            Marker marker = new Marker(referenceLayer, side, referenceView, referenceFigure, diff);
            if (this.isNodeList(referenceView)) {
                markerFigure = new NodeListFigure(diff, this.isThreeWay(), this.getCompareColor(), referenceFigure, referenceBounds, false);
            } else if (referenceView instanceof Edge && referenceFigure instanceof PolylineConnection) {
                markerFigure = new EdgeFigure(diff, this.isThreeWay(), this.getCompareColor(), referenceFigure, referenceBounds, false);
            }
            if (markerFigure == null) {
                markerFigure = new NodeFigure(diff, this.isThreeWay(), this.getCompareColor(), referenceFigure, referenceBounds, false);
            }
            marker.setDecoratorFigure(markerFigure);
            return marker;
        }
        return null;
    }

    @Override
    public void hideAll() {
        for (Marker marker : this.fMarkerRegistry.values()) {
            this.handleDeleteDecorator(marker, marker.getLayer(), marker.getFigure());
        }
    }

    private class Marker
    extends AbstractDecoratorManager.AbstractDecorator {
        Marker(IFigure layer, IMergeViewer.MergeViewerSide side, View originView, IFigure originFigure, Diff diff) {
            this.setLayer(layer);
            this.setSide(side);
            this.setOriginView(originView);
            this.setOriginFigure(originFigure);
            this.setDifference(diff);
        }
    }
}

