/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property;

import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyCategoryItem;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.PropertyDescriptorItem;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.ResourcePropertyDescriptor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.property.RootPropertyItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.swt.widgets.TreeItem;

abstract class PropertyItem
extends ItemProvider
implements ITableItemLabelProvider,
ITableItemFontProvider,
IMergeViewerItem.Container {
    private static final String MISC_CATEGORY = EMFCompareIDEUIMessages.getString("PropertyContentMergeViewer.miscCategory.label");
    private static final String EXPERT_VIEW_FILTER_FLAG = "org.eclipse.ui.views.properties.expert";
    private EMFCompareConfiguration configuration;
    private IMergeViewer.MergeViewerSide side;
    protected PropertyItem ancestor;
    protected PropertyItem left;
    protected PropertyItem right;

    public static PropertyItem createPropertyItem(EMFCompareConfiguration configuration, Object object, IMergeViewer.MergeViewerSide side) {
        List<IItemPropertyDescriptor> propertyDescriptors;
        RootPropertyItem rootItem;
        if (configuration.getAdapterFactory() != null) {
            AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator(configuration.getAdapterFactory());
            rootItem = new RootPropertyItem(configuration, itemDelegator.getImage(object), itemDelegator.getText(object), object, side);
            propertyDescriptors = PropertyItem.getPropertyDescriptors(object, itemDelegator);
        } else {
            rootItem = new RootPropertyItem(configuration, null, "", object, side);
            propertyDescriptors = null;
        }
        PropertyItem.populateRootPropertyItem(rootItem, propertyDescriptors, object, configuration, side);
        return rootItem;
    }

    private static List<IItemPropertyDescriptor> getPropertyDescriptors(Object object, AdapterFactoryItemDelegator itemDelegator) {
        List<ResourcePropertyDescriptor> propertyDescriptors = object instanceof Resource ? Collections.singletonList(new ResourcePropertyDescriptor((Resource)object, itemDelegator)) : itemDelegator.getPropertyDescriptors(object);
        return propertyDescriptors;
    }

    private static void populateRootPropertyItem(PropertyItem rootItem, List<IItemPropertyDescriptor> propertyDescriptors, Object object, EMFCompareConfiguration configuration, IMergeViewer.MergeViewerSide side) {
        if (propertyDescriptors == null) {
            return;
        }
        Map<EStructuralFeature, Multimap<Object, Diff>> featureDiffs = PropertyItem.buildFeatureToDiffMap(object, configuration);
        TreeMap categories = Maps.newTreeMap();
        for (IItemPropertyDescriptor propertyDescriptor : propertyDescriptors) {
            PropertyItem.addChildPropertyItem(categories, propertyDescriptor, object, configuration, featureDiffs, side);
        }
        EList<PropertyItem> children = rootItem.getPropertyItems();
        if (PropertyItem.shouldShowCategories(configuration) && (categories.size() > 1 || categories.size() == 1 && categories.get(MISC_CATEGORY) == null)) {
            for (Map.Entry entry : categories.entrySet()) {
                PropertyCategoryItem categoryItem = new PropertyCategoryItem(configuration, (String)entry.getKey(), side);
                children.add((Object)categoryItem);
                categoryItem.getChildren().addAll(((Map)entry.getValue()).values());
            }
        } else {
            TreeMap sortedItems = Maps.newTreeMap();
            for (Map items : categories.values()) {
                sortedItems.putAll(items);
            }
            children.addAll(sortedItems.values());
        }
    }

    private static void addChildPropertyItem(Map<String, Map<String, PropertyItem>> categories, IItemPropertyDescriptor itemPropertyDescriptor, Object object, EMFCompareConfiguration configuration, Map<EStructuralFeature, Multimap<Object, Diff>> featureDiffs, IMergeViewer.MergeViewerSide side) {
        String[] filterFlags;
        if (!PropertyItem.shouldShowAdvancedProperties(configuration) && (filterFlags = itemPropertyDescriptor.getFilterFlags(object)) != null) {
            String[] stringArray = filterFlags;
            int n = filterFlags.length;
            int n2 = 0;
            while (n2 < n) {
                String filterFlag = stringArray[n2];
                if (EXPERT_VIEW_FILTER_FLAG.equals(filterFlag)) {
                    return;
                }
                ++n2;
            }
        }
        Object feature = itemPropertyDescriptor.getFeature(object);
        Multimap<Object, Diff> diffs = featureDiffs.remove(feature);
        PropertyDescriptorItem childItem = new PropertyDescriptorItem(configuration, object, diffs, itemPropertyDescriptor, side);
        String category = PropertyItem.determineCategory(object, itemPropertyDescriptor);
        TreeMap items = categories.get(category);
        if (items == null) {
            items = Maps.newTreeMap();
            categories.put(category, items);
        }
        items.put(itemPropertyDescriptor.getDisplayName(object), childItem);
    }

    private static String determineCategory(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
        String category = itemPropertyDescriptor.getCategory(object);
        if (category == null) {
            category = MISC_CATEGORY;
        }
        return category;
    }

    private static boolean shouldShowCategories(EMFCompareConfiguration configuration) {
        return configuration.getBooleanProperty(PropertyContentMergeViewer.SHOW_CATEGORIES, true);
    }

    public static Match getMatch(EMFCompareConfiguration configuration, Object object) {
        Match match = null;
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            match = configuration.getComparison().getMatch(eObject);
        }
        return match;
    }

    private static boolean shouldShowAdvancedProperties(EMFCompareConfiguration configuration) {
        return configuration.getBooleanProperty(PropertyContentMergeViewer.SHOW_ADVANCED_PROPERTIES, false);
    }

    private static Map<EStructuralFeature, Multimap<Object, Diff>> buildFeatureToDiffMap(Object object, EMFCompareConfiguration configuration) {
        Match match = PropertyItem.getMatch(configuration, object);
        if (match == null || !(object instanceof EObject)) {
            return Maps.newHashMap();
        }
        HashMap featureDiffs = Maps.newHashMap();
        for (Diff diff : match.getDifferences()) {
            EStructuralFeature eStructuralFeature = MergeViewerUtil.getAffectedFeature((Diff)diff);
            if (eStructuralFeature == null) continue;
            Multimap diffs = (Multimap)featureDiffs.get(eStructuralFeature);
            if (diffs == null) {
                diffs = HashMultimap.create();
                featureDiffs.put(eStructuralFeature, diffs);
            }
            Object value = MatchUtil.getValue((Diff)diff);
            IMergeViewer.MergeViewerSide[] mergeViewerSideArray = PropertyContentMergeViewer.MERGE_VIEWER_SIDES;
            int n = PropertyContentMergeViewer.MERGE_VIEWER_SIDES.length;
            int n2 = 0;
            while (n2 < n) {
                IMergeViewer.MergeViewerSide valueSide = mergeViewerSideArray[n2];
                EObject sideEObject = MergeViewerUtil.getEObject((Match)match, (IMergeViewer.MergeViewerSide)valueSide);
                if (sideEObject != null) {
                    List sideValues = ReferenceUtil.getAsList((EObject)sideEObject, (EStructuralFeature)eStructuralFeature);
                    if (eStructuralFeature.isMany()) {
                        Object sideValue = MergeViewerUtil.matchingValue((Object)value, (Comparison)configuration.getComparison(), (List)sideValues);
                        if (sideValue != null) {
                            diffs.put(sideValue, (Object)diff);
                        }
                    } else if (sideValues.isEmpty()) {
                        diffs.put(null, (Object)diff);
                    } else {
                        diffs.put(sideValues.get(0), (Object)diff);
                    }
                }
                ++n2;
            }
        }
        return featureDiffs;
    }

    public PropertyItem(EMFCompareConfiguration configuration, Object image, String text, IMergeViewer.MergeViewerSide side) {
        super(text, image);
        this.configuration = configuration;
        this.side = side;
        this.setSidePropertyItem(side, this);
    }

    public PropertyItem getSide(IMergeViewer.MergeViewerSide anySide) {
        switch (anySide) {
            case ANCESTOR: {
                return this.ancestor;
            }
            case LEFT: {
                return this.left;
            }
        }
        return this.right;
    }

    public void reconcile(PropertyItem newLeftSide, PropertyItem newRightSide) {
        this.associate(IMergeViewer.MergeViewerSide.LEFT, newLeftSide);
        this.associate(IMergeViewer.MergeViewerSide.RIGHT, newRightSide);
        if (newLeftSide != null) {
            newLeftSide.associate(IMergeViewer.MergeViewerSide.RIGHT, newRightSide);
            this.reconcile(newLeftSide.getPropertyItems());
        }
        if (newRightSide != null) {
            this.reconcile(newRightSide.getPropertyItems());
        }
        if (newLeftSide != null && newRightSide != null) {
            newLeftSide.reconcile(newRightSide.getPropertyItems());
        }
        for (PropertyItem propertyItem : this.getPropertyItems()) {
            propertyItem.reconcile();
        }
        if (newLeftSide != null) {
            for (PropertyItem propertyItem : newLeftSide.getPropertyItems()) {
                propertyItem.reconcile();
            }
        }
        if (newRightSide != null) {
            for (PropertyItem propertyItem : newRightSide.getPropertyItems()) {
                propertyItem.reconcile();
            }
        }
    }

    private void associate(IMergeViewer.MergeViewerSide otherSide, PropertyItem propertyItem) {
        this.setSidePropertyItem(this.side, this);
        this.setSidePropertyItem(otherSide, propertyItem);
        if (propertyItem != null) {
            propertyItem.setSidePropertyItem(this.side, this);
            propertyItem.setSidePropertyItem(otherSide, propertyItem);
        }
    }

    private void setSidePropertyItem(IMergeViewer.MergeViewerSide otherSide, PropertyItem propertyItem) {
        switch (otherSide) {
            case ANCESTOR: {
                this.ancestor = propertyItem;
                break;
            }
            case LEFT: {
                this.left = propertyItem;
                break;
            }
            case RIGHT: {
                this.right = propertyItem;
            }
        }
    }

    private void reconcile(EList<PropertyItem> otherPropertyItems) {
        EList<PropertyItem> propertyItems = this.getPropertyItems();
        ArrayList remainingOtherPropertyItems = Lists.newArrayList(otherPropertyItems);
        for (PropertyItem propertyItem : propertyItems) {
            propertyItem.findMatchingItem(remainingOtherPropertyItems, true);
        }
    }

    protected void reconcile() {
        switch (this.side) {
            case ANCESTOR: {
                if (this.left != null) {
                    this.reconcile(this.left.getPropertyItems());
                }
                if (this.right == null) break;
                this.reconcile(this.right.getPropertyItems());
                break;
            }
            case LEFT: {
                if (this.right == null) break;
                this.left.reconcile(this.right.getPropertyItems());
            }
        }
        for (PropertyItem propertyItem : this.getPropertyItems()) {
            propertyItem.reconcile();
        }
    }

    private PropertyItem findMatchingItem(List<? extends PropertyItem> propertyItems, boolean associate) {
        for (PropertyItem propertyItem : propertyItems) {
            if (!this.isMatchingItem(propertyItem)) continue;
            if (associate) {
                this.associate(propertyItem.side, propertyItem);
                propertyItems.remove((Object)propertyItem);
            }
            return propertyItem;
        }
        return null;
    }

    protected abstract boolean isMatchingItem(PropertyItem var1);

    protected boolean isMatchingValue(Object value1, Object value2) {
        IEqualityHelper equalityHelper = this.configuration.getComparison().getEqualityHelper();
        return equalityHelper.matchingValues(value1, value2);
    }

    public PropertyItem findItem(PropertyItem propertyItem) {
        PropertyItem propertyItemParent = propertyItem.getParent();
        if (propertyItemParent == null) {
            return this;
        }
        PropertyItem foundParent = this.findItem(propertyItemParent);
        PropertyItem findMatchingItem = propertyItem.findMatchingItem((List<? extends PropertyItem>)foundParent.getPropertyItems(), false);
        if (findMatchingItem == null) {
            return this;
        }
        return findMatchingItem;
    }

    public EList<PropertyItem> getPropertyItems() {
        return this.children;
    }

    protected boolean isModified() {
        return false;
    }

    public PropertyItem getParent() {
        return (PropertyItem)((Object)super.getParent());
    }

    protected abstract Object getObject();

    public PropertyItem getRootItem() {
        PropertyItem rootItem = this;
        while (rootItem.getParent() != null) {
            rootItem = rootItem.getParent();
        }
        return rootItem;
    }

    public void update(TreeItem treeItem, boolean expanded) {
    }

    protected String getPropertyText() {
        return "";
    }

    protected Object getPropertyImage() {
        return null;
    }

    public String getColumnText(Object object, int columnIndex) {
        if (columnIndex == 0) {
            return this.getText(object);
        }
        return this.getPropertyText();
    }

    public Object getColumnImage(Object object, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(object);
        }
        return this.getPropertyImage();
    }

    public Object getFont(Object object, int columnIndex) {
        if (this.isModified()) {
            return IItemFontProvider.BOLD_FONT;
        }
        return null;
    }

    public Diff getDiff() {
        return null;
    }

    public Object getLeft() {
        if (this.left != null) {
            return this.left.getObject();
        }
        return null;
    }

    public Object getRight() {
        if (this.right != null) {
            return this.right.getObject();
        }
        return null;
    }

    public Object getAncestor() {
        if (this.ancestor != null) {
            return this.ancestor.getObject();
        }
        return null;
    }

    public Object getSideValue(IMergeViewer.MergeViewerSide anySide) {
        switch (anySide) {
            case ANCESTOR: {
                return this.getAncestor();
            }
            case LEFT: {
                return this.getLeft();
            }
        }
        return this.getRight();
    }

    public IMergeViewer.MergeViewerSide getSide() {
        return this.side;
    }

    public boolean isInsertionPoint() {
        return false;
    }

    public void notifyChanged(Notification notification) {
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public boolean hasChildren(IDifferenceGroupProvider group, Predicate<? super EObject> predicate) {
        return false;
    }

    public IMergeViewerItem[] getChildren(IDifferenceGroupProvider group, Predicate<? super EObject> predicate) {
        return null;
    }

    public EMFCompareConfiguration getConfiguration() {
        return this.configuration;
    }
}

