/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.edit;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.provider.MatchItemProvider;
import org.eclipse.emf.compare.provider.spec.MatchItemProviderSpec;
import org.eclipse.emf.compare.tests.edit.AbstractTestCompareItemProviderAdapter;
import org.eclipse.emf.compare.tests.edit.data.ecore.a1.EcoreA1InputData;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestMatchItemProviderSpec
extends AbstractTestCompareItemProviderAdapter {
    private MatchItemProvider itemProvider;

    @Override
    @Before
    public void before() throws IOException {
        super.before();
        this.itemProvider = (MatchItemProviderSpec)this.compareItemProviderAdapterFactory.createMatchAdapter();
    }

    @Test
    public void testGetChildren_EcoreA1() throws IOException {
        Match ePackageMatch = TestMatchItemProviderSpec.getEcoreA1_EPackageMatch();
        Collection ePackageMatchChildren = this.itemProvider.getChildren((Object)ePackageMatch);
        Assert.assertEquals((long)22L, (long)ePackageMatchChildren.size());
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)ePackageMatchChildren, Diff.class)));
        Assert.assertEquals((long)18L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)ePackageMatchChildren, Match.class)));
    }

    static Match getEcoreA1_EPackageMatch() throws IOException {
        Comparison comparison = TestMatchItemProviderSpec.getComparison(new EcoreA1InputData());
        EList matches = comparison.getMatches();
        Match ePackageMatch = (Match)matches.get(0);
        return ePackageMatch;
    }

    @Test
    public void testGetChildren_AudioVisualItem() throws IOException {
        Match ePackageMatch = TestMatchItemProviderSpec.getEcoreA1_EPackageMatch();
        Collection ePackage_MatchChildren = this.itemProvider.getChildren((Object)ePackageMatch);
        Match audioVisualItem_Match = this.getMatchWithFeatureValue(ePackage_MatchChildren, "name", "AudioVisualItem");
        Collection audioVisualItem_MatchChildren = this.itemProvider.getChildren((Object)audioVisualItem_Match);
        Assert.assertEquals((long)5L, (long)audioVisualItem_MatchChildren.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)audioVisualItem_MatchChildren, Diff.class)));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)audioVisualItem_MatchChildren, Match.class)));
    }

    @Test
    public void testGetChildren_AudioVisualItem_lenght() throws IOException {
        Match ePackageMatch = TestMatchItemProviderSpec.getEcoreA1_EPackageMatch();
        Collection ePackage_MatchChildren = this.itemProvider.getChildren((Object)ePackageMatch);
        Match audioVisualItem_Match = this.getMatchWithFeatureValue(ePackage_MatchChildren, "name", "AudioVisualItem");
        Collection audioVisualItem_MatchChildren = this.itemProvider.getChildren((Object)audioVisualItem_Match);
        Match audioVisualItem_legnth_Match = this.getMatchWithFeatureValue(audioVisualItem_MatchChildren, "name", "length");
        Collection audioVisualItem_legnth_MatchChildren = this.itemProvider.getChildren((Object)audioVisualItem_legnth_Match);
        Assert.assertEquals((long)2L, (long)audioVisualItem_legnth_MatchChildren.size());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)audioVisualItem_legnth_MatchChildren, Diff.class)));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)audioVisualItem_legnth_MatchChildren, Match.class)));
    }

    @Test
    public void testGetChildren_Book() throws IOException {
        Match ePackageMatch = TestMatchItemProviderSpec.getEcoreA1_EPackageMatch();
        Collection ePackage_MatchChildren = this.itemProvider.getChildren((Object)ePackageMatch);
        Match book_Match = this.getMatchWithFeatureValue(ePackage_MatchChildren, "name", "Book");
        Collection book_MatchChildren = this.itemProvider.getChildren((Object)book_Match);
        Assert.assertEquals((long)8L, (long)book_MatchChildren.size());
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)book_MatchChildren, Diff.class)));
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)book_MatchChildren, Match.class)));
    }

    @Test
    public void testGetChildren_BookCategory() throws IOException {
        Match ePackageMatch = TestMatchItemProviderSpec.getEcoreA1_EPackageMatch();
        Collection ePackage_MatchChildren = this.itemProvider.getChildren((Object)ePackageMatch);
        Match bookCategory_Match = this.getMatchWithFeatureValue(ePackage_MatchChildren, "name", "BookCategory");
        Collection bookCategory_MatchChildren = this.itemProvider.getChildren((Object)bookCategory_Match);
        Assert.assertEquals((long)11L, (long)bookCategory_MatchChildren.size());
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)bookCategory_MatchChildren, Diff.class)));
        Assert.assertEquals((long)7L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)bookCategory_MatchChildren, Match.class)));
    }

    @Test
    public void testGetChildren_Borrowable() throws IOException {
        Match ePackageMatch = TestMatchItemProviderSpec.getEcoreA1_EPackageMatch();
        Collection ePackage_MatchChildren = this.itemProvider.getChildren((Object)ePackageMatch);
        Match borrowable_Match = this.getMatchWithFeatureValue(ePackage_MatchChildren, "name", "Borrowable");
        Collection borrowable_MatchChildren = this.itemProvider.getChildren((Object)borrowable_Match);
        Assert.assertEquals((long)3L, (long)borrowable_MatchChildren.size());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)borrowable_MatchChildren, Diff.class)));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)borrowable_MatchChildren, Match.class)));
    }

    @Test
    public void testGetChildren_Person() throws IOException {
        Match ePackageMatch = TestMatchItemProviderSpec.getEcoreA1_EPackageMatch();
        Collection ePackage_MatchChildren = this.itemProvider.getChildren((Object)ePackageMatch);
        Match person_Match = this.getMatchWithFeatureValue(ePackage_MatchChildren, "name", "Person");
        Collection person_MatchChildren = this.itemProvider.getChildren((Object)person_Match);
        Assert.assertEquals((long)6L, (long)person_MatchChildren.size());
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)person_MatchChildren, Diff.class)));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)Iterables.filter((Iterable)person_MatchChildren, Match.class)));
    }
}

