/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.merge;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitMergeStrategyID;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitTestRunner;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.GitTestSupport;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitInput;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitMerge;
import org.eclipse.emf.compare.ide.ui.tests.git.framework.annotations.GitMergeStrategy;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.Repository;
import org.junit.Assert;
import org.junit.runner.RunWith;

@RunWith(value=GitTestRunner.class)
@GitMergeStrategy(value=GitMergeStrategyID.MODEL_ADDITIVE)
public class AdditiveMergeTests {
    @GitMerge(local="branch1", remote="branch2")
    @GitInput(value="data/additive/ecore.zip")
    public void testAdditiveMergeEcore1(Status status, Repository repository, List<IProject> projects, GitTestSupport support) throws Exception {
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertEquals((long)0L, (long)status.getConflicting().size());
        Comparison comparison = support.compare("branch1", "expected", "network.ecore");
        Assert.assertTrue((boolean)Iterables.all((Iterable)comparison.getDifferences(), (Predicate)Predicates.or((Predicate)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}), (Predicate)EMFComparePredicates.isInRealAddAddConflict())));
    }

    @GitMerge(local="branch2", remote="branch1")
    @GitInput(value="data/additive/ecore.zip")
    public void testAdditiveMergeEcore2(Status status, Repository repository, List<IProject> projects, GitTestSupport support) throws Exception {
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertEquals((long)0L, (long)status.getConflicting().size());
        Comparison comparison = support.compare("branch2", "expected", "network.ecore");
        Assert.assertTrue((boolean)Iterables.all((Iterable)comparison.getDifferences(), (Predicate)Predicates.or((Predicate)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}), (Predicate)EMFComparePredicates.isInRealAddAddConflict())));
    }

    @GitMerge(local="branch1", remote="branch2")
    @GitInput(value="data/additive/uml.zip")
    public void testAdditiveMergeUml1(Status status, Repository repository, List<IProject> projects, GitTestSupport support) throws Exception {
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertEquals((long)0L, (long)status.getConflicting().size());
        Comparison comparison = support.compare("branch1", "expected", "network.uml");
        Assert.assertTrue((boolean)Iterables.all((Iterable)comparison.getDifferences(), (Predicate)Predicates.or((Predicate)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}), (Predicate)EMFComparePredicates.isInRealAddAddConflict())));
    }

    @GitMerge(local="branch2", remote="branch1")
    @GitInput(value="data/additive/uml.zip")
    public void testAdditiveMergeUml2(Status status, Repository repository, List<IProject> projects, GitTestSupport support) throws Exception {
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
        Assert.assertEquals((long)0L, (long)status.getConflicting().size());
        Comparison comparison = support.compare("branch2", "expected", "network.uml");
        Assert.assertTrue((boolean)Iterables.all((Iterable)comparison.getDifferences(), (Predicate)Predicates.or((Predicate)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}), (Predicate)EMFComparePredicates.isInRealAddAddConflict())));
    }
}

