/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.papyrus.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.diagram.papyrus.ComparePapyrusMessages;
import org.eclipse.emf.compare.diagram.papyrus.internal.CompareDiagramPapyrusPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;

public final class ModelExtensionUtil {
    private static final String FILE_EXTENSION_ATTRIBUTE = "fileExtension";
    private static final String CLASSNAME_ATTRIBUTE = "classname";
    private static final String SAVE_PARAMETERS_METHOD = "getSaveOptions";

    private ModelExtensionUtil() {
    }

    public static IConfigurationElement[] getModelExtensions() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.core", "model");
    }

    public static Collection<String> getRegisteredFileExtensions() {
        IConfigurationElement[] modelExtensions;
        LinkedHashSet<String> fileExtensions = new LinkedHashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = modelExtensions = ModelExtensionUtil.getModelExtensions();
        int n = modelExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileExtension;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("model".equals(element.getName()) && (fileExtension = element.getAttribute(FILE_EXTENSION_ATTRIBUTE)) != null) {
                fileExtensions.add(fileExtension);
            }
            ++n2;
        }
        return fileExtensions;
    }

    public static Map<?, ?> getSaveParameters(String resourceExtension) {
        IConfigurationElement[] modelExtensions = ModelExtensionUtil.getModelExtensions();
        Map saveOptions = Collections.EMPTY_MAP;
        IConfigurationElement[] iConfigurationElementArray = modelExtensions;
        int n = modelExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            String fileExtension;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("model".equals(element.getName()) && (fileExtension = element.getAttribute(FILE_EXTENSION_ATTRIBUTE)) != null && fileExtension.equals(resourceExtension)) {
                try {
                    IModel imodel = (IModel)element.createExecutableExtension(CLASSNAME_ATTRIBUTE);
                    if (!(imodel instanceof AbstractBaseModel)) break;
                    try {
                        AbstractBaseModel model = (AbstractBaseModel)imodel;
                        Method getSaveParametersMethod = model.getClass().getDeclaredMethod(SAVE_PARAMETERS_METHOD, new Class[0]);
                        getSaveParametersMethod.setAccessible(true);
                        saveOptions = (Map)getSaveParametersMethod.invoke((Object)model, new Object[0]);
                    }
                    catch (Exception e) {
                        return ModelExtensionUtil.getDefaultSaveOptions();
                    }
                }
                catch (CoreException e) {
                    CompareDiagramPapyrusPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.compare.diagram.papyrus", ComparePapyrusMessages.getString("ModelExtensionUtil.InvalidConfig", fileExtension)));
                }
                break;
            }
            ++n2;
        }
        if (saveOptions == null) {
            saveOptions = Collections.EMPTY_MAP;
        }
        return saveOptions;
    }

    private static Map<?, ?> getDefaultSaveOptions() {
        DefaultSaveOptionsClass saveOptions = new DefaultSaveOptionsClass();
        return saveOptions.getMyDefaultSaveOptions();
    }

    private static class DefaultSaveOptionsClass
    extends AbstractBaseModel {
        private DefaultSaveOptionsClass() {
        }

        public Map<?, ?> getMyDefaultSaveOptions() {
            return this.getSaveOptions();
        }

        protected String getModelFileExtension() {
            return null;
        }

        public String getIdentifier() {
            return null;
        }

        public boolean canPersist(EObject eObject) {
            return false;
        }

        public void persist(EObject eObject) {
        }
    }
}

