/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer;

import java.lang.reflect.Field;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;

public class MirrorUtil {
    public static final String CONFIG_MIRRORED = "MIRRORED";
    public static final String PREF_MIRRORED = "org.eclipse.compare.Swapped";
    public static final String SWITCH_LEFT_RIGHT_ACTION = "fSwitchLeftAndRight";

    public static Action getAction(ContentMergeViewer contentMergeViewer) {
        if (contentMergeViewer == null) {
            return null;
        }
        try {
            Field declaredField = ContentMergeViewer.class.getDeclaredField(SWITCH_LEFT_RIGHT_ACTION);
            declaredField.setAccessible(true);
            Object action = declaredField.get(contentMergeViewer);
            if (action != null && action instanceof Action) {
                return (Action)action;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            // empty catch block
        }
        return null;
    }

    public static Action removeFromToolBar(ContentMergeViewer contentMergeViewer, ToolBarManager toolBarManager) {
        Action switchLeftAndRightAction = MirrorUtil.getAction(contentMergeViewer);
        if (switchLeftAndRightAction != null && toolBarManager != null) {
            IContributionItem[] items;
            IContributionItem[] iContributionItemArray = items = toolBarManager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action;
                IContributionItem iContributionItem = iContributionItemArray[n2];
                if (iContributionItem instanceof ActionContributionItem && switchLeftAndRightAction == (action = ((ActionContributionItem)iContributionItem).getAction())) {
                    toolBarManager.remove(iContributionItem);
                }
                ++n2;
            }
        }
        return switchLeftAndRightAction;
    }

    public static boolean isMirrored(CompareConfiguration compareConfiguration) {
        if (compareConfiguration == null) {
            return false;
        }
        boolean isMirrored = false;
        Object value = compareConfiguration.getProperty(CONFIG_MIRRORED);
        if (value instanceof Boolean) {
            isMirrored = (Boolean)value;
        }
        return isMirrored;
    }

    public static void setMirrored(EMFCompareConfiguration compareConfiguration, boolean mirrored) {
        compareConfiguration.setProperty(CONFIG_MIRRORED, mirrored);
    }

    public static boolean isMirroredProperty(String configProperty) {
        return CONFIG_MIRRORED.equals(configProperty);
    }

    public static boolean isMirroredPreference(String preferenceProperty) {
        return PREF_MIRRORED.equals(preferenceProperty);
    }
}

