/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.diff;

import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.spec.DiffSpec;
import org.eclipse.emf.compare.merge.CachingDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.ComputeDiffsToMerge;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.merge.IMerger2;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DiffRelationshipComputerTest {
    protected static boolean MERGE_RIGHT_TO_LEFT = true;
    protected IMerger.Registry2 mergerRegistry;
    protected IMerger2 merger;
    protected Comparison comparison;
    protected Match match;
    protected Diff diff;
    protected Diff mergeDependency;
    protected Diff resultingMerge;
    protected Diff resultingRejection;

    @Before
    public void setupClass() {
        this.mergerRegistry = DiffRelationshipComputerTest.createMergerRegistry();
        this.comparison = DiffRelationshipComputerTest.createComparison();
        this.match = DiffRelationshipComputerTest.createMatch();
        this.comparison.getMatches().add((Object)this.match);
        this.diff = DiffRelationshipComputerTest.createDiff(this.match);
        this.comparison.getDifferences().add((Object)this.diff);
        this.mergeDependency = DiffRelationshipComputerTest.createDiff(this.match);
        this.comparison.getDifferences().add((Object)this.mergeDependency);
        this.resultingMerge = DiffRelationshipComputerTest.createDiff(this.match);
        this.comparison.getDifferences().add((Object)this.resultingMerge);
        this.resultingRejection = DiffRelationshipComputerTest.createDiff(this.match);
        this.comparison.getDifferences().add((Object)this.resultingRejection);
        this.merger = DiffRelationshipComputerTest.mockMerger(this.diff, this.mergeDependency, this.resultingMerge, this.resultingRejection, 1000, (IMerger.Registry)this.mergerRegistry);
        this.mergerRegistry.add((IMerger)this.merger);
    }

    protected CachingDiffRelationshipComputer getDiffRelationshipComputer() {
        return new CachingDiffRelationshipComputer((IMerger.Registry)this.mergerRegistry);
    }

    @Test
    public void testDirectMergeDependencies() {
        CachingDiffRelationshipComputer computer = this.getDiffRelationshipComputer();
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.verifyDirectMergeDependenciesCalledExactly(1);
    }

    @Test
    public void testDirectResultingMerges() {
        CachingDiffRelationshipComputer computer = this.getDiffRelationshipComputer();
        this.assertDirectResultingMerges(computer.getDirectResultingMerges(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectResultingMerges(computer.getDirectResultingMerges(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectResultingMerges(computer.getDirectResultingMerges(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectResultingMerges(computer.getDirectResultingMerges(this.diff, MERGE_RIGHT_TO_LEFT));
        this.verifyDirectResultingMergesCalledExactly(1);
    }

    @Test
    public void testDirectResultingRejections() {
        CachingDiffRelationshipComputer computer = this.getDiffRelationshipComputer();
        this.assertDirectResultingRejections(computer.getDirectResultingRejections(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectResultingRejections(computer.getDirectResultingRejections(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectResultingRejections(computer.getDirectResultingRejections(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectResultingRejections(computer.getDirectResultingRejections(this.diff, MERGE_RIGHT_TO_LEFT));
        this.verifyDirectResultingRejectionsCalledExactly(1);
    }

    @Test
    public void testAllResultingMerges() {
        CachingDiffRelationshipComputer computer = this.getDiffRelationshipComputer();
        this.assertAllResultingMerges(computer.getAllResultingMerges(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertAllResultingMerges(computer.getAllResultingMerges(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertAllResultingMerges(computer.getAllResultingMerges(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertAllResultingMerges(computer.getAllResultingMerges(this.diff, MERGE_RIGHT_TO_LEFT));
        this.verifyMergerCalculationsCalledAtMostOnce();
    }

    @Test
    public void testAllResultingRejections() {
        CachingDiffRelationshipComputer computer = this.getDiffRelationshipComputer();
        this.assertAllResultingRejections(computer.getAllResultingRejections(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertAllResultingRejections(computer.getAllResultingRejections(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertAllResultingRejections(computer.getAllResultingRejections(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertAllResultingRejections(computer.getAllResultingRejections(this.diff, MERGE_RIGHT_TO_LEFT));
        this.verifyMergerCalculationsCalledAtMostOnce();
    }

    @Test
    public void testInvalidateCache() {
        CachingDiffRelationshipComputer computer = this.getDiffRelationshipComputer();
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.verifyDirectMergeDependenciesCalledExactly(1);
        computer.invalidate();
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.verifyDirectMergeDependenciesCalledExactly(2);
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.verifyDirectMergeDependenciesCalledExactly(2);
        computer.invalidate();
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.assertDirectMergeDependencies(computer.getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT));
        this.verifyDirectMergeDependenciesCalledExactly(3);
    }

    @Test
    public void testComputeDiffsToMergeIntegration() {
        ComputeDiffsToMerge computer = new ComputeDiffsToMerge(MERGE_RIGHT_TO_LEFT, (IDiffRelationshipComputer)new CachingDiffRelationshipComputer((IMerger.Registry)this.mergerRegistry));
        this.assertAllResultingMerges(computer.getAllDiffsToMerge(this.diff));
        this.assertAllResultingMerges(computer.getAllDiffsToMerge(this.diff));
        this.assertAllResultingMerges(computer.getAllDiffsToMerge(this.diff));
        this.assertAllResultingMerges(computer.getAllDiffsToMerge(this.diff));
        this.verifyMergerCalculationsCalledAtMostOnce();
    }

    protected void verifyMergerCalculationsCalledAtMostOnce() {
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.atMost((int)1))).getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT);
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.atMost((int)1))).getDirectResultingMerges(this.diff, MERGE_RIGHT_TO_LEFT);
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.atMost((int)1))).getDirectResultingRejections(this.diff, MERGE_RIGHT_TO_LEFT);
    }

    protected void verifyDirectMergeDependenciesCalledExactly(int times) {
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.times((int)times))).getDirectMergeDependencies(this.diff, MERGE_RIGHT_TO_LEFT);
    }

    protected void verifyDirectResultingMergesCalledExactly(int times) {
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.times((int)times))).getDirectResultingMerges(this.diff, MERGE_RIGHT_TO_LEFT);
    }

    protected void verifyDirectResultingRejectionsCalledExactly(int times) {
        ((IMerger2)Mockito.verify((Object)this.merger, (VerificationMode)Mockito.times((int)times))).getDirectResultingRejections(this.diff, MERGE_RIGHT_TO_LEFT);
    }

    protected void assertDirectMergeDependencies(Set<Diff> mergeDependencies) {
        Assert.assertEquals((long)1L, (long)mergeDependencies.size());
        Assert.assertTrue((boolean)mergeDependencies.contains(this.mergeDependency));
    }

    protected void assertDirectResultingRejections(Set<Diff> resultingRejections) {
        Assert.assertEquals((long)1L, (long)resultingRejections.size());
        Assert.assertTrue((boolean)resultingRejections.contains(this.resultingRejection));
    }

    protected void assertDirectResultingMerges(Set<Diff> resultingMerges) {
        Assert.assertEquals((long)1L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(this.resultingMerge));
    }

    protected void assertAllResultingMerges(Set<Diff> resultingMerges) {
        Assert.assertEquals((long)3L, (long)resultingMerges.size());
        Assert.assertTrue((boolean)resultingMerges.contains(this.mergeDependency));
        Assert.assertTrue((boolean)resultingMerges.contains(this.diff));
        Assert.assertTrue((boolean)resultingMerges.contains(this.resultingMerge));
    }

    protected void assertAllResultingRejections(Set<Diff> resultingRejections) {
        Assert.assertEquals((long)1L, (long)resultingRejections.size());
        Assert.assertTrue((boolean)resultingRejections.contains(this.resultingRejection));
    }

    private static Comparison createComparison() {
        return CompareFactory.eINSTANCE.createComparison();
    }

    private static Match createMatch() {
        return CompareFactory.eINSTANCE.createMatch();
    }

    private static Diff createDiff(Match match) {
        DiffSpec diff = new DiffSpec();
        diff.setMatch(match);
        return diff;
    }

    private static IMerger.Registry2 createMergerRegistry() {
        return (IMerger.Registry2)IMerger.RegistryImpl.createStandaloneInstance();
    }

    private static IMerger2 mockMerger(Diff diff, Diff mergeDependency, Diff resultingMerge, Diff resultingRejection, int ranking, IMerger.Registry registry) {
        IMerger2 mockMerger = (IMerger2)Mockito.mock(IMerger2.class);
        Mockito.when((Object)mockMerger.getDirectMergeDependencies(diff, MERGE_RIGHT_TO_LEFT)).thenReturn((Object)Sets.newHashSet((Object[])new Diff[]{mergeDependency}));
        Mockito.when((Object)mockMerger.getDirectResultingMerges(diff, MERGE_RIGHT_TO_LEFT)).thenReturn((Object)Sets.newHashSet((Object[])new Diff[]{resultingMerge}));
        Mockito.when((Object)mockMerger.getDirectResultingRejections(diff, MERGE_RIGHT_TO_LEFT)).thenReturn((Object)Sets.newHashSet((Object[])new Diff[]{resultingRejection}));
        Mockito.when((Object)mockMerger.isMergerFor((Diff)Matchers.any(Diff.class))).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockMerger.getRanking()).thenReturn((Object)ranking);
        Mockito.when((Object)mockMerger.getRegistry()).thenReturn((Object)registry);
        return mockMerger;
    }
}

