/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.profiles;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.internal.ProfileApplicationChange;
import org.eclipse.emf.compare.uml2.tests.AbstractStaticProfileTest;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.profiles.data.static_.StaticProfileInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.uml2.uml.UMLPackage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StaticProfileTest
extends AbstractStaticProfileTest {
    private StaticProfileInputData input = new StaticProfileInputData();

    @BeforeClass
    public static void setupClass() {
        StaticProfileTest.fillRegistriesForStatic();
    }

    @AfterClass
    public static void teardownClass() {
        StaticProfileTest.resetRegistriesForStatic();
    }

    @Test
    public void testStaticA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLStaticA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testMergeLtRStaticA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testStaticA11UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLStaticA11UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testMergeLtRStaticA11UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testStaticA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
    }

    @Test
    public void testMergeRtLStaticA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testMergeLtRStaticA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testStaticA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
    }

    @Test
    public void testMergeRtLStaticA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testMergeLtRStaticA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Left();
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)5L, (long)differences.size());
        Predicate addProfileApplicationDescription = null;
        Predicate addAppliedProfileInProfileApplicationDescription = null;
        Predicate addUMLAnnotationDescription = null;
        Predicate addReferencesInUMLAnnotationDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), StaticProfileTest.onRealFeature((EStructuralFeature)UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION)});
            addUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), StaticProfileTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS)});
            addReferencesInUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), StaticProfileTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)});
        } else {
            addProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), StaticProfileTest.onRealFeature((EStructuralFeature)UMLPackage.Literals.PACKAGE__PROFILE_APPLICATION)});
            addUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), StaticProfileTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS)});
            addReferencesInUMLAnnotationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), StaticProfileTest.onRealFeature((EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES)});
        }
        addAppliedProfileInProfileApplicationDescription = Predicates.and((Predicate[])new Predicate[]{Predicates.instanceOf(ReferenceChange.class), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.CHANGE), EMFComparePredicates.onFeature((String)"appliedProfile")});
        Diff addProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addProfileApplicationDescription);
        Diff addAppliedProfileInProfileApplication = (Diff)Iterators.find(differences.iterator(), (Predicate)addAppliedProfileInProfileApplicationDescription);
        Diff addUMLAnnotation = (Diff)Iterators.find(differences.iterator(), (Predicate)addUMLAnnotationDescription);
        Diff addReferencesInUMLAnnotation = (Diff)Iterators.find(differences.iterator(), (Predicate)addReferencesInUMLAnnotationDescription);
        Assert.assertNotNull((Object)addProfileApplication);
        Assert.assertNotNull((Object)addAppliedProfileInProfileApplication);
        Assert.assertNotNull((Object)addUMLAnnotation);
        Assert.assertNotNull((Object)addReferencesInUMLAnnotation);
        Assert.assertEquals((long)1L, (long)StaticProfileTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(ProfileApplicationChange.class)));
        Diff addUMLProfileApplication = null;
        addUMLProfileApplication = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ProfileApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))) : (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(ProfileApplicationChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        Assert.assertNotNull((Object)addUMLProfileApplication);
        Assert.assertEquals((long)4L, (long)addUMLProfileApplication.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addReferencesInUMLAnnotation));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addAppliedProfileInProfileApplication));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addProfileApplication));
        Assert.assertTrue((boolean)addUMLProfileApplication.getRefinedBy().contains((Object)addUMLAnnotation));
        Assert.assertEquals((long)0L, (long)addUMLProfileApplication.getRequires().size());
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)0L, (long)addProfileApplication.getRequires().size());
            Assert.assertEquals((long)1L, (long)addUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addUMLAnnotation.getRequires().contains((Object)addProfileApplication));
            Assert.assertEquals((long)1L, (long)addReferencesInUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addReferencesInUMLAnnotation.getRequires().contains((Object)addUMLAnnotation));
        } else {
            Assert.assertEquals((long)2L, (long)addProfileApplication.getRequires().size());
            Assert.assertTrue((boolean)addProfileApplication.getRequires().contains((Object)addAppliedProfileInProfileApplication));
            Assert.assertTrue((boolean)addProfileApplication.getRequires().contains((Object)addUMLAnnotation));
            Assert.assertEquals((long)1L, (long)addUMLAnnotation.getRequires().size());
            Assert.assertTrue((boolean)addUMLAnnotation.getRequires().contains((Object)addReferencesInUMLAnnotation));
            Assert.assertEquals((long)0L, (long)addReferencesInUMLAnnotation.getRequires().size());
        }
        Assert.assertEquals((long)0L, (long)comparison.getEquivalences().size());
        this.testIntersections(comparison);
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

