/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor.extension.stereotype;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.internal.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.internal.StereotypedElementChange;
import org.eclipse.emf.compare.uml2.internal.UMLCompareFactory;
import org.eclipse.emf.compare.uml2.internal.postprocessor.AbstractUMLChangeFactory;
import org.eclipse.emf.compare.uml2.internal.postprocessor.util.UMLCompareUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.uml2.uml.Element;

public class UMLStereotypedElementChangeFactory
extends AbstractUMLChangeFactory {
    public Class<? extends Diff> getExtensionKind() {
        return StereotypedElementChange.class;
    }

    @Override
    public boolean handles(Diff input) {
        ReferenceChange refChange;
        if (input instanceof ReferenceChange && (refChange = (ReferenceChange)input).getReference().isContainment() && refChange.getValue() instanceof Element && (refChange.getKind() == DifferenceKind.ADD || refChange.getKind() == DifferenceKind.DELETE)) {
            return !this.getStereotypeApplicationChanges(refChange).isEmpty();
        }
        return false;
    }

    private List<StereotypeApplicationChange> getStereotypeApplicationChanges(ReferenceChange refChange) {
        EList searchScope;
        ArrayList result = Lists.newArrayList();
        switch (refChange.getKind()) {
            case ADD: {
                searchScope = refChange.getRequiredBy();
                break;
            }
            case DELETE: {
                searchScope = refChange.getRequires();
                break;
            }
            default: {
                searchScope = Collections.emptyList();
            }
        }
        for (Diff reqBy : searchScope) {
            if (!(reqBy instanceof StereotypeApplicationChange)) continue;
            StereotypeApplicationChange stereoAppChange = (StereotypeApplicationChange)reqBy;
            if (!refChange.getValue().equals(UMLCompareUtil.getBaseElement(stereoAppChange.getDiscriminant()))) continue;
            result.add(stereoAppChange);
        }
        return result;
    }

    public Diff createExtension() {
        return UMLCompareFactory.eINSTANCE.createStereotypedElementChange();
    }

    @Override
    public void setRefiningChanges(Diff extension, DifferenceKind extensionKind, Diff refiningDiff) {
        List<StereotypeApplicationChange> stereotypeApplicationChanges = this.getStereotypeApplicationChanges((ReferenceChange)refiningDiff);
        if (refiningDiff.getSource() == extension.getSource()) {
            extension.getRefinedBy().add((Object)refiningDiff);
            extension.getRefinedBy().addAll(Collections2.filter(stereotypeApplicationChanges, (Predicate)EMFComparePredicates.fromSide((DifferenceSource)extension.getSource())));
        }
    }

    @Override
    protected Switch<Set<EObject>> getDiscriminantsGetter() {
        return null;
    }

    @Override
    protected EObject getDiscriminant(Diff input) {
        return ((ReferenceChange)input).getValue();
    }
}

