/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tooltip;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.ResourceLocationChange;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.provider.ISemanticObjectLabelProvider;
import org.eclipse.emf.compare.provider.ITooltipLabelProvider;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public abstract class AbstractTooltipProvider<T extends Diff>
extends AdapterImpl
implements ITooltipLabelProvider {
    private static final String LINE_SEPARATOR = "\n";
    protected ComposedAdapterFactory adapterFactory;
    protected IItemLabelProvider labelProvider;

    public boolean isAdapterForType(Object type) {
        if (type == ITooltipLabelProvider.class) {
            return true;
        }
        return super.isAdapterForType(type);
    }

    protected String acceptAndChanged(String value) {
        String accept = EMFCompareEditMessages.getString("ContextualTooltip.acceptChange");
        String modify = EMFCompareEditMessages.getString("ContextualTooltip.readonly.leftChanged");
        StringBuilder builder = new StringBuilder();
        builder.append(accept).append(LINE_SEPARATOR).append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    protected boolean isFromLeft(T diff) {
        return diff.getSource().equals((Object)DifferenceSource.LEFT);
    }

    protected String acceptAndUnchanged(String value) {
        String accept = EMFCompareEditMessages.getString("ContextualTooltip.acceptChange");
        String modify = EMFCompareEditMessages.getString("ContextualTooltip.readonly.leftUnchanged");
        StringBuilder builder = new StringBuilder();
        builder.append(accept).append(LINE_SEPARATOR).append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    protected String rejectAndChanged(String value) {
        String accept = EMFCompareEditMessages.getString("ContextualTooltip.rejectChange");
        String modify = EMFCompareEditMessages.getString("ContextualTooltip.readonly.leftChanged");
        StringBuilder builder = new StringBuilder();
        builder.append(accept).append(LINE_SEPARATOR).append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    protected String rejectAndUnchanged(String value) {
        String accept = EMFCompareEditMessages.getString("ContextualTooltip.rejectChange");
        String modify = EMFCompareEditMessages.getString("ContextualTooltip.readonly.leftUnchanged");
        StringBuilder builder = new StringBuilder();
        builder.append(accept).append(LINE_SEPARATOR).append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    protected String rightUnchanged(String value) {
        String modify = EMFCompareEditMessages.getString("ContextualTooltip.editable.rightUnchanged");
        StringBuilder builder = new StringBuilder();
        builder.append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    protected String rightChanged(String value) {
        String modify = EMFCompareEditMessages.getString("ContextualTooltip.editable.rightChanged");
        StringBuilder builder = new StringBuilder();
        builder.append(value).append(LINE_SEPARATOR).append(modify);
        return builder.toString();
    }

    protected String getLabel(EObject eObject) {
        Adapter adapter;
        if (eObject != null && (adapter = this.adapterFactory.getRootAdapterFactory().adapt((Notifier)eObject, ISemanticObjectLabelProvider.class)) instanceof ISemanticObjectLabelProvider) {
            return ((ISemanticObjectLabelProvider)adapter).getSemanticObjectLabel(eObject);
        }
        return null;
    }

    private String getPreviousValue(EStructuralFeature eStructuralFeature, EObject eObject) {
        Object ancestor = null;
        if (eObject != null) {
            ancestor = ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)eStructuralFeature);
        }
        String value = "";
        if (ancestor instanceof EObject) {
            value = this.getLabelFromObject((EObject)ancestor);
        } else if (ancestor != null) {
            value = ancestor.toString();
        }
        return value;
    }

    protected String getLabelFromObject(EObject eObject) {
        if (eObject == null) {
            return "";
        }
        return this.labelProvider.getText((Object)eObject);
    }

    protected String setDeleteNonContainmentTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.left.leftToRight", value) : EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.right.leftToRight", value);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.left.rightToLeft", value) : EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.right.rightToLeft", value);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.left.accept", value);
                    tooltip = this.acceptAndUnchanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.right.accept", value);
                tooltip = this.acceptAndChanged(body);
                break;
            }
            case REJECT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.left.reject", value);
                    tooltip = this.rejectAndChanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.delete.nonContainment.right.reject", value);
                tooltip = this.rejectAndUnchanged(body);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    protected String setAddNonContainmentTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.left.leftToRight", value) : EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.right.leftToRight", value);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.left.rightToLeft", value) : EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.right.rightToLeft", value);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.left.accept", value);
                    tooltip = this.acceptAndUnchanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.right.accept", value);
                tooltip = this.acceptAndChanged(body);
                break;
            }
            case REJECT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.left.reject", value);
                    tooltip = this.rejectAndChanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.add.nonContainment.right.reject", value);
                tooltip = this.rejectAndUnchanged(body);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    protected String setMovePositionTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        String containerValue = this.getLabel((EObject)diff.getMatch());
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.move.position.left.leftToRight", value) : EMFCompareEditMessages.getString("ContextualTooltip.move.position.right.leftToRight", value);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.move.position.left.rightToLeft", value) : EMFCompareEditMessages.getString("ContextualTooltip.move.position.right.rightToLeft", value);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if (isFromLeft) {
                    String body = diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment() ? EMFCompareEditMessages.getString("ContextualTooltip.move.position.left.container.accept", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.move.position.left.accept", value);
                    tooltip = this.acceptAndUnchanged(body);
                    break;
                }
                String body = diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment() ? EMFCompareEditMessages.getString("ContextualTooltip.move.position.right.container.accept", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.move.position.right.accept", value);
                tooltip = this.acceptAndChanged(body);
                break;
            }
            case REJECT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.move.position.left.reject", value);
                    tooltip = this.rejectAndChanged(body);
                    break;
                }
                String body = diff instanceof ReferenceChange && ((ReferenceChange)diff).getReference().isContainment() ? EMFCompareEditMessages.getString("ContextualTooltip.move.position.right.container.reject", value, containerValue) : EMFCompareEditMessages.getString("ContextualTooltip.move.position.right.reject", value);
                tooltip = this.rejectAndUnchanged(body);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    protected String setSetTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        EStructuralFeature eStructuralFeature = MatchUtil.getStructuralFeature(diff);
        EObject left = diff.getMatch().getLeft();
        EObject right = diff.getMatch().getRight();
        String containerName = "";
        String rightValue = "";
        String leftValue = "";
        if (isFromLeft && left != null) {
            containerName = left.eClass().getName();
        } else if (!isFromLeft && right != null) {
            containerName = right.eClass().getName();
        }
        if (left != null) {
            leftValue = this.getPreviousValue(eStructuralFeature, left);
        }
        if (right != null) {
            rightValue = this.getPreviousValue(eStructuralFeature, right);
        }
        return this.doSetTooltip(mode, isFromLeft, rightValue, leftValue, containerName, eStructuralFeature, diff);
    }

    private String doSetTooltip(MergeMode mode, boolean isFromLeft, String rightValue, String leftValue, String containerName, EStructuralFeature eStructuralFeature, T diff) {
        String tooltip;
        String structuralFeatureName = eStructuralFeature.getName();
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft ? ("".equals(rightValue) ? EMFCompareEditMessages.getString("ContextualTooltip.set.left.leftToRight.empty", structuralFeatureName, containerName, leftValue) : EMFCompareEditMessages.getString("ContextualTooltip.set.left.leftToRight", structuralFeatureName, containerName, leftValue, rightValue)) : ("".equals(leftValue) ? EMFCompareEditMessages.getString("ContextualTooltip.set.right.leftToRight.empty", structuralFeatureName, containerName, rightValue) : EMFCompareEditMessages.getString("ContextualTooltip.set.right.leftToRight", structuralFeatureName, containerName, leftValue, rightValue));
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft ? ("".equals(rightValue) ? EMFCompareEditMessages.getString("ContextualTooltip.set.left.rightToLeft.empty", structuralFeatureName, containerName, leftValue) : EMFCompareEditMessages.getString("ContextualTooltip.set.left.rightToLeft", structuralFeatureName, containerName, rightValue, leftValue)) : ("".equals(leftValue) ? EMFCompareEditMessages.getString("ContextualTooltip.set.right.rightToLeft.empty", structuralFeatureName, containerName, rightValue) : EMFCompareEditMessages.getString("ContextualTooltip.set.right.rightToLeft", structuralFeatureName, containerName, rightValue, leftValue));
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.set.left.accept", leftValue, structuralFeatureName, containerName);
                    tooltip = this.acceptAndUnchanged(body);
                    break;
                }
                String body = "".equals(leftValue) ? EMFCompareEditMessages.getString("ContextualTooltip.set.right.accept.empty", structuralFeatureName, containerName, rightValue) : EMFCompareEditMessages.getString("ContextualTooltip.set.right.accept", structuralFeatureName, containerName, rightValue, leftValue);
                tooltip = this.acceptAndChanged(body);
                break;
            }
            case REJECT: {
                String previousValue = diff.getMatch().getComparison().isThreeWay() ? this.getPreviousValue(eStructuralFeature, diff.getMatch().getOrigin()) : rightValue;
                if (isFromLeft) {
                    String body = "".equals(previousValue) ? EMFCompareEditMessages.getString("ContextualTooltip.set.left.reject.empty", structuralFeatureName, containerName, leftValue) : EMFCompareEditMessages.getString("ContextualTooltip.set.left.reject", structuralFeatureName, containerName, previousValue, leftValue);
                    tooltip = this.rejectAndChanged(body);
                    break;
                }
                previousValue = diff.getMatch().getComparison().isThreeWay() ? this.getPreviousValue(eStructuralFeature, diff.getMatch().getOrigin()) : leftValue;
                String body = "".equals(previousValue) ? EMFCompareEditMessages.getString("ContextualTooltip.set.right.reject.empty", structuralFeatureName, containerName) : EMFCompareEditMessages.getString("ContextualTooltip.set.right.reject", previousValue, structuralFeatureName, containerName);
                tooltip = this.rejectAndUnchanged(body);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    protected String setUnsetTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        String value = this.getLabel((EObject)diff);
        EStructuralFeature structuralFeature = MatchUtil.getStructuralFeature(diff);
        String structuralFeatureName = structuralFeature.getName();
        String containerName = "";
        if (isFromLeft && diff.getMatch().getLeft() != null) {
            containerName = diff.getMatch().getLeft().eClass().getName();
        } else if (!isFromLeft && diff.getMatch().getRight() != null) {
            containerName = diff.getMatch().getRight().eClass().getName();
        }
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.unset.left.leftToRight", structuralFeatureName, containerName, value) : EMFCompareEditMessages.getString("ContextualTooltip.unset.right.leftToRight", structuralFeatureName, containerName, value);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.unset.left.rightToLeft", structuralFeatureName, containerName, value) : EMFCompareEditMessages.getString("ContextualTooltip.unset.right.rightToLeft", structuralFeatureName, containerName, value);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.unset.left.accept", structuralFeatureName, containerName);
                    tooltip = this.acceptAndUnchanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.unset.right.accept", structuralFeatureName, containerName, value);
                tooltip = this.acceptAndChanged(body);
                break;
            }
            case REJECT: {
                if (isFromLeft) {
                    String body = EMFCompareEditMessages.getString("ContextualTooltip.unset.left.reject", structuralFeatureName, containerName, value);
                    tooltip = this.rejectAndChanged(body);
                    break;
                }
                String body = EMFCompareEditMessages.getString("ContextualTooltip.unset.right.reject", structuralFeatureName, containerName, value);
                tooltip = this.rejectAndUnchanged(body);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }

    protected String setResourceLocationChangeTooltip(MergeMode mode, T diff, boolean isFromLeft) {
        String tooltip;
        if (diff instanceof ResourceAttachmentChange) {
            return "not supported yet";
        }
        if (!(diff instanceof ResourceLocationChange)) {
            return "";
        }
        ResourceLocationChange change = (ResourceLocationChange)diff;
        String oldValue = change.getBaseLocation();
        String newValue = change.getChangedLocation();
        switch (mode) {
            case LEFT_TO_RIGHT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.rlc.left.leftToRight", newValue) : EMFCompareEditMessages.getString("ContextualTooltip.rlc.right.leftToRight", oldValue);
                tooltip = this.rightChanged(body);
                break;
            }
            case RIGHT_TO_LEFT: {
                String body = isFromLeft ? EMFCompareEditMessages.getString("ContextualTooltip.rlc.left.rightToLeft", oldValue) : EMFCompareEditMessages.getString("ContextualTooltip.rlc.right.rightToLeft", newValue);
                tooltip = this.rightUnchanged(body);
                break;
            }
            case ACCEPT: {
                String body;
                if (isFromLeft) {
                    body = EMFCompareEditMessages.getString("ContextualTooltip.rlc.left.accept", newValue);
                    tooltip = this.acceptAndUnchanged(body);
                    break;
                }
                body = EMFCompareEditMessages.getString("ContextualTooltip.rlc.right.accept", newValue);
                tooltip = this.acceptAndChanged(body);
                break;
            }
            case REJECT: {
                String body;
                if (isFromLeft) {
                    body = EMFCompareEditMessages.getString("ContextualTooltip.rlc.left.reject", oldValue);
                    tooltip = this.rejectAndChanged(body);
                    break;
                }
                body = EMFCompareEditMessages.getString("ContextualTooltip.rlc.right.reject", oldValue);
                tooltip = this.rejectAndUnchanged(body);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return tooltip;
    }
}

