/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeNonConflictingRunnable;
import org.eclipse.emf.compare.internal.domain.IMergeAllNonConflictingRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class MergeAllNonConflictingAction
extends MergeAction {
    private static final Predicate<Diff> NON_CONFLICTING_DIFFS = EMFComparePredicates.hasNoDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL});
    private Comparison comparison;
    private List<Diff> differences;

    public MergeAllNonConflictingAction(IEMFCompareConfiguration compareConfiguration, Comparison comparison, IMerger.Registry mergerRegistry, MergeMode mode) {
        super(compareConfiguration, mergerRegistry, mode, null);
        this.setComparison(comparison);
    }

    @Override
    protected MergeNonConflictingRunnable createMergeRunnable(MergeMode mode, boolean isLeftEditable, boolean isRightEditable, IDiffRelationshipComputer relationshipComputer) {
        return new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mode, relationshipComputer);
    }

    @Override
    protected void initToolTipAndImage(MergeMode mode) {
        switch (mode) {
            case LEFT_TO_RIGHT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.all.to.right.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_all_to_right.gif"));
                break;
            }
            case RIGHT_TO_LEFT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("merged.all.to.left.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/merge_all_to_left.gif"));
                break;
            }
            case ACCEPT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("accept.all.changes.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/accept_all_changes.gif"));
                break;
            }
            case REJECT: {
                this.setToolTipText(EMFCompareIDEUIMessages.getString("reject.all.changes.tooltip"));
                this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)"icons/full/toolb16/reject_all_changes.gif"));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public void setComparison(Comparison comparison) {
        this.comparison = comparison;
        this.differences = comparison != null ? comparison.getDifferences() : Collections.emptyList();
        this.clearCache();
        this.setEnabled(comparison != null);
    }

    @Override
    protected void execute(ICompareCommandStack commandStack, MergeMode mode, List<Diff> diffs) {
        if (this.editingDomain instanceof EMFCompareEditingDomain) {
            ICompareCopyCommand mergeCommand = ((EMFCompareEditingDomain)this.editingDomain).createCopyAllNonConflictingCommand(this.comparison, this.isLeftToRight(), this.mergerRegistry, (IMergeAllNonConflictingRunnable)this.createMergeRunnable(mode, this.isLeftEditable(), this.isRightEditable(), this.getDiffRelationshipComputer()));
            this.editingDomain.getCommandStack().execute((Command)mergeCommand);
        } else {
            EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.emf.compare.ide.ui", "Couldn't create the copy all command."));
        }
    }

    @Override
    protected boolean updateSelection(IStructuredSelection selection) {
        Iterables.addAll(this.getSelectedDifferences(), this.getSelectedDifferences(this.differences));
        return !this.getSelectedDifferences().isEmpty();
    }

    @Override
    protected Iterable<Diff> getSelectedDifferences(Iterable<Diff> diffs) {
        return Iterables.filter(super.getSelectedDifferences(diffs), NON_CONFLICTING_DIFFS);
    }
}

