/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.AbstractMergeRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.merge.ComputeDiffsToMerge;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public class MergeConflictingRunnable
extends AbstractMergeRunnable
implements IMergeRunnable {
    private static final Logger LOGGER = Logger.getLogger(MergeConflictingRunnable.class);

    public MergeConflictingRunnable(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode, IDiffRelationshipComputer diffRelationshipComputer) {
        super(isLeftEditable, isRightEditable, mergeMode, diffRelationshipComputer);
    }

    public void merge(List<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        Preconditions.checkState((this.getMergeMode().isLeftToRight(this.isLeftEditable(), this.isRightEditable()) == leftToRight ? 1 : 0) != 0);
        Preconditions.checkState((!differences.isEmpty() && ComparisonUtil.getComparison((Diff)differences.get(0)) != null ? 1 : 0) != 0);
        Comparison comparison = ComparisonUtil.getComparison((Diff)differences.get(0));
        this.doMergeConflicting(differences, comparison, leftToRight, (IMerger.Registry2)mergerRegistry);
    }

    private Iterable<Diff> doMergeConflicting(Collection<Diff> differences, Comparison comparison, boolean leftToRight, IMerger.Registry2 mergerRegistry) {
        ArrayList<Diff> affectedDiffs = new ArrayList<Diff>();
        for (Diff diff : differences) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("doMergeConflicting(Collection<Diff>, Comparison, leftToRight, mergerRegistry)" + diff.hashCode()));
            }
            affectedDiffs.addAll(this.mergeDirectAndIndirectConflicts(leftToRight, mergerRegistry, diff));
        }
        return affectedDiffs;
    }

    private List<Diff> mergeDirectAndIndirectConflicts(boolean leftToRight, IMerger.Registry2 registry, Diff diff) {
        Set<Diff> conflictingDiffs = this.getAllDirectlyAndIndirectlyConflictingDiffs(diff);
        if (conflictingDiffs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Diff> affectedDiffs = new ArrayList<Diff>();
        ComputeDiffsToMerge computer = new ComputeDiffsToMerge(!leftToRight, registry);
        computer.failOnRealConflictUnless(Predicates.alwaysTrue());
        conflictingDiffs.add(diff);
        for (Diff conflictingDiff : conflictingDiffs) {
            if (AbstractMerger.isInTerminalState((Diff)conflictingDiff)) continue;
            for (Diff diffToMerge : computer.getAllDiffsToMerge(conflictingDiff)) {
                IMerger merger;
                if (!leftToRight && this.isLeftEditable()) {
                    if (DifferenceSource.LEFT.equals((Object)this.getDiffSourceToMerge())) {
                        this.markAsMerged(diffToMerge, this.getMergeMode(), leftToRight, (IMerger.Registry)registry);
                        continue;
                    }
                    merger = registry.getHighestRankingMerger(diffToMerge);
                    merger.copyRightToLeft(diffToMerge, (Monitor)new BasicMonitor());
                    affectedDiffs.add(diffToMerge);
                    continue;
                }
                if (!leftToRight || !this.isRightEditable()) continue;
                if (DifferenceSource.LEFT.equals((Object)this.getDiffSourceToMerge())) {
                    merger = registry.getHighestRankingMerger(diffToMerge);
                    merger.copyLeftToRight(diffToMerge, (Monitor)new BasicMonitor());
                    affectedDiffs.add(diffToMerge);
                    continue;
                }
                this.markAsMerged(diffToMerge, this.getMergeMode(), leftToRight, (IMerger.Registry)registry);
            }
        }
        return affectedDiffs;
    }

    private Set<Diff> getAllDirectlyAndIndirectlyConflictingDiffs(Diff diff) {
        HashSet conflictingDiffs = Sets.newHashSet();
        if (EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)diff)) {
            conflictingDiffs.addAll(diff.getConflict().getDifferences());
        }
        Set allRefiningDiffs = DiffUtil.getAllRefiningDiffs((Diff)diff);
        for (Diff refiningDiff : allRefiningDiffs) {
            if (!EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)refiningDiff)) continue;
            conflictingDiffs.addAll(refiningDiff.getConflict().getDifferences());
        }
        return conflictingDiffs;
    }

    private DifferenceSource getDiffSourceToMerge() {
        switch (this.getMergeMode()) {
            case LEFT_TO_RIGHT: 
            case REJECT: {
                return DifferenceSource.LEFT;
            }
        }
        return DifferenceSource.RIGHT;
    }
}

