/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.graph.IGraph;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ThreadedModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.tests.CompareTestCase;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.internal.utils.Graph;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DependenciesTest
extends CompareTestCase {
    private static final String FILE1_SUFFIX = "_file1";
    private static final String FILE2_SUFFIX = "_file2";
    private static final String FILE3_SUFFIX = "_file3";
    private IFile iFile1;
    private IFile iFile2;
    private IFile iFile3;
    private ResourceSet resourceSet;
    private Resource resource1;
    private Resource resource2;
    private Resource resource3;
    private IModelResolver resolver;
    private IProgressMonitor monitor;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.resolver = new ThreadedModelResolver();
        ((ThreadedModelResolver)this.resolver).setGraph((IGraph)new Graph());
        this.resolver.initialize();
        this.monitor = new NullProgressMonitor();
        IProject iProject = this.project.getProject();
        this.resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject, "file1.ecore");
        File file2 = this.project.getOrCreateFile(iProject, "file2.ecore");
        File file3 = this.project.getOrCreateFile(iProject, "file3.ecore");
        this.iFile1 = this.project.getIFile(iProject, file1);
        this.iFile2 = this.project.getIFile(iProject, file2);
        this.iFile3 = this.project.getIFile(iProject, file3);
        this.resource1 = this.connectResource(this.iFile1, this.resourceSet);
        this.resource2 = this.connectResource(this.iFile2, this.resourceSet);
        this.resource3 = this.connectResource(this.iFile3, this.resourceSet);
        this.resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        this.resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        this.save(this.resourceSet);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.resolver.dispose();
        super.tearDown();
    }

    @Test
    public void testScopeNoDependencies() throws Exception {
        StorageTraversal traversal = this.resolver.resolveLocalModel((IResource)this.iFile1, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile2, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile2);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile3, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile3);
    }

    @Test
    public void testScopeAddedDependency() throws Exception {
        this.makeCrossReference(this.resource2, this.resource1);
        this.save(this.resourceSet);
        StorageTraversal traversal = this.resolver.resolveLocalModel((IResource)this.iFile1, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1, this.iFile2);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile2, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1, this.iFile2);
    }

    @Test
    public void testScopeRemovedDependency() throws Exception {
        this.makeCrossReference(this.resource2, this.resource1);
        this.save(this.resourceSet);
        this.breakCrossReferences(this.resource2, this.resource1);
        this.save(this.resourceSet);
        StorageTraversal traversal = this.resolver.resolveLocalModel((IResource)this.iFile1, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile2, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile2);
    }

    @Test
    public void testScopeDepth() throws Exception {
        this.makeCrossReference(this.resource2, this.resource1);
        this.makeCrossReference(this.resource3, this.resource2);
        this.save(this.resourceSet);
        StorageTraversal traversal = this.resolver.resolveLocalModel((IResource)this.iFile1, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1, this.iFile2, this.iFile3);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile2, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1, this.iFile2, this.iFile3);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile3, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1, this.iFile2, this.iFile3);
    }

    @Test
    public void testScopeUpdate() throws Exception {
        this.makeCrossReference(this.resource2, this.resource1);
        this.makeCrossReference(this.resource3, this.resource2);
        this.save(this.resourceSet);
        StorageTraversal traversal = this.resolver.resolveLocalModel((IResource)this.iFile1, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1, this.iFile2, this.iFile3);
        this.breakCrossReferences(this.resource2, this.resource1);
        this.save(this.resourceSet);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile1, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile2, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile2, this.iFile3);
        this.breakCrossReferences(this.resource3, this.resource2);
        this.makeCrossReference(this.resource3, this.resource1);
        this.save(this.resourceSet);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile1, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1, this.iFile3);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile2, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile2);
        traversal = this.resolver.resolveLocalModel((IResource)this.iFile3, this.monitor);
        DependenciesTest.assertContainsExclusively(traversal, this.iFile1, this.iFile3);
    }
}

