/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.internal.logical;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.ide.internal.EMFCompareIDEMessages;
import org.eclipse.emf.compare.ide.internal.logical.AbstractModelInclusionTester;
import org.eclipse.emf.compare.ide.logical.IModelInclusionTester;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;

public class DynamicModelInclusionTester
extends AbstractModelInclusionTester {
    private IConfigurationElement element;
    private IModelInclusionTester delegate;

    public DynamicModelInclusionTester(IConfigurationElement element, String key) {
        super(key);
        this.element = element;
    }

    @Override
    public boolean shouldInclude(IFile file) {
        return this.getDelegate().shouldInclude(file);
    }

    private IModelInclusionTester getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (IModelInclusionTester)this.element.createExecutableExtension("dynamicTester");
            }
            catch (CoreException e) {
                String contributorName = this.element.getDeclaringExtension().getContributor().getName();
                String message = EMFCompareIDEMessages.getString("ModelInclusionTesterRegistry.instantiationError", contributorName);
                Status status = new Status(4, contributorName, String.valueOf(message) + this.element.getDeclaringExtension().getContributor().getName(), (Throwable)e);
                EMFCompareRCPPlugin.getDefault().getLog().log((IStatus)status);
                this.delegate = new IModelInclusionTester(){

                    @Override
                    public boolean shouldInclude(IFile file) {
                        return false;
                    }
                };
            }
        }
        return this.delegate;
    }
}

