/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.command;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.command.impl.MergeAllNonConflictingCommand;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeNonConflictingRunnable;
import org.eclipse.emf.compare.ide.ui.tests.command.data.MergeAllCommandInputData;
import org.eclipse.emf.compare.internal.domain.IMergeAllNonConflictingRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MergeAllCommandTests {
    private Resource leftResource;
    private Resource rightResource;
    private Resource originResource;
    private IMerger.Registry mergerRegistry;

    @Before
    public void getInputData() throws IOException {
        MergeAllCommandInputData input = new MergeAllCommandInputData();
        this.leftResource = input.getLeftScope();
        this.rightResource = input.getRightScope();
        this.originResource = input.getOriginScope();
        this.mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();
    }

    @Test
    public void testMergeAllNonConflictingFromLeftToRightThreeWayWithoutConflicts() throws IOException {
        MergeMode mergeMode = MergeMode.LEFT_TO_RIGHT;
        boolean leftToRight = true;
        boolean isLeftEditable = true;
        boolean isRightEditable = true;
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EMFCompareEditingDomain editingDomain = (EMFCompareEditingDomain)EMFCompareEditingDomain.create((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
        ChangeRecorder changeRecorder = editingDomain.getChangeRecorder();
        ImmutableSet.Builder notifiersBuilder = ImmutableSet.builder();
        ImmutableSet notifiers = notifiersBuilder.add((Object)comparison).addAll((Iterable)ImmutableList.of((Object)this.leftResource, (Object)this.rightResource, (Object)this.originResource)).build();
        MergeNonConflictingRunnable runnable = new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mergeMode, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        MergeAllNonConflictingCommand command = new MergeAllNonConflictingCommand(changeRecorder, (Collection)notifiers, comparison, leftToRight, this.mergerRegistry, (IMergeAllNonConflictingRunnable)runnable);
        EList differencesBefore = comparison.getDifferences();
        Iterable leftDelete = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftDelete));
        Iterable rightDelete = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightDelete));
        Iterable leftAdd = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftAdd));
        Iterable rightAdd = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightAdd));
        command.execute();
        EList differencesAfter = comparison.getDifferences();
        leftDelete = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftDelete));
        rightDelete = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)rightDelete));
        leftAdd = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftAdd));
        rightAdd = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)rightAdd));
        command.dispose();
        editingDomain.dispose();
    }

    @Test
    public void testMergeAllNonConflictingFromRightToLeftThreeWayWithoutConflicts() throws IOException {
        MergeMode mergeMode = MergeMode.RIGHT_TO_LEFT;
        boolean leftToRight = false;
        boolean isLeftEditable = true;
        boolean isRightEditable = true;
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EMFCompareEditingDomain editingDomain = (EMFCompareEditingDomain)EMFCompareEditingDomain.create((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
        ChangeRecorder changeRecorder = editingDomain.getChangeRecorder();
        ImmutableSet.Builder notifiersBuilder = ImmutableSet.builder();
        ImmutableSet notifiers = notifiersBuilder.add((Object)comparison).addAll((Iterable)ImmutableList.of((Object)this.leftResource, (Object)this.rightResource, (Object)this.originResource)).build();
        MergeNonConflictingRunnable runnable = new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mergeMode, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        MergeAllNonConflictingCommand command = new MergeAllNonConflictingCommand(changeRecorder, (Collection)notifiers, comparison, leftToRight, this.mergerRegistry, (IMergeAllNonConflictingRunnable)runnable);
        EList differencesBefore = comparison.getDifferences();
        Iterable leftDelete = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftDelete));
        Iterable rightDelete = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightDelete));
        Iterable leftAdd = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftAdd));
        Iterable rightAdd = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightAdd));
        command.execute();
        EList differencesAfter = comparison.getDifferences();
        leftDelete = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)leftDelete));
        rightDelete = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightDelete));
        leftAdd = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)leftAdd));
        rightAdd = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightAdd));
        command.dispose();
        editingDomain.dispose();
    }

    @Test
    public void testAcceptAllNonConflictingChangesThreeWayWithoutConflicts() throws IOException {
        MergeMode mergeMode = MergeMode.ACCEPT;
        boolean leftToRight = false;
        boolean isLeftEditable = true;
        boolean isRightEditable = false;
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EMFCompareEditingDomain editingDomain = (EMFCompareEditingDomain)EMFCompareEditingDomain.create((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
        ChangeRecorder changeRecorder = editingDomain.getChangeRecorder();
        ImmutableSet.Builder notifiersBuilder = ImmutableSet.builder();
        ImmutableSet notifiers = notifiersBuilder.add((Object)comparison).addAll((Iterable)ImmutableList.of((Object)this.leftResource, (Object)this.rightResource, (Object)this.originResource)).build();
        MergeNonConflictingRunnable runnable = new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mergeMode, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        MergeAllNonConflictingCommand command = new MergeAllNonConflictingCommand(changeRecorder, (Collection)notifiers, comparison, leftToRight, this.mergerRegistry, (IMergeAllNonConflictingRunnable)runnable);
        EList differencesBefore = comparison.getDifferences();
        Iterable leftDelete = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftDelete));
        Iterable rightDelete = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightDelete));
        Iterable leftAdd = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftAdd));
        Iterable rightAdd = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightAdd));
        command.execute();
        EList differencesAfter = comparison.getDifferences();
        leftDelete = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftDelete));
        rightDelete = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightDelete));
        leftAdd = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftAdd));
        rightAdd = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightAdd));
        command.dispose();
        editingDomain.dispose();
    }

    @Test
    public void testRejectAllNonConflictingChangesThreeWayWithoutConflicts() throws IOException {
        MergeMode mergeMode = MergeMode.REJECT;
        boolean leftToRight = false;
        boolean isLeftEditable = true;
        boolean isRightEditable = false;
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EMFCompareEditingDomain editingDomain = (EMFCompareEditingDomain)EMFCompareEditingDomain.create((Notifier)this.leftResource, (Notifier)this.rightResource, (Notifier)this.originResource);
        ChangeRecorder changeRecorder = editingDomain.getChangeRecorder();
        ImmutableSet.Builder notifiersBuilder = ImmutableSet.builder();
        ImmutableSet notifiers = notifiersBuilder.add((Object)comparison).addAll((Iterable)ImmutableList.of((Object)this.leftResource, (Object)this.rightResource, (Object)this.originResource)).build();
        MergeNonConflictingRunnable runnable = new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mergeMode, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        MergeAllNonConflictingCommand command = new MergeAllNonConflictingCommand(changeRecorder, (Collection)notifiers, comparison, leftToRight, this.mergerRegistry, (IMergeAllNonConflictingRunnable)runnable);
        EList differencesBefore = comparison.getDifferences();
        Iterable leftDelete = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftDelete));
        Iterable rightDelete = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightDelete));
        Iterable leftAdd = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftAdd));
        Iterable rightAdd = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightAdd));
        command.execute();
        EList differencesAfter = comparison.getDifferences();
        leftDelete = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftDelete));
        rightDelete = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightDelete));
        leftAdd = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftAdd));
        rightAdd = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.RIGHT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)rightAdd));
        command.dispose();
        editingDomain.dispose();
    }

    @Test
    public void testMergeAllNonConflictingChangesFromLeftToRightTwoWay() throws IOException {
        this.testMergeAllNonConflictingTwoWay(MergeMode.LEFT_TO_RIGHT);
    }

    @Test
    public void testMergeAllNonConflictingChangesFromRightToLeftTwoWay() throws IOException {
        this.testMergeAllNonConflictingTwoWay(MergeMode.RIGHT_TO_LEFT);
    }

    private void testMergeAllNonConflictingTwoWay(MergeMode mergeMode) {
        boolean isLeftEditable = true;
        boolean isRightEditable = true;
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.leftResource, (Notifier)this.originResource, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EMFCompareEditingDomain editingDomain = (EMFCompareEditingDomain)EMFCompareEditingDomain.create((Notifier)this.leftResource, (Notifier)this.originResource, null);
        ChangeRecorder changeRecorder = editingDomain.getChangeRecorder();
        ImmutableSet.Builder notifiersBuilder = ImmutableSet.builder();
        ImmutableSet notifiers = notifiersBuilder.add((Object)comparison).addAll((Iterable)ImmutableList.of((Object)this.leftResource, (Object)this.originResource)).build();
        MergeNonConflictingRunnable runnable = new MergeNonConflictingRunnable(isLeftEditable, isRightEditable, mergeMode, (IDiffRelationshipComputer)new DiffRelationshipComputer(this.mergerRegistry));
        MergeAllNonConflictingCommand command = new MergeAllNonConflictingCommand(changeRecorder, (Collection)notifiers, comparison, mergeMode.isLeftToRight(isLeftEditable, isRightEditable), this.mergerRegistry, (IMergeAllNonConflictingRunnable)runnable);
        EList differencesBefore = comparison.getDifferences();
        Iterable leftDelete = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftDelete));
        Iterable leftAdd = Iterables.filter((Iterable)differencesBefore, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftAdd));
        command.execute();
        EList differencesAfter = comparison.getDifferences();
        leftDelete = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftDelete));
        leftAdd = Iterables.filter((Iterable)differencesAfter, (Predicate)Predicates.and((Predicate[])new Predicate[]{EMFComparePredicates.fromSide((DifferenceSource)DifferenceSource.LEFT), EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD), EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.MERGED, DifferenceState.DISCARDED})}));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)leftAdd));
        command.dispose();
        editingDomain.dispose();
    }
}

