/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFModelProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RevisionedURIConverter;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.tests.egit.CompareGitTestCase;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jgit.api.Status;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class AbstractURITest
extends CompareGitTestCase {
    protected static final String MASTER = "refs/heads/master";
    protected static final String BRANCH = "refs/heads/branch";
    protected File file1;
    protected IFile iFile1;
    protected Resource resource1;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        IProject iProject = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        this.file1 = this.project.getOrCreateFile(iProject, "file1.ecore");
        this.iFile1 = this.project.getIFile(iProject, this.file1);
        this.resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        EMFModelProvider emfModelProvider = (EMFModelProvider)ModelProvider.getModelProviderDescriptor((String)"org.eclipse.emf.compare.model.provider").getModelProvider();
        emfModelProvider.clear();
        super.tearDown();
    }

    protected void setupStraightRepo() throws Exception {
        EPackage root1 = this.createPackage(null, "P1");
        EClass class1 = this.createClass(root1, "C1");
        EClass class2 = this.createClass(root1, "C2");
        this.resource1.getContents().add((Object)root1);
        this.save(new Resource[]{this.resource1});
        this.repository.addAllAndCommit("initial-commit");
        this.repository.createBranch(MASTER, BRANCH);
        root1.getEClassifiers().remove((Object)class2);
        class1.setName("C1_renamed");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "master-commit", this.file1);
        this.repository.checkoutBranch(BRANCH);
        this.reload(new Resource[]{this.resource1});
        root1 = (EPackage)this.findObject(this.resource1, "P1");
        class1 = (EClass)this.findObject(this.resource1, "C1");
        class2 = (EClass)this.findObject(this.resource1, "C2");
        class1.getESuperTypes().add((Object)class2);
        this.createClass(root1, "C3");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "branch-commit", this.file1);
        this.repository.checkoutBranch(MASTER);
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
    }

    protected void setupMultipleCommitsRepo(String branch1Name, String branch2Name) throws Exception {
        EPackage root1 = this.createPackage(null, "P1");
        EClass class1 = this.createClass(root1, "C1");
        this.resource1.getContents().add((Object)root1);
        this.save(new Resource[]{this.resource1});
        this.repository.addAllAndCommit("initial-commit");
        EClass class2 = this.createClass(root1, "C2");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "commit-master-1", this.file1);
        this.repository.createBranch(MASTER, branch1Name);
        root1.getEClassifiers().remove((Object)class2);
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "commit-master-2", this.file1);
        class1.setName("C1_renamed");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "commit-master-3", this.file1);
        this.repository.checkoutBranch(branch1Name);
        this.reload(new Resource[]{this.resource1});
        class1 = (EClass)this.findObject(this.resource1, "C1");
        class2 = (EClass)this.findObject(this.resource1, "C2");
        class1.getESuperTypes().add((Object)class2);
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "commit-branch1-1", this.file1);
        this.repository.createBranch(branch1Name, branch2Name);
        class2.setName("C2_renamed");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "commit-branch1-2", this.file1);
        this.repository.checkoutBranch(branch2Name);
        this.reload(new Resource[]{this.resource1});
        root1 = (EPackage)this.findObject(this.resource1, "P1");
        this.createClass(root1, "C3");
        this.save(new Resource[]{this.resource1});
        this.repository.addAndCommit(this.project, "commit-branch2-1", this.file1);
        this.repository.checkoutBranch(MASTER);
        Status status = this.repository.status();
        Assert.assertFalse((boolean)status.hasUncommittedChanges());
    }

    protected void assertStateInitial(URI fileURI, IStorageProviderAccessor accessor, IStorageProviderAccessor.DiffSide side) throws Exception {
        ExtensibleURIConverterImpl delegate = new ExtensibleURIConverterImpl();
        RevisionedURIConverter converter = new RevisionedURIConverter((URIConverter)delegate, accessor, side);
        InputStream stream = converter.createInputStream(fileURI, Collections.emptyMap());
        ResourceSetImpl tmpSet = new ResourceSetImpl();
        Resource tmpResource = tmpSet.createResource(fileURI);
        tmpResource.load(stream, Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)tmpResource.getContents().size());
        Assert.assertTrue((boolean)(tmpResource.getContents().get(0) instanceof EPackage));
        EPackage tmpPack = (EPackage)tmpResource.getContents().get(0);
        Assert.assertEquals((Object)"P1", (Object)tmpPack.getName());
        Assert.assertEquals((long)2L, (long)tmpPack.eContents().size());
        Assert.assertTrue((boolean)(tmpPack.eContents().get(0) instanceof EClass));
        Assert.assertTrue((boolean)(tmpPack.eContents().get(1) instanceof EClass));
        EClass tmpClass = (EClass)tmpPack.eContents().get(0);
        Assert.assertEquals((Object)"C1", (Object)tmpClass.getName());
        Assert.assertTrue((boolean)tmpClass.eContents().isEmpty());
        tmpClass = (EClass)tmpPack.eContents().get(1);
        Assert.assertEquals((Object)"C2", (Object)tmpClass.getName());
        Assert.assertTrue((boolean)tmpClass.eContents().isEmpty());
    }

    protected void assertStateMaster(URI fileURI, IStorageProviderAccessor accessor, IStorageProviderAccessor.DiffSide side) throws Exception {
        ExtensibleURIConverterImpl delegate = new ExtensibleURIConverterImpl();
        RevisionedURIConverter converter = new RevisionedURIConverter((URIConverter)delegate, accessor, side);
        InputStream stream = converter.createInputStream(fileURI, Collections.emptyMap());
        ResourceSetImpl tmpSet = new ResourceSetImpl();
        Resource tmpResource = tmpSet.createResource(fileURI);
        tmpResource.load(stream, Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)tmpResource.getContents().size());
        Assert.assertTrue((boolean)(tmpResource.getContents().get(0) instanceof EPackage));
        EPackage tmpPack = (EPackage)tmpResource.getContents().get(0);
        Assert.assertEquals((Object)"P1", (Object)tmpPack.getName());
        Assert.assertEquals((long)1L, (long)tmpPack.eContents().size());
        Assert.assertTrue((boolean)(tmpPack.eContents().get(0) instanceof EClass));
        EClass tmpClass = (EClass)tmpPack.eContents().get(0);
        Assert.assertEquals((Object)"C1_renamed", (Object)tmpClass.getName());
        Assert.assertTrue((boolean)tmpClass.eContents().isEmpty());
    }

    protected void assertStateBranch(URI fileURI, IStorageProviderAccessor accessor, IStorageProviderAccessor.DiffSide side) throws Exception {
        ExtensibleURIConverterImpl delegate = new ExtensibleURIConverterImpl();
        RevisionedURIConverter converter = new RevisionedURIConverter((URIConverter)delegate, accessor, side);
        InputStream stream = converter.createInputStream(fileURI, Collections.emptyMap());
        ResourceSetImpl tmpSet = new ResourceSetImpl();
        Resource tmpResource = tmpSet.createResource(fileURI);
        tmpResource.load(stream, Collections.emptyMap());
        Assert.assertEquals((long)1L, (long)tmpResource.getContents().size());
        Assert.assertTrue((boolean)(tmpResource.getContents().get(0) instanceof EPackage));
        EPackage tmpPack = (EPackage)tmpResource.getContents().get(0);
        Assert.assertEquals((Object)"P1", (Object)tmpPack.getName());
        Assert.assertEquals((long)3L, (long)tmpPack.eContents().size());
        Assert.assertTrue((boolean)(tmpPack.eContents().get(0) instanceof EClass));
        Assert.assertTrue((boolean)(tmpPack.eContents().get(1) instanceof EClass));
        Assert.assertTrue((boolean)(tmpPack.eContents().get(2) instanceof EClass));
        EClass tmpClass1 = (EClass)tmpPack.eContents().get(0);
        EClass tmpClass2 = (EClass)tmpPack.eContents().get(1);
        EClass tmpClass3 = (EClass)tmpPack.eContents().get(2);
        Assert.assertEquals((Object)"C1", (Object)tmpClass1.getName());
        Assert.assertEquals((long)1L, (long)tmpClass1.eContents().size());
        Assert.assertTrue((boolean)(tmpClass1.eContents().get(0) instanceof EGenericType));
        Assert.assertTrue((boolean)tmpClass1.getESuperTypes().contains((Object)tmpClass2));
        Assert.assertEquals((Object)"C2", (Object)tmpClass2.getName());
        Assert.assertTrue((boolean)tmpClass2.eContents().isEmpty());
        Assert.assertEquals((Object)"C3", (Object)tmpClass3.getName());
        Assert.assertTrue((boolean)tmpClass3.eContents().isEmpty());
    }
}

