/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.egit.fixture;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.time.MonotonicClock;
import org.eclipse.jgit.util.time.ProposedTimestamp;

public class MockSystemReader
extends SystemReader {
    long now = 1250379778668L;
    final Map<String, String> values = new HashMap<String, String>();
    private FileBasedConfig userGitConfig;
    FileBasedConfig systemGitConfig;

    public FileBasedConfig setUserGitConfig(FileBasedConfig userGitConfig) {
        FileBasedConfig old = this.userGitConfig;
        this.userGitConfig = userGitConfig;
        return old;
    }

    public FileBasedConfig setSystemGitConfig(FileBasedConfig systemGitConfig) {
        FileBasedConfig old = this.systemGitConfig;
        this.systemGitConfig = systemGitConfig;
        return old;
    }

    public MockSystemReader() {
        this.init("user.name");
        this.init("GIT_AUTHOR_NAME");
        this.init("GIT_AUTHOR_EMAIL");
        this.init("GIT_COMMITTER_NAME");
        this.init("GIT_COMMITTER_EMAIL");
        this.setProperty("user.dir", ".");
        this.userGitConfig = new MockConfig(null, null);
        this.systemGitConfig = new MockConfig(null, null);
        this.setCurrentPlatform();
    }

    private void init(String n) {
        this.setProperty(n, n);
    }

    public void clearProperties() {
        this.values.clear();
    }

    public void setProperty(String key, String value) {
        this.values.put(key, value);
    }

    public String getenv(String variable) {
        return this.values.get(variable);
    }

    public String getProperty(String key) {
        return this.values.get(key);
    }

    public FileBasedConfig openUserConfig(Config parent, FS fs) {
        assert (parent == null || parent == this.systemGitConfig);
        return this.userGitConfig;
    }

    public FileBasedConfig openSystemConfig(Config parent, FS fs) {
        assert (parent == null);
        return this.systemGitConfig;
    }

    public StoredConfig getUserConfig() throws IOException, ConfigInvalidException {
        return this.userGitConfig;
    }

    public StoredConfig getSystemConfig() throws IOException, ConfigInvalidException {
        return this.systemGitConfig;
    }

    public String getHostname() {
        return "fake.host.example.com";
    }

    public long getCurrentTime() {
        return this.now;
    }

    public MonotonicClock getClock() {
        return () -> {
            final long t = this.getCurrentTime();
            return new ProposedTimestamp(){

                public long read(TimeUnit unit) {
                    return unit.convert(t, TimeUnit.MILLISECONDS);
                }

                public void blockUntil(Duration maxWait) {
                }
            };
        };
    }

    public void tick(int secDelta) {
        this.now += (long)secDelta * 1000L;
    }

    public int getTimezone(long when) {
        return this.getTimeZone().getOffset(when) / 60000;
    }

    public TimeZone getTimeZone() {
        return TimeZone.getTimeZone("GMT-03:30");
    }

    public Locale getLocale() {
        return Locale.US;
    }

    public SimpleDateFormat getSimpleDateFormat(String pattern) {
        return new SimpleDateFormat(pattern, this.getLocale());
    }

    public DateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle, this.getLocale());
    }

    public void setCurrentPlatform() {
        this.resetOsNames();
        this.setProperty("os.name", System.getProperty("os.name"));
        this.setProperty("file.separator", System.getProperty("file.separator"));
        this.setProperty("path.separator", System.getProperty("path.separator"));
        this.setProperty("line.separator", System.getProperty("line.separator"));
    }

    public void setWindows() {
        this.resetOsNames();
        this.setProperty("os.name", "Windows");
        this.setProperty("file.separator", "\\");
        this.setProperty("path.separator", ";");
        this.setProperty("line.separator", "\r\n");
        this.setPlatformChecker();
    }

    public void setUnix() {
        this.resetOsNames();
        this.setProperty("os.name", "*nix");
        this.setProperty("file.separator", "/");
        this.setProperty("path.separator", ":");
        this.setProperty("line.separator", "\n");
        this.setPlatformChecker();
    }

    private void resetOsNames() {
        try {
            Field field = SystemReader.class.getDeclaredField("isWindows");
            field.setAccessible(true);
            field.set(null, null);
            field = SystemReader.class.getDeclaredField("isMacOS");
            field.setAccessible(true);
            field.set(null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "MockSystemReader";
    }

    private static final class MockConfig
    extends FileBasedConfig {
        private MockConfig(File cfgLocation, FS fs) {
            super(cfgLocation, fs);
        }

        public void load() throws IOException, ConfigInvalidException {
        }

        public void save() throws IOException {
        }

        public boolean isOutdated() {
            return false;
        }

        public String toString() {
            return "MockConfig";
        }
    }
}

