/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.tests.include;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.uml2.internal.DirectedRelationshipChange;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.compare.uml2.tests.include.data.IncludeInputData;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddIncludeTest
extends AbstractUMLTest {
    private IncludeInputData input = new IncludeInputData();

    @BeforeClass
    public static void setupClass() {
        AddIncludeTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        AddIncludeTest.resetRegistries();
    }

    @Test
    public void testA10UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, null);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, null);
    }

    @Test
    public void testA11UseCase() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)right, (Notifier)left, null);
        this.testMergeRightToLeft((Notifier)right, (Notifier)left, null);
    }

    @Test
    public void testA10UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)right);
        this.testAB1(AbstractUMLTest.TestKind.ADD, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)right);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)right);
    }

    @Test
    public void testA11UseCase3way() throws IOException {
        Resource left = this.input.getA1Left();
        Resource right = this.input.getA1Right();
        Comparison comparison = this.compare((Notifier)left, (Notifier)right, (Notifier)left);
        this.testAB1(AbstractUMLTest.TestKind.DELETE, comparison);
        this.testMergeLeftToRight((Notifier)left, (Notifier)right, (Notifier)left);
        this.testMergeRightToLeft((Notifier)left, (Notifier)right, (Notifier)left);
    }

    private void testAB1(AbstractUMLTest.TestKind kind, Comparison comparison) {
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)3L, (long)differences.size());
        Predicate addExtendDescription = null;
        Predicate changeRefExtendedCaseInExtendDescription = null;
        if (kind.equals((Object)AbstractUMLTest.TestKind.DELETE)) {
            addExtendDescription = EMFComparePredicates.removed((String)"model.UseCase1.include");
            changeRefExtendedCaseInExtendDescription = EMFComparePredicates.changedReference((String)"model.UseCase1.include", (String)"addition", (String)"model.UseCase", null);
        } else {
            addExtendDescription = EMFComparePredicates.added((String)"model.UseCase1.include");
            changeRefExtendedCaseInExtendDescription = EMFComparePredicates.changedReference((String)"model.UseCase1.include", (String)"addition", null, (String)"model.UseCase");
        }
        Diff addExtend = (Diff)Iterators.find(differences.iterator(), (Predicate)addExtendDescription);
        Diff addRefExtendedCaseInExtend = (Diff)Iterators.find(differences.iterator(), (Predicate)changeRefExtendedCaseInExtendDescription);
        Assert.assertNotNull((Object)addExtend);
        Assert.assertNotNull((Object)addRefExtendedCaseInExtend);
        Assert.assertEquals((long)1L, (long)AddIncludeTest.count((List<Diff>)differences, (Predicate<Object>)Predicates.instanceOf(DirectedRelationshipChange.class)));
        Diff addUMLExtend = null;
        addUMLExtend = kind.equals((Object)AbstractUMLTest.TestKind.ADD) ? (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))) : (Diff)Iterators.find(differences.iterator(), (Predicate)Predicates.and((Predicate)Predicates.instanceOf(DirectedRelationshipChange.class), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.DELETE)));
        Assert.assertNotNull((Object)addUMLExtend);
        Assert.assertEquals((long)2L, (long)addUMLExtend.getRefinedBy().size());
        Assert.assertTrue((boolean)addUMLExtend.getRefinedBy().contains((Object)addRefExtendedCaseInExtend));
        Assert.assertTrue((boolean)addUMLExtend.getRefinedBy().contains((Object)addExtend));
        if (kind.equals((Object)AbstractUMLTest.TestKind.ADD)) {
            Assert.assertEquals((long)1L, (long)addRefExtendedCaseInExtend.getRequires().size());
            Assert.assertTrue((boolean)addRefExtendedCaseInExtend.getRequires().contains((Object)addExtend));
            Assert.assertEquals((long)0L, (long)addExtend.getRequires().size());
            Assert.assertEquals((long)0L, (long)addUMLExtend.getRequires().size());
        } else {
            Assert.assertEquals((long)0L, (long)addRefExtendedCaseInExtend.getRequires().size());
            Assert.assertEquals((long)1L, (long)addExtend.getRequires().size());
            Assert.assertTrue((boolean)addExtend.getRequires().contains((Object)addRefExtendedCaseInExtend));
            Assert.assertEquals((long)0L, (long)addUMLExtend.getRequires().size());
        }
        Assert.assertEquals((long)0L, (long)comparison.getEquivalences().size());
        this.testIntersections(comparison);
    }

    @Override
    protected AbstractUMLInputData getInput() {
        return this.input;
    }
}

