/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.examples.statements.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.examples.extlibrary.presentation.EXTLibraryEditor;
import org.eclipse.emf.query.examples.statements.internal.l10n.QueryStatementsMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueryDelegate
implements IEditorActionDelegate,
IActionDelegate2 {
    protected static final String MESSAGE_EXCEPTION = QueryStatementsMessages.message_exception;
    protected Shell shell = null;
    protected EXTLibraryEditor editor = null;
    protected Collection<EObject> selectedEObjects = null;
    protected String title;
    protected String message;
    protected String notFoundMessage;

    public AbstractQueryDelegate(String titleIn, String messageIn, String notFoundMessageIn) {
        this.title = titleIn;
        this.message = messageIn;
        this.notFoundMessage = notFoundMessageIn;
    }

    protected abstract Collection<EObject> performQuery(Object var1) throws Exception;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedEObjects = null;
        try {
            try {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    this.selectedEObjects = new ArrayList<EObject>();
                    for (Object next : structuredSelection.toList()) {
                        if (!(next instanceof EObject)) continue;
                        this.selectedEObjects.add((EObject)next);
                    }
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)MESSAGE_EXCEPTION);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            action.setEnabled(this.selectedEObjects != null);
            throw throwable;
        }
        action.setEnabled(this.selectedEObjects != null);
    }

    public void dispose() {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (EXTLibraryEditor)targetEditor;
        if (targetEditor != null) {
            this.shell = targetEditor.getSite().getShell();
        }
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }
}

