/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.resource.HbResource;
import org.eclipse.emf.teneo.mapping.elist.PersistableEList;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.hibernate.collection.AbstractPersistentCollection;
import org.hibernate.collection.PersistentBag;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.collection.PersistentIdentifierBag;
import org.hibernate.collection.PersistentList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernatePersistableEList<E>
extends PersistableEList<E>
implements ExtensionPoint {
    private static final long serialVersionUID = -4553160393592497834L;
    private static Log log = LogFactory.getLog(HibernatePersistableEList.class);

    public HibernatePersistableEList(InternalEObject owner, EStructuralFeature feature, List<E> list) {
        super(owner, feature, list);
    }

    public boolean isInitialized() {
        return ((PersistentCollection)this.delegate).wasInitialized();
    }

    public boolean isLoaded() {
        boolean isDelegateLoaded;
        boolean bl = isDelegateLoaded = this.delegate instanceof AbstractPersistentCollection && ((AbstractPersistentCollection)this.delegate).wasInitialized();
        if (!super.isLoaded() && !this.isLoading() && isDelegateLoaded) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persistentlist already initialized, probably eagerly loaded: " + this.getLogString()));
            }
            try {
                this.setIsLoading(true);
                this.doLoad();
                this.setIsLoaded(true);
            }
            finally {
                this.setIsLoading(false);
            }
        }
        return super.isLoaded();
    }

    protected synchronized void doLoad() {
        AssertUtil.assertTrue((String)("EList " + this.logString), (!this.isLoaded() ? 1 : 0) != 0);
        log.debug((Object)("Started loading elist " + this.logString));
        SessionWrapper sessionWrapper = null;
        boolean controlsTransaction = false;
        boolean err = true;
        Resource res = null;
        try {
            res = this.owner.eResource();
            if (res != null && res instanceof HbResource) {
                sessionWrapper = ((HbResource)res).getSessionWrapper();
                if (res.isLoaded()) {
                    boolean isDelegateLoaded;
                    boolean bl = isDelegateLoaded = this.delegate instanceof AbstractPersistentCollection && ((AbstractPersistentCollection)this.delegate).wasInitialized();
                    if (!isDelegateLoaded && !sessionWrapper.isTransactionActive()) {
                        log.debug((Object)("Reconnecting session to read a lazy collection, elist: " + this.logString));
                        controlsTransaction = true;
                        sessionWrapper.beginTransaction();
                        sessionWrapper.setFlushModeManual();
                    } else {
                        log.debug((Object)"Delegate loaded or resource session is still active, using it");
                    }
                } else {
                    log.debug((Object)("Elist uses session from resource, " + this.logString));
                }
            } else {
                log.debug((Object)"EList is not loaded in session context");
            }
            if (controlsTransaction) {
                assert (res instanceof HbResource);
                ((StoreResource)res).setIsLoading(true);
            }
            try {
                Object element;
                int n;
                int n2;
                Object[] objectArray;
                Object[] objs = this.delegate.toArray();
                if (this.isContainment()) {
                    objectArray = objs;
                    n2 = objs.length;
                    n = 0;
                    while (n < n2) {
                        element = objectArray[n];
                        if (element instanceof InternalEObject) {
                            EContainerRepairControl.setContainer((InternalEObject)this.owner, (InternalEObject)((InternalEObject)element), (EStructuralFeature)this.getEStructuralFeature());
                        }
                        ++n;
                    }
                }
                if (res != null && res instanceof StoreResource) {
                    objectArray = objs;
                    n2 = objs.length;
                    n = 0;
                    while (n < n2) {
                        element = objectArray[n];
                        if (element instanceof EObject) {
                            ((StoreResource)res).addToContentOrAttach((InternalEObject)element, (EReference)this.getEStructuralFeature());
                        }
                        ++n;
                    }
                }
                log.debug((Object)("Loaded " + objs.length + " from backend store for " + this.logString));
            }
            finally {
                if (controlsTransaction) {
                    ((StoreResource)res).setIsLoading(false);
                }
            }
            err = false;
        }
        finally {
            if (controlsTransaction) {
                if (err) {
                    sessionWrapper.rollbackTransaction();
                    sessionWrapper.restorePreviousFlushMode();
                } else {
                    sessionWrapper.commitTransaction();
                    sessionWrapper.restorePreviousFlushMode();
                }
            }
            if (sessionWrapper != null) {
                ((HbResource)res).returnSessionWrapper(sessionWrapper);
            }
        }
        log.debug((Object)("Finished loading elist " + this.logString));
    }

    public void replaceDelegate(List<E> newDelegate) {
        if (newDelegate instanceof PersistentList) {
            super.replaceDelegate(newDelegate);
        } else if (newDelegate instanceof PersistentBag) {
            super.replaceDelegate(newDelegate);
        } else if (newDelegate instanceof PersistentIdentifierBag) {
            super.replaceDelegate(newDelegate);
        } else if (newDelegate != this.delegate) {
            throw new HbMapperException("Type " + newDelegate.getClass().getName() + " can not be " + " used as a replacement for elist " + this.logString);
        }
    }

    public boolean isPersistencyWrapped() {
        return this.delegate instanceof PersistentCollection;
    }
}

