/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import javax.jdo.Transaction;
import javax.jdo.identity.SingleFieldIdentity;
import javax.jdo.spi.PersistenceCapable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.jpox.JpoxDataStore;
import org.eclipse.emf.teneo.jpox.JpoxHelper;
import org.eclipse.emf.teneo.jpox.JpoxStoreException;
import org.eclipse.emf.teneo.jpox.JpoxUtil;
import org.eclipse.emf.teneo.jpox.resource.PMController;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.jpox.store.OID;
import org.jpox.store.OIDFactory;

public class JPOXResource
extends StoreResource {
    private static Log log = LogFactory.getLog(JPOXResource.class);
    public static final String FETCH_MINIMAL = "fetch_minimal";
    public static final String PM_CONTROLLER_PARAM = "pmController";
    protected PersistenceManager persistenceManager;
    protected Transaction tx = null;
    protected final JpoxDataStore emfDataStore;
    private boolean fetchMinimal = false;
    private boolean fetchAll = false;
    private PMController pmController = null;
    private boolean hasPMController = false;

    public JPOXResource(URI uri) {
        this(uri, false);
    }

    public JPOXResource(URI uri, boolean useAllFetchGroup) {
        super(uri);
        log.debug((Object)("Created jpoxresource using uri: " + uri.toString()));
        Map params = this.decodeQueryString(uri.query());
        String emfdsName = null;
        if (uri.query() == null && uri.fileExtension() != null) {
            if ("ejdo".compareTo(uri.fileExtension()) == 0) {
                log.debug((Object)("Assuming this is a property file " + uri.toString()));
                try {
                    URIConverter uriConverter = this.getURIConverter();
                    InputStream is = uriConverter.createInputStream(uri);
                    Properties props = new Properties();
                    props.load(is);
                    is.close();
                    emfdsName = props.getProperty("name");
                    JpoxUtil.getCreateDataStore(props);
                    this.setDefinedQueries(this.getQueries(props));
                }
                catch (IOException e) {
                    throw new JpoxStoreException("Exception when reading properties from: " + uri.toString(), e);
                }
            } else {
                log.debug((Object)("Trying fileextension: " + uri.fileExtension()));
                emfdsName = uri.fileExtension();
            }
            this.emfDataStore = JpoxHelper.INSTANCE.getDataStore(emfdsName);
            super.init(this.emfDataStore.getTopClasses());
        } else if (params.get("dsname") != null) {
            emfdsName = this.getParam(params, "dsname", uri.query());
            this.setDefinedQueries(this.getQueries(params));
            this.emfDataStore = JpoxHelper.INSTANCE.getDataStore(emfdsName);
            super.init(this.emfDataStore.getTopClasses());
        } else if (params.get(PM_CONTROLLER_PARAM) != null) {
            this.setDefinedQueries(this.getQueries(params));
            String scName = this.getParam(params, PM_CONTROLLER_PARAM, uri.query());
            this.pmController = PMController.getPMController(scName);
            log.debug((Object)("Using p, controller " + scName));
            this.emfDataStore = this.pmController.getJpoxDataStore();
            this.hasPMController = true;
            super.init(this.emfDataStore.getTopClasses());
        } else {
            throw new JpoxStoreException("The following uri can not be used to create a jpoxresource, it misses parameters for either the jpoxdatastore or a pmController " + uri.toString());
        }
        log.debug((Object)("Looking for emf data store using  " + emfdsName));
        String fetch_param = (String)params.get(FETCH_MINIMAL);
        this.fetchMinimal = fetch_param != null && fetch_param.compareToIgnoreCase("true") == 0;
        this.fetchAll = useAllFetchGroup;
    }

    public PersistenceManager getPersistenceManager() {
        if (this.persistenceManager == null) {
            this.persistenceManager = this.pmController != null ? this.pmController.getPM() : this.emfDataStore.getPMF().getPersistenceManager();
            if (this.fetchAll) {
                log.debug((Object)("Fetchgroup contains all fields for this resource; " + this.uri));
                this.persistenceManager.getFetchPlan().addGroup("all");
            } else if (this.fetchMinimal) {
                log.debug((Object)("Minimal fetch group used for resource; " + this.uri));
                this.persistenceManager.getFetchPlan().addGroup("default");
            } else {
                log.debug((Object)("Standard emf/jpox fetch group used for resource; " + this.uri));
            }
        }
        return this.persistenceManager;
    }

    public void detached(EObject eObject) {
        if (((PersistenceCapable)eObject).jdoIsDeleted()) {
            this.detachedHelper(eObject);
            return;
        }
        super.detached(eObject);
    }

    public Object[] getCrossReferencers(EObject referedTo) {
        Transaction tx = null;
        boolean err = true;
        try {
            if (!this.hasPMController) {
                tx = this.getPersistenceManager().currentTransaction();
                tx.begin();
            }
            Object[] result = this.emfDataStore.getCrossReferencers(this.getPersistenceManager(), referedTo);
            err = false;
            Object[] objectArray = result;
            return objectArray;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new JpoxStoreException("Exception when doing cross reference search " + this.emfDataStore.getName(), e);
        }
        finally {
            if (!this.hasPMController) {
                if (err) {
                    if (tx != null && tx.isActive()) {
                        tx.rollback();
                    }
                } else {
                    tx.commit();
                }
                tx = null;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected EObject getEObjectByID(String id) {
        EObject firstCheck;
        if (id == null) {
            return super.getEObjectByID(id);
        }
        if (this.getIntrinsicIDToEObjectMap() != null && (firstCheck = (EObject)this.getIntrinsicIDToEObjectMap().get(id)) != null) {
            return firstCheck;
        }
        Transaction tx = null;
        boolean err = true;
        try {
            if (!this.hasPMController && !(tx = this.getPersistenceManager().currentTransaction()).isActive()) {
                log.warn((Object)"Resource getobjectbyid: the transaction of the resource should always be active, but it isn't when save starts, beginning transaction");
                tx.begin();
            }
            log.debug((Object)("Reading eobject using urifragment " + id));
            try {
                InternalEObject obj = (InternalEObject)this.getPersistenceManager().getObjectById((Object)new OID(id));
                boolean oldLoading = this.isLoading();
                try {
                    this.setIsLoading(true);
                    this.addToContent(obj);
                }
                finally {
                    this.setIsLoading(oldLoading);
                }
                err = false;
                InternalEObject internalEObject = obj;
                return internalEObject;
            }
            catch (IllegalArgumentException e) {
                EObject eObject;
                block18: {
                    block22: {
                        block19: {
                            log.debug((Object)("Exception when decoding id " + id + ", this is not necessarily an error, trying superclass"), (Throwable)e);
                            eObject = super.getEObjectByID(id);
                            if (this.hasPMController) break block18;
                            if (!err) break block19;
                            log.warn((Object)"Exception during getobjectbyid, rolling back transaction");
                            tx.rollback();
                            break block22;
                        }
                        log.warn((Object)"Committing transaction");
                        tx.commit();
                    }
                    tx = this.getPersistenceManager().currentTransaction();
                    tx.begin();
                    tx = null;
                }
                return eObject;
            }
            catch (StringIndexOutOfBoundsException e) {
                EObject eObject;
                block20: {
                    block23: {
                        block21: {
                            log.debug((Object)("Exception when decoding id " + id + ", this is not necessarily an error, trying superclass"), (Throwable)e);
                            eObject = super.getEObjectByID(id);
                            if (this.hasPMController) break block20;
                            if (!err) break block21;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            log.warn((Object)"Exception during getobjectbyid, rolling back transaction");
                            tx.rollback();
                            break block23;
                        }
                        log.warn((Object)"Committing transaction");
                        tx.commit();
                    }
                    tx = this.getPersistenceManager().currentTransaction();
                    tx.begin();
                    tx = null;
                }
                return eObject;
            }
        }
        finally {
            if (!this.hasPMController) {
                if (err) {
                    log.warn((Object)"Exception during getobjectbyid, rolling back transaction");
                    tx.rollback();
                } else {
                    log.warn((Object)"Committing transaction");
                    tx.commit();
                }
                tx = this.getPersistenceManager().currentTransaction();
                tx.begin();
                tx = null;
            }
        }
    }

    public String getURIFragment(EObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof PersistenceCapable && this.getPersistenceManager().getObjectId((Object)object) != null) {
            OID oid = this.getPersistenceManager().getObjectId((Object)object) instanceof OID ? (OID)this.getPersistenceManager().getObjectId((Object)object) : OIDFactory.getInstance((String)object.getClass().getName(), (Object)((SingleFieldIdentity)this.getPersistenceManager().getObjectId((Object)object)).getKeyAsObject());
            if (oid == null) {
                return super.getURIFragment(object);
            }
            return oid.toString();
        }
        return super.getURIFragment(object);
    }

    protected void saveResource(Map options) {
        log.debug((Object)("SAVING DAO jpoxresource using uri: " + this.uri.toString()));
        if (!this.hasPMController) {
            this.tx = this.getPersistenceManager().currentTransaction();
            if (!this.tx.isActive()) {
                log.warn((Object)"Resource save: the transaction of the resource should always be active, but it isn't when save starts, beginning transaction");
                this.tx.begin();
            }
        }
        boolean err = true;
        try {
            for (Object obj : this.getContents()) {
                PersistenceCapable pc;
                if (!(obj instanceof PersistenceCapable) || (pc = (PersistenceCapable)obj).jdoIsPersistent()) continue;
                this.getPersistenceManager().makePersistent((Object)pc);
            }
            ArrayList<PersistenceCapable> reallyRemove = new ArrayList<PersistenceCapable>();
            for (Object o : this.removedEObjects) {
                PersistenceCapable pc = (PersistenceCapable)o;
                EObject eobj = (EObject)pc;
                if (!pc.jdoIsPersistent() || pc.jdoIsDeleted() || eobj.eResource() != null && eobj.eResource() != this) continue;
                reallyRemove.add(pc);
            }
            this.getPersistenceManager().deletePersistentAll(reallyRemove);
            err = false;
        }
        finally {
            if (!this.hasPMController) {
                if (err) {
                    log.warn((Object)"Exception during save, rolling back transaction");
                    this.tx.rollback();
                } else {
                    log.warn((Object)"Committing transaction");
                    this.tx.commit();
                }
                this.tx = this.getPersistenceManager().currentTransaction();
                this.tx.begin();
                this.tx = null;
            }
        }
    }

    public List loadResource(Map options) {
        log.debug((Object)("Loading resource: " + this.getURI().toString()));
        if (!this.hasPMController) {
            this.tx = this.getPersistenceManager().currentTransaction();
            if (!this.tx.isActive()) {
                log.debug((Object)"Starting transaction");
                this.tx.begin();
            }
        }
        List readObjects = null;
        ResourceImpl.ContentsEList elist = (ResourceImpl.ContentsEList)super.getContents();
        readObjects = this.loadFromStore(this.getPersistenceManager());
        for (InternalEObject eobj : readObjects) {
            EContainerRepairControl.repair((Object)eobj);
        }
        log.debug((Object)("Loaded " + elist.size() + " objects"));
        return readObjects;
    }

    public void close() {
        log.debug((Object)("Closing resource " + this.getURI()));
        if (this.getPersistenceManager().currentTransaction().isActive()) {
            log.debug((Object)"Closing transaction");
            this.getPersistenceManager().currentTransaction().commit();
        }
        log.debug((Object)"Closing persistencemanager");
        this.getPersistenceManager().close();
    }

    protected void doUnload() {
        if (!this.hasPMController) {
            if (this.getPersistenceManager().currentTransaction().isActive()) {
                log.debug((Object)"At unload, transaction is still active committing it");
                this.getPersistenceManager().currentTransaction().commit();
            }
            log.debug((Object)"At unload: closing and nullifying persistencemanager");
            this.getPersistenceManager().close();
        }
        this.persistenceManager = null;
        super.doUnload();
    }

    protected List loadFromStore(PersistenceManager pm) {
        if (this.definedQueriesPresent()) {
            return this.loadUsingDefinedQueries(pm);
        }
        return this.loadUsingTopClasses(pm);
    }

    private ArrayList loadUsingTopClasses(PersistenceManager pm) {
        log.debug((Object)("Loading resource " + this.getURI() + " using top classes"));
        ArrayList<InternalEObject> readObjects = new ArrayList<InternalEObject>();
        int i = 0;
        while (i < this.topClassNames.length) {
            String topClassName = this.topClassNames[i];
            Query qry = pm.newQuery("SELECT FROM " + topClassName);
            log.debug((Object)("Loading objects using oql: SELECT FROM " + topClassName));
            List result = (List)qry.execute();
            for (InternalEObject eobj : result) {
                if (this.emfDataStore.isContainedObject(eobj)) continue;
                readObjects.add(eobj);
            }
            ++i;
        }
        return readObjects;
    }

    private ArrayList loadUsingDefinedQueries(PersistenceManager pm) {
        String[] qrys;
        log.debug((Object)("Loading resource " + this.getURI() + " using defined queries"));
        ArrayList<InternalEObject> readObjects = new ArrayList<InternalEObject>();
        String[] stringArray = qrys = this.getDefinedQueries();
        int n = qrys.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            log.debug((Object)("Loading objects using query: " + element));
            Query qry = pm.newQuery(element);
            List result = (List)qry.execute();
            for (InternalEObject eobj : result) {
                readObjects.add(eobj);
            }
            ++n2;
        }
        return readObjects;
    }
}

