/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox;

import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceMappingBuilder;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerFactory;
import org.eclipse.emf.teneo.jpox.DefaultPMFCreator;
import org.eclipse.emf.teneo.jpox.JpoxDataStore;
import org.eclipse.emf.teneo.jpox.PMFCreator;
import org.eclipse.emf.teneo.jpox.mapper.JPOXMappingGenerator;
import org.eclipse.emf.teneo.jpox.resource.JPOXResourceFactory;

public class JpoxHelper {
    private static Log log = LogFactory.getLog(JpoxHelper.class);
    public static final JpoxHelper INSTANCE = new JpoxHelper();
    private PMFCreator pmfCreator = new DefaultPMFCreator();
    private String jdoFileExtension = "jdo";
    private final Hashtable emfDataStores = new Hashtable();

    static {
        log.info((Object)"Registering a jpox resource factory for all uri's with jpox as the protocol/extension");
        log.info((Object)"Registering a jpox resource factory for all uri's with ejdo as the protocol/extension");
        log.info((Object)"Registering a jpox resource dao factory for all uri's with jpoxdao as the protocol/extension");
        Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().put("jpox", new JPOXResourceFactory());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("jpox", new JPOXResourceFactory());
        Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().put("jpoxdao", new JPOXResourceFactory());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("jpoxdao", new JPOXResourceFactory());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ejdo", new JPOXResourceFactory());
        System.setProperty("org.jpox.cache.level1.type", "org.eclipse.emf.teneo.jpox.cache.EMFWeakRefCache");
    }

    public void setJdoFileExtension(String newExtension) {
        log.debug((Object)("Setting jdofileextension to " + newExtension));
        this.jdoFileExtension = newExtension;
    }

    public String getJdoFileExtension() {
        return this.jdoFileExtension;
    }

    public void setPMFCreator(PMFCreator pmfc) {
        log.info((Object)("Setting persistence manager factory creator to " + pmfc.getClass().getName()));
        this.pmfCreator = pmfc;
    }

    public PMFCreator getPMFCreator() {
        return this.pmfCreator;
    }

    public void closeAll() {
        for (JpoxDataStore jds : this.emfDataStores.values()) {
            jds.close();
        }
        this.emfDataStores.clear();
    }

    public synchronized JpoxDataStore getDataStore(String name) {
        JpoxDataStore jds = (JpoxDataStore)this.emfDataStores.get(name);
        if (jds == null) {
            log.debug((Object)("No jpox datastore found using name: " + name));
        }
        return jds;
    }

    public synchronized void deRegisterDataStore(String name) {
        JpoxDataStore ds = (JpoxDataStore)this.emfDataStores.get(name);
        if (ds == null) {
            log.warn((Object)("No pmf or emf datastore registered under the name " + name));
            return;
        }
        ds.close();
        this.emfDataStores.remove(name);
    }

    public synchronized JpoxDataStore createRegisterDataStore(String name) {
        JpoxDataStore jds = (JpoxDataStore)this.emfDataStores.get(name);
        if (jds != null) {
            log.warn((Object)("JpoxDataStore already registered under: " + name + " returning that one"));
        }
        jds = new JpoxDataStore();
        jds.setName(name);
        this.emfDataStores.put(name, jds);
        return jds;
    }

    public String generateMapping(EPackage[] epackages, Properties props) {
        return this.generateMapping(epackages, props, ExtensionManagerFactory.getInstance().create());
    }

    public String generateMapping(EPackage[] epackages, Properties props, ExtensionManager extensionManager) {
        log.debug((Object)"Generating mapping file passed epackages");
        PersistenceOptions po = (PersistenceOptions)extensionManager.getExtension(PersistenceOptions.class, new Object[]{props});
        PAnnotatedModel paModel = ((PersistenceMappingBuilder)extensionManager.getExtension(PersistenceMappingBuilder.class)).buildMapping(epackages, po, extensionManager);
        JPOXMappingGenerator jmg = (JPOXMappingGenerator)extensionManager.getExtension(JPOXMappingGenerator.class);
        jmg.setPersistenceOptions(po);
        return jmg.generate(paModel);
    }
}

