/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.annotations;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.parser.EAnnotationParserImporter;
import org.eclipse.emf.teneo.hibernate.hbannotation.HbannotationPackage;

public class HbEAnnotationParserImporter
extends EAnnotationParserImporter {
    private static final String HB_PREFIX = "hb:";

    protected boolean isValidSource(String source) {
        if (source == null) {
            return false;
        }
        return source.startsWith("teneo.hibernate") || super.isValidSource(source);
    }

    public EClass getEClass(String name) {
        if (name.startsWith(HB_PREFIX)) {
            return (EClass)HbannotationPackage.eINSTANCE.getEClassifier(name.substring(HB_PREFIX.length()));
        }
        EClass eClass = super.getEClass(name);
        if (eClass == null) {
            return (EClass)HbannotationPackage.eINSTANCE.getEClassifier(name);
        }
        return eClass;
    }

    public EStructuralFeature getEStructuralFeature(EClass eClass, String name) {
        for (Object name2 : eClass.getEAllStructuralFeatures()) {
            EStructuralFeature ef = (EStructuralFeature)name2;
            if (ef.getName().compareToIgnoreCase(name) != 0) continue;
            return ef;
        }
        String hbName = "hb" + name;
        for (Object name2 : eClass.getEAllStructuralFeatures()) {
            EStructuralFeature ef = (EStructuralFeature)name2;
            if (ef.getName().compareToIgnoreCase(hbName) != 0) continue;
            return ef;
        }
        throw new IllegalArgumentException("No efeature " + name + " for eclass " + eClass.getName());
    }
}

