/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.Properties;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.BasicPamodelBuilder;
import org.eclipse.emf.teneo.annotations.mapper.EClassAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.EDataTypeAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.EFeatureAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.ManyToOneReferenceAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.OneToManyAttributeAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.OneToManyReferenceAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.OneToOneReferenceAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceMappingBuilder;
import org.eclipse.emf.teneo.annotations.mapper.SingleAttributeAnnotator;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.parser.EAnnotationParserImporter;
import org.eclipse.emf.teneo.annotations.xml.XmlPersistenceMapper;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerFactory;
import org.eclipse.emf.teneo.extension.ExtensionUtil;
import org.eclipse.emf.teneo.hibernate.annotations.HbAnnotationModelBuilder;
import org.eclipse.emf.teneo.hibernate.annotations.HbEAnnotationParserImporter;
import org.eclipse.emf.teneo.hibernate.annotations.HbEClassAnnotator;
import org.eclipse.emf.teneo.hibernate.annotations.HbEDataTypeAnnotator;
import org.eclipse.emf.teneo.hibernate.annotations.HbEFeatureAnnotator;
import org.eclipse.emf.teneo.hibernate.annotations.HbManyToOneReferenceAnnotator;
import org.eclipse.emf.teneo.hibernate.annotations.HbOneToManyAttributeAnnotator;
import org.eclipse.emf.teneo.hibernate.annotations.HbOneToManyReferenceAnnotator;
import org.eclipse.emf.teneo.hibernate.annotations.HbOneToOneReferenceAnnotator;
import org.eclipse.emf.teneo.hibernate.annotations.HbSingleAttributeAnnotator;
import org.eclipse.emf.teneo.hibernate.annotations.HbXmlPersistenceMapper;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedETypeElement;
import org.eclipse.emf.teneo.hibernate.mapper.HibernateMappingGenerator;

public class MappingUtil {
    public static String generateMapping(EPackage[] epackages, Properties props) {
        ExtensionManager extensionManager = ExtensionManagerFactory.getInstance().create();
        return MappingUtil.generateMapping(epackages, props, extensionManager);
    }

    public static String generateMapping(EPackage[] epackages, Properties props, ExtensionManager extensionManager) {
        MappingUtil.registerHbExtensions(extensionManager);
        PersistenceOptions po = (PersistenceOptions)extensionManager.getExtension(PersistenceOptions.class, new Object[]{props});
        PAnnotatedModel paModel = ((PersistenceMappingBuilder)extensionManager.getExtension(PersistenceMappingBuilder.class)).buildMapping(epackages, po, extensionManager);
        HibernateMappingGenerator hmg = (HibernateMappingGenerator)extensionManager.getExtension(HibernateMappingGenerator.class);
        hmg.setPersistenceOptions(po);
        return hmg.generateToString(paModel);
    }

    public static String getCollectionElement(HbAnnotatedETypeElement hbFeature) {
        boolean hasOrderBy;
        boolean bl = hasOrderBy = hbFeature instanceof PAnnotatedEReference && ((PAnnotatedEReference)hbFeature).getOrderBy() != null;
        if (!hbFeature.getOneToMany().isList() || hasOrderBy) {
            return "set";
        }
        if (hbFeature.getOneToMany().isList() && !hbFeature.getOneToMany().isIndexed()) {
            return "bag";
        }
        return "list";
    }

    public static void registerHbExtensions(ExtensionManager extensionManager) {
        extensionManager.registerExtension(ExtensionUtil.createExtension(BasicPamodelBuilder.class, HbAnnotationModelBuilder.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(EAnnotationParserImporter.class, HbEAnnotationParserImporter.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(XmlPersistenceMapper.class, HbXmlPersistenceMapper.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(SingleAttributeAnnotator.class, HbSingleAttributeAnnotator.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(EClassAnnotator.class, HbEClassAnnotator.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(EFeatureAnnotator.class, HbEFeatureAnnotator.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(OneToManyAttributeAnnotator.class, HbOneToManyAttributeAnnotator.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(EDataTypeAnnotator.class, HbEDataTypeAnnotator.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(OneToManyReferenceAnnotator.class, HbOneToManyReferenceAnnotator.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(OneToOneReferenceAnnotator.class, HbOneToOneReferenceAnnotator.class));
        extensionManager.registerExtension(ExtensionUtil.createExtension(ManyToOneReferenceAnnotator.class, HbManyToOneReferenceAnnotator.class));
    }
}

