/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.CollectionTable;
import org.eclipse.emf.teneo.annotations.pannotation.JoinColumn;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.OneToMany;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.hbannotation.Filter;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEAttribute;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedETypeElement;
import org.eclipse.emf.teneo.hibernate.mapper.AbstractAssociationMapper;
import org.eclipse.emf.teneo.hibernate.mapper.FeatureMapMapping;
import org.eclipse.emf.teneo.simpledom.Element;

public class ManyAttributeMapper
extends AbstractAssociationMapper
implements ExtensionPoint {
    private static final Log log = LogFactory.getLog(ManyAttributeMapper.class);

    public void processManyAttribute(PAnnotatedEAttribute paAttribute) {
        CollectionTable jt;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generating many valued attribute mapping for " + paAttribute));
        }
        HbAnnotatedEAttribute hbAttribute = (HbAnnotatedEAttribute)paAttribute;
        EAttribute eattr = paAttribute.getModelEAttribute();
        boolean isArray = eattr.getEType().getInstanceClass() != null && eattr.getEType().getInstanceClass().isArray();
        Element collElement = this.addCollectionElement((PAnnotatedEStructuralFeature)paAttribute);
        Element keyElement = collElement.addElement("key");
        Object object = jt = paAttribute.getCollectionTable() != null ? paAttribute.getCollectionTable() : paAttribute.getJoinTable();
        ArrayList<JoinColumn> jcs = jt != null && jt.getJoinColumns().size() > 0 ? jt.getJoinColumns() : (paAttribute.getJoinColumns() == null ? new ArrayList<JoinColumn>() : paAttribute.getJoinColumns());
        OneToMany otm = paAttribute.getOneToMany();
        if (jt != null) {
            this.addJoinTable(hbAttribute, collElement, keyElement, (JoinTable)jt);
            this.addKeyColumns(hbAttribute, keyElement, jcs);
        } else {
            this.addKeyColumns(hbAttribute, keyElement, jcs);
        }
        if (!otm.isIndexed() && isArray) {
            log.warn((Object)"One to many is not indexed but this is an array, force=ing index column!");
        }
        if ((otm.isIndexed() || isArray) && hbAttribute.getHbIdBag() == null) {
            this.addListIndex(collElement, (PAnnotatedEStructuralFeature)paAttribute);
        }
        if (!isArray) {
            this.addFetchType(collElement, otm.getFetch());
        }
        this.addCascadesForMany(collElement, this.getCascades(hbAttribute.getHbCascade(), (List<CascadeType>)otm.getCascade(), false));
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)paAttribute.getModelEAttribute())) {
            if (this.getHbmContext().getPersistenceOptions().isMapFeatureMapAsComponent()) {
                Element curElement = this.getHbmContext().getCurrent();
                FeatureMapMapping fmm = new FeatureMapMapping(this.getHbmContext(), paAttribute);
                Element element = collElement.addElement("composite-element").addAttribute("class", this.getHbmContext().getFeatureMapEntryClassName());
                fmm.setCompositeElement(element);
                fmm.process();
                this.getHbmContext().setCurrent(curElement);
            } else {
                FeatureMapMapping fmm = new FeatureMapMapping(this.getHbmContext(), paAttribute);
                this.getHbmContext().addFeatureMapMapper(fmm);
                collElement.addElement("one-to-many").addAttribute("entity-name", fmm.getEntityName());
            }
        } else {
            this.addElementElement(collElement, (PAnnotatedEStructuralFeature)paAttribute, this.getColumns((PAnnotatedEStructuralFeature)paAttribute), otm.getTargetEntity());
        }
        this.addAccessor(collElement);
        this.mapFilter(collElement, (List<Filter>)((HbAnnotatedETypeElement)paAttribute).getFilter());
    }
}

