/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.mapping.elist;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.teneo.mapping.elist.PersistableDelegateList;
import org.eclipse.emf.teneo.mapping.elist.PersistableEMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapPersistableEMap<K, V>
extends PersistableEMap<K, V>
implements PersistableDelegateList<BasicEMap.Entry<K, V>> {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(MapPersistableEMap.class);
    protected Map<K, V> ormMapDelegate = null;
    private final boolean mapValueIsEAttribute;

    public MapPersistableEMap(EClass entryEClass, EList<BasicEMap.Entry<K, V>> delegateEList) {
        super(entryEClass, delegateEList);
        throw new UnsupportedOperationException("Explicitly passing delegate list is not supported!");
    }

    public MapPersistableEMap(EClass entryEClass, Class<?> entryClass, InternalEObject owner, EStructuralFeature feature) {
        this(entryEClass, owner, feature, (Map<K, V>)null);
    }

    public MapPersistableEMap(EClass entryEClass, InternalEObject owner, EStructuralFeature feature, Map<K, V> ormMapDelegate) {
        super(entryEClass, owner, feature, new ArrayList());
        this.setORMMapDelegate(ormMapDelegate);
        this.setDelegateEList(owner, feature, (List<BasicEMap.Entry<K, V>>)this.newList());
        if (this.isInitialized()) {
            this.setLoaded();
            this.size();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created persistable emap for entry eclass " + entryEClass.getName()));
        }
        this.mapValueIsEAttribute = entryEClass.getEStructuralFeature("value") instanceof EAttribute;
    }

    public MapPersistableEMap(EClass entryEClass, InternalEObject owner, EStructuralFeature feature, List<BasicEMap.Entry<K, V>> list) {
        super(entryEClass, owner, feature, list);
        this.setORMMapDelegate(null);
        this.setLoaded();
        this.size();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created persistable emap for entry eclass " + entryEClass.getName()));
        }
        this.mapValueIsEAttribute = entryEClass.getEStructuralFeature("value") instanceof EAttribute;
    }

    @Override
    protected void setDelegateEList(InternalEObject owner, EStructuralFeature feature, List<BasicEMap.Entry<K, V>> delegateORMList) {
    }

    @Override
    protected EList<BasicEMap.Entry<K, V>> createDelegateEList(InternalEObject owner, EStructuralFeature feature, List<BasicEMap.Entry<K, V>> delegateORMList) {
        throw new UnsupportedOperationException("This method should not be called!");
    }

    protected abstract boolean isORMMapDelegateLoaded();

    protected void setLoaded() {
        if (this.getORMMapDelegate() == null) {
            this.setLoaded(true);
        } else if (this.getORMMapDelegate() != null && this.isORMMapDelegateLoaded()) {
            this.load();
        } else {
            this.setLoaded(false);
        }
    }

    @Override
    public Object getDelegate() {
        if (this.getORMMapDelegate() != null) {
            return this.getORMMapDelegate();
        }
        return this.map();
    }

    @Override
    public void replaceDelegate(Object newDelegate) {
        this.setORMMapDelegate(null);
        this.doClear();
        this.setORMMapDelegate((Map)newDelegate);
        this.setLoaded(false);
    }

    public Map<K, V> getORMMapDelegate() {
        return this.ormMapDelegate;
    }

    protected void setORMMapDelegate(Map<K, V> ormMapDelegate) {
        this.ormMapDelegate = ormMapDelegate;
    }

    public boolean isMapValueIsEAttribute() {
        return this.mapValueIsEAttribute;
    }

    protected void didAdd(BasicEMap.Entry<K, V> entry) {
        if (this.getORMMapDelegate() != null) {
            this.getORMMapDelegate().put(entry.getKey(), entry.getValue());
        }
        super.didAdd(entry);
    }

    protected void didModify(BasicEMap.Entry<K, V> entry, V oldValue) {
        if (this.getORMMapDelegate() != null) {
            this.getORMMapDelegate().put(entry.getKey(), entry.getValue());
        }
        super.didModify(entry, oldValue);
    }

    protected void didRemove(BasicEMap.Entry<K, V> entry) {
        if (this.getORMMapDelegate() != null) {
            this.getORMMapDelegate().remove(entry.getKey());
        }
        super.didRemove(entry);
    }
}

