/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.StoreValidationException;
import org.eclipse.emf.teneo.resource.NonLoadingDiagnostician;
import org.eclipse.emf.teneo.resource.NonLoadingEContentsEList;
import org.eclipse.emf.teneo.resource.StoreResourceException;
import org.eclipse.emf.teneo.util.FieldUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoreResource
extends ResourceImpl {
    public static final String DS_NAME_PARAM = "dsname";
    public static final String QUERY_PREFIX = "query";
    public static final String LOAD_STRATEGY_PARAM = "loadStrategy";
    public static final String ADD_TO_CONTENTS = "addToContents";
    public static final String SET_ERESOURCE = "setEResource";
    public static final String NOT_SET_ERESOURCE = "notSetEResource";
    private static Log log = LogFactory.getLog(StoreResource.class);
    protected List<EObject> removedEObjects = new ArrayList<EObject>();
    protected HashSet<EObject> loadedEObjects = new HashSet();
    protected HashSet<EObject> loadedEObjectSet = new HashSet();
    protected List<EObject> newEObjects = new ArrayList<EObject>();
    protected HashSet<EObject> newEObjectSet = new HashSet();
    protected HashSet<EObject> modifiedEObjects = new HashSet();
    protected boolean isUnLoading = false;
    protected String[] topClassNames;
    private String[] definedQueries = new String[0];
    private boolean sendNotificationsOnLoad = true;
    private boolean sendNotificationSetByParam = false;
    private String loadStrategy = "setEResource";

    public StoreResource(URI uri) {
        super(uri);
        Map<String, String> params = this.decodeQueryString(uri.query());
        if (params.get(LOAD_STRATEGY_PARAM) != null) {
            this.loadStrategy = params.get(LOAD_STRATEGY_PARAM);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created " + ((Object)((Object)this)).getClass().getName() + " using uri: " + uri.toString()));
        }
        if (params.get("DISABLE_NOTIFY") != null) {
            this.sendNotificationSetByParam = true;
            this.sendNotificationsOnLoad = "false".compareToIgnoreCase(params.get("DISABLE_NOTIFY")) == 0;
        } else if (params.get("DISABLE_NOTIFY") != null) {
            this.sendNotificationSetByParam = true;
            this.sendNotificationsOnLoad = "false".compareToIgnoreCase(params.get("DISABLE_NOTIFY")) == 0;
        }
        this.setLoaded(false);
        if (this.getContents().size() == 0 && log.isDebugEnabled()) {
            log.debug((Object)"Initialized contents member");
        }
        this.setIntrinsicIDToEObjectMap(new HashMap());
    }

    protected void init(String[] topClasses) {
        this.topClassNames = topClasses;
    }

    public void setIsLoading(boolean loading) {
        this.isLoading = loading;
    }

    public void setDefinedQueries(String[] qrys) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Setting defined queries of resource " + this.getURI().toString() + "/" + ((Object)((Object)this)).getClass().getName()));
            String[] stringArray = qrys;
            int n = qrys.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                log.debug((Object)("Adding query: " + element));
                ++n2;
            }
        }
        this.definedQueries = qrys;
    }

    public boolean definedQueriesPresent() {
        return this.definedQueries.length > 0;
    }

    public String[] getDefinedQueries() {
        return this.definedQueries;
    }

    protected String[] getQueries(Map<?, ?> params) {
        ArrayList<String> queries = new ArrayList<String>();
        for (Object key : params.keySet()) {
            if (!((String)key).startsWith(QUERY_PREFIX)) continue;
            queries.add((String)params.get(key));
        }
        return queries.toArray(new String[queries.size()]);
    }

    protected String getParam(Map<String, String> params, String paramName, String report) {
        String param = params.get(paramName);
        if (param == null) {
            throw new StoreResourceException("Parameter " + paramName + " missing in querystring: " + report);
        }
        return param;
    }

    protected Map<String, String> decodeQueryString(String qryStr) {
        String[] qryParts;
        TreeMap<String, String> result = new TreeMap<String, String>();
        if (qryStr == null) {
            return result;
        }
        String[] stringArray = qryParts = qryStr.split("&");
        int n = qryParts.length;
        int n2 = 0;
        while (n2 < n) {
            String qryPart = stringArray[n2];
            String fieldName = qryPart.substring(0, qryPart.indexOf(61));
            String fieldValue = URI.decode((String)qryPart.substring(qryPart.indexOf(61) + 1));
            result.put(fieldName, fieldValue);
            ++n2;
        }
        return result;
    }

    public abstract Object[] getCrossReferencers(EObject var1);

    protected abstract List<EObject> loadResource(Map<?, ?> var1);

    protected abstract void saveResource(Map<?, ?> var1);

    public boolean isUnLoading() {
        return this.isUnLoading;
    }

    public void load(Map<?, ?> options) {
        String option;
        if (this.isUnLoading) {
            return;
        }
        if (this.isLoaded()) {
            return;
        }
        if (this.isLoading()) {
            return;
        }
        if (options != null && (option = (String)options.get("DISABLE_NOTIFY")) != null) {
            this.sendNotificationsOnLoad = "false".compareToIgnoreCase(option) == 0;
        } else if (options != null && (option = (String)options.get("DISABLE_NOTIFY")) != null) {
            this.sendNotificationsOnLoad = "false".compareToIgnoreCase(option) == 0;
        } else if (!this.sendNotificationSetByParam) {
            this.sendNotificationsOnLoad = true;
        }
        if (options != null && options.get(LOAD_STRATEGY_PARAM) != null) {
            this.loadStrategy = (String)options.get(LOAD_STRATEGY_PARAM);
        }
        this.isLoading = true;
        Notification notification = this.setLoaded(true);
        try {
            this.clearChangeTrackerArrays();
            List<EObject> list = this.loadResource(options);
            for (EObject eObject : list) {
                this.addToContent((InternalEObject)eObject);
            }
        }
        finally {
            if (notification != null) {
                this.eNotify(notification);
            }
            this.setModified(false);
            this.isLoading = false;
        }
    }

    protected void addToContent(InternalEObject eObject) {
        if (!this.getLocalContents().contains(eObject)) {
            NotificationChain notifications = this.getLocalContents().basicAdd(eObject, null);
            if (notifications != null && this.sendNotificationsOnLoad) {
                notifications.dispatch();
            }
            this.setEResource(eObject, true);
            this.attached((EObject)eObject);
        }
    }

    protected void addUsingContainmentStructure(InternalEObject eObject) {
        boolean oldLoading = this.isLoading();
        try {
            this.setIsLoading(true);
            InternalEObject currentEObject = eObject;
            while (currentEObject.eContainer() != null && !currentEObject.eContainmentFeature().isResolveProxies()) {
                currentEObject = (InternalEObject)currentEObject.eContainer();
            }
            if (!this.loadedEObjectSet.contains(currentEObject)) {
                NotificationChain notifications = this.getLocalContents().basicAdd(eObject, null);
                if (notifications != null && this.sendNotificationsOnLoad) {
                    notifications.dispatch();
                }
                this.setEResource(eObject, true);
                this.attached((EObject)currentEObject);
            } else if (!this.loadedEObjectSet.contains(eObject)) {
                this.attached((EObject)eObject);
            }
        }
        finally {
            this.setIsLoading(oldLoading);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addToContentOrAttach(InternalEObject eObject, EReference eReference) {
        boolean oldLoading = this.isLoading();
        try {
            if (this.loadStrategy.compareTo(ADD_TO_CONTENTS) == 0) {
                if (eObject.eResource() != null && eObject.eResource() != this) {
                    return;
                }
                this.addUsingContainmentStructure(eObject);
                return;
            }
            if (eReference.isContainment()) {
                if (eReference.isResolveProxies() && eObject.eResource() != null && eObject.eResource() != this) {
                    return;
                }
                assert (eObject.eContainer().eResource() == this);
                this.attached((EObject)eObject);
                return;
            }
            if (this.loadStrategy.compareTo(SET_ERESOURCE) != 0) return;
            this.setEResource(eObject, false);
            this.attached((EObject)eObject);
            return;
        }
        finally {
            this.setIsLoading(oldLoading);
        }
    }

    public void save(Map<?, ?> options) {
        boolean err = true;
        try {
            try {
                this.setAllowNotifications(false);
                this.validateContents();
                this.saveResource(options);
                err = false;
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }
        finally {
            this.setAllowNotifications(true);
            if (!err) {
                this.modifiedEObjects.clear();
                this.removedEObjects.clear();
                this.loadedEObjects.addAll(this.newEObjects);
                this.loadedEObjectSet.addAll(this.newEObjects);
                this.newEObjects.clear();
                this.newEObjectSet.clear();
                this.setModified(false);
            }
        }
    }

    protected void doUnload() {
        this.isUnLoading = true;
        super.doUnload();
        this.clearChangeTrackerArrays();
        this.isUnLoading = false;
    }

    public EList<EObject> getContents() {
        if (this.contents == null) {
            this.contents = new LocalContentsEList();
        }
        return this.contents;
    }

    protected LocalContentsEList getLocalContents() {
        return (LocalContentsEList)this.getContents();
    }

    protected void validateContents() throws StoreValidationException {
        ArrayList<EObject> newOrChangedObjects = new ArrayList<EObject>(this.newEObjects);
        newOrChangedObjects.addAll(this.modifiedEObjects);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validating contents of resource " + this.uri + " approx. " + newOrChangedObjects.size() + " will be checked"));
        }
        ArrayList<Diagnostic> diags = new ArrayList<Diagnostic>();
        int i = 0;
        while (i < newOrChangedObjects.size()) {
            Diagnostic diag;
            InternalEObject obj = (InternalEObject)newOrChangedObjects.get(i);
            if (obj.eResource() != this) assert (obj.eResource() == this);
            EContainerRepairControl.setEResourceToAlLContent(obj, (Resource)this);
            if (!newOrChangedObjects.contains(obj.eContainer()) && (diag = this.validateObject(newOrChangedObjects.get(i))) != null) {
                diags.add(diag);
            }
            ++i;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Found " + diags.size() + " errors "));
        }
        if (diags.size() > 0) {
            throw new StoreValidationException(diags.toArray(new Diagnostic[diags.size()]));
        }
    }

    public Diagnostic validateObject(EObject eObject) {
        Diagnostic diagnostic = NonLoadingDiagnostician.INSTANCE.validate(eObject);
        if (diagnostic.getSeverity() == 4) {
            return diagnostic;
        }
        return null;
    }

    public void clearChangeTrackerArrays() {
        this.removedEObjects.clear();
        this.newEObjects.clear();
        this.newEObjectSet.clear();
        this.loadedEObjects.clear();
        this.loadedEObjectSet.clear();
        this.modifiedEObjects.clear();
    }

    public void modifiedEObject(EObject eObject) {
        if (this.loadedEObjectSet.contains(eObject) && !this.modifiedEObjects.contains(eObject)) {
            assert (!this.newEObjectSet.contains(eObject));
            this.modifiedEObjects.add(eObject);
        }
    }

    public void addedEObject(EObject eObject) {
        if (this.isLoading()) {
            if (this.removedEObjects.contains(eObject)) {
                return;
            }
            assert (!this.loadedEObjectSet.contains(eObject));
            this.loadedEObjects.add(eObject);
            this.loadedEObjectSet.add(eObject);
        } else {
            assert (!this.newEObjectSet.contains(eObject));
            if (this.removedEObjects.remove(eObject)) {
                this.modifiedEObjects.add(eObject);
            } else {
                this.newEObjects.add(eObject);
                this.newEObjectSet.add(eObject);
            }
        }
    }

    public void removedEObject(EObject eObject) {
        assert (!this.removedEObjects.contains(eObject));
        if (this.newEObjectSet.contains(eObject)) {
            assert (this.newEObjects.contains(eObject));
            this.newEObjects.remove(eObject);
            this.newEObjectSet.remove(eObject);
            return;
        }
        if (!this.loadedEObjectSet.contains(eObject)) assert (!this.loadedEObjects.contains(eObject));
        assert (!this.removedEObjects.contains(eObject));
        if (!(eObject instanceof BasicEMap.Entry)) {
            this.removedEObjects.add(eObject);
        }
        this.loadedEObjects.remove(eObject);
        this.loadedEObjectSet.remove(eObject);
        this.modifiedEObjects.remove(eObject);
    }

    public void attached(EObject eObject) {
        this.attachedHelper(eObject);
        Iterator tree = this.getNonResolvingContent(eObject).basicIterator();
        while (tree.hasNext()) {
            Object obj = tree.next();
            this.attached((EObject)obj);
        }
    }

    public void detached(EObject eObject) {
        this.detachedHelper(eObject);
        for (EObject object : this.getNonResolvingContent(eObject)) {
            this.detachedHelper(object);
        }
    }

    protected void attachedHelper(EObject eObject) {
        Map map;
        if (this.newEObjectSet.contains(eObject) || this.loadedEObjectSet.contains(eObject)) {
            return;
        }
        if (eObject.eResource() != null && eObject.eResource() != this) {
            return;
        }
        this.addedEObject(eObject);
        if (this.isTrackingModification()) {
            eObject.eAdapters().add((Object)this.modificationTrackingAdapter);
        }
        if ((map = this.getIntrinsicIDToEObjectMap()) != null) {
            String id = EcoreUtil.getID((EObject)eObject);
            if (id != null) {
                map.put(id, eObject);
            } else {
                id = this.getURIFragment(eObject);
                if (id != null) {
                    map.put(id, eObject);
                }
            }
        }
        for (EReference eref : eObject.eClass().getEAllReferences()) {
            Resource res;
            if (eref.isMany() || eObject.eGet((EStructuralFeature)eref, false) == null || (res = ((EObject)eObject.eGet((EStructuralFeature)eref)).eResource()) != null) continue;
            InternalEObject referedTo = (InternalEObject)eObject.eGet((EStructuralFeature)eref);
            this.addToContentOrAttach(referedTo, eref);
        }
    }

    public void setEResource(InternalEObject eobj, boolean force) {
        if (eobj.eResource() != null && eobj.eResource() != this && !force) {
            return;
        }
        Resource prevResource = eobj.eResource();
        InternalEObject currentEObject = eobj;
        ArrayList<InternalEObject> toMove = new ArrayList<InternalEObject>();
        while (currentEObject.eContainer() != null && !currentEObject.eContainmentFeature().isResolveProxies()) {
            toMove.add(currentEObject);
            currentEObject = (InternalEObject)currentEObject.eContainer();
        }
        if (currentEObject.eResource() != this) {
            currentEObject.eSetResource((Resource.Internal)this, null);
            this.attached((EObject)currentEObject);
        }
        for (EObject eObject : toMove) {
            if (prevResource == null || eObject.eResource() == prevResource) continue;
            ((ResourceImpl.ContentsEList)prevResource.getContents()).basicRemove((Object)eObject, null);
        }
    }

    protected void detachedHelper(EObject eObject) {
        if (eObject.eResource() != this) {
            this.removedEObjects.remove(eObject);
            this.modifiedEObjects.remove(eObject);
            this.loadedEObjects.remove(eObject);
            this.loadedEObjectSet.remove(eObject);
            this.newEObjects.remove(eObject);
            this.newEObjectSet.remove(eObject);
            return;
        }
        this.removedEObject(eObject);
        Map map = this.getIntrinsicIDToEObjectMap();
        if (map != null) {
            String id = EcoreUtil.getID((EObject)eObject);
            if (id != null) {
                map.remove(id);
            } else {
                id = this.getURIFragment(eObject);
                if (id != null) {
                    map.remove(id);
                }
            }
        }
        if (this.isTrackingModification()) {
            eObject.eAdapters().remove((Object)this.modificationTrackingAdapter);
        }
    }

    public List<EObject> getNewEObjects() {
        return this.newEObjects;
    }

    public HashSet<EObject> getNewEObjectSet() {
        return this.newEObjectSet;
    }

    public HashSet<EObject> getModifiedEObjects() {
        return this.modifiedEObjects;
    }

    public List<EObject> getRemovedEObjects() {
        return this.removedEObjects;
    }

    public void setTrackingModification(boolean isTrackingModification) {
        boolean oldIsTrackingModification;
        boolean bl = oldIsTrackingModification = this.modificationTrackingAdapter != null;
        if (oldIsTrackingModification != isTrackingModification) {
            if (isTrackingModification) {
                Adapter adapter = this.createModificationTrackingAdapter();
                TreeIterator<EObject> i = this.getNonResolvingAllContents();
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    assert (!eObject.eAdapters().contains((Object)adapter));
                    eObject.eAdapters().add((Object)adapter);
                }
                this.modificationTrackingAdapter = adapter;
            } else {
                Adapter oldModificationTrackingAdapter = this.modificationTrackingAdapter;
                TreeIterator<EObject> i = this.getNonResolvingAllContents();
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    assert (eObject.eAdapters().contains((Object)this.modificationTrackingAdapter));
                    eObject.eAdapters().remove((Object)oldModificationTrackingAdapter);
                }
                this.modificationTrackingAdapter = null;
            }
        }
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsTrackingModification, isTrackingModification){

                public Object getNotifier() {
                    return StoreResource.this;
                }

                public int getFeatureID(Class<?> expectedClass) {
                    return 5;
                }
            };
            this.eNotify((Notification)notification);
        }
    }

    protected TreeIterator<EObject> getNonResolvingAllContents() {
        return new AbstractTreeIterator<EObject>((Object)this, false){

            public Iterator<EObject> getChildren(Object object) {
                return object == StoreResource.this ? StoreResource.this.getLocalContents().basicIterator() : StoreResource.this.getNonResolvingContent((EObject)object).basicIterator();
            }
        };
    }

    protected TreeIterator<EObject> getAllProperContents(List<EObject> contents) {
        return this.getNonResolvingAllContents();
    }

    protected EContentsEList<EObject> getNonResolvingContent(EObject eObject) {
        return NonLoadingEContentsEList.create(eObject, false);
    }

    protected Adapter createModificationTrackingAdapter() {
        return new StoreModificationTrackingAdapter();
    }

    protected void setAllowNotifications(boolean allow) {
        TreeIterator<EObject> i = this.getNonResolvingAllContents();
        while (i.hasNext()) {
            EObject eObject = (EObject)i.next();
            eObject.eSetDeliver(allow);
        }
    }

    public boolean isSendNotificationsOnLoad() {
        return this.sendNotificationsOnLoad;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LocalContentsEList
    extends ResourceImpl.ContentsEList<EObject> {
        private static final long serialVersionUID = 1L;

        protected LocalContentsEList() {
            super((ResourceImpl)StoreResource.this);
        }

        public NotificationChain inverseRemove(EObject object, NotificationChain notifications) {
            if (!StoreResource.this.isUnLoading()) {
                return super.inverseRemove((Object)object, notifications);
            }
            if (!StoreResource.this.unloadingContents.contains(object)) {
                return super.inverseRemove((Object)object, notifications);
            }
            InternalEObject eObject = (InternalEObject)object;
            InternalEObject eContainer = eObject.eInternalContainer();
            if (eContainer == null) {
                return super.inverseRemove((Object)object, notifications);
            }
            if (eObject.eContainmentFeature().isResolveProxies()) {
                return super.inverseRemove((Object)object, notifications);
            }
            if (!(eObject instanceof BasicEObjectImpl)) {
                return super.inverseRemove((Object)object, notifications);
            }
            Resource.Internal oldResource = eObject.eDirectResource();
            if (oldResource != null) {
                if (StoreResource.this.isLoaded) {
                    StoreResource.this.detached((EObject)eObject);
                }
                notifications = ((InternalEList)oldResource.getContents()).basicRemove((Object)this, notifications);
                FieldUtil.callMethod(eObject, "eSetDirectResource", new Object[1]);
            }
            return notifications;
        }

        public boolean contains(Object object) {
            if (this.useEquals() && object != null) {
                int i = 0;
                while (i < this.size) {
                    if (object.equals(this.data[i])) {
                        return true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.size) {
                    if (this.data[i] == object) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }
    }

    protected class StoreModificationTrackingAdapter
    extends AdapterImpl {
        protected StoreModificationTrackingAdapter() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 7: {
                    if (notification.isTouch()) break;
                    StoreResource.this.setModified(true);
                    StoreResource.this.modifiedEObject((EObject)notification.getNotifier());
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    StoreResource.this.setModified(true);
                }
            }
        }
    }
}

