/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.TeneoException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreDataTypes {
    private static XMLTypePackage xmlTypePackage = XMLTypePackage.eINSTANCE;
    private static EDataType xmlDateEDataType = xmlTypePackage.getDate();
    private static EDataType xmlDateTimeEDataType = xmlTypePackage.getDateTime();
    private static EDataType xmlTimeEDataType = xmlTypePackage.getTime();
    private static final String ANNOTATION_SOURCE_METADATA = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
    private final DatatypeFactory dataTypeFactory;
    private static final List<EDataType> PRIMITIVES_ETYPES_LIST = Collections.unmodifiableList(Arrays.asList(EcorePackage.eINSTANCE.getEBoolean(), EcorePackage.eINSTANCE.getEByte(), EcorePackage.eINSTANCE.getEChar(), EcorePackage.eINSTANCE.getEDouble(), EcorePackage.eINSTANCE.getEFloat(), EcorePackage.eINSTANCE.getEInt(), EcorePackage.eINSTANCE.getELong(), EcorePackage.eINSTANCE.getEShort()));
    private static final List<Class<?>> PRIMITIVE_OBJECT_TYPE_LIST = Collections.unmodifiableList(Arrays.asList(Boolean.class, Byte.class, Double.class, Float.class, Integer.class, Long.class, BigDecimal.class, BigInteger.class));
    private static final List<EDataType> WRAPPERS_ETYPES_LIST = Collections.unmodifiableList(Arrays.asList(EcorePackage.eINSTANCE.getEBooleanObject(), EcorePackage.eINSTANCE.getEByteObject(), EcorePackage.eINSTANCE.getECharacterObject(), EcorePackage.eINSTANCE.getEDoubleObject(), EcorePackage.eINSTANCE.getEFloatObject(), EcorePackage.eINSTANCE.getEIntegerObject(), EcorePackage.eINSTANCE.getELongObject(), EcorePackage.eINSTANCE.getEShortObject()));
    public static EcoreDataTypes INSTANCE = new EcoreDataTypes();

    private EcoreDataTypes() {
        try {
            this.dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new TeneoException("Exception ", e);
        }
    }

    public String getTargetTypeName(PAnnotatedEAttribute aAttribute) {
        EAttribute eAttribute = aAttribute.getModelEAttribute();
        Class instanceClass = eAttribute.getEAttributeType().getInstanceClass();
        if (instanceClass != null && !Object.class.equals((Object)instanceClass) && !List.class.equals((Object)instanceClass)) {
            if (instanceClass.isArray()) {
                return eAttribute.getEType().getInstanceClassName().substring(0, eAttribute.getEType().getInstanceClassName().length() - 2);
            }
            return instanceClass.getName();
        }
        ArrayList<EClassifier> eclassifiers = this.getItemTypes((EDataType)eAttribute.getEType());
        if (eclassifiers.size() > 0) {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < eclassifiers.size()) {
                EClassifier eclassifier = eclassifiers.get(i);
                if (i > 0) {
                    result.append(",");
                }
                result.append(eclassifier.getInstanceClassName());
                ++i;
            }
            return result.toString();
        }
        return Object.class.getName();
    }

    public ArrayList<EClassifier> getItemTypes(EDataType eDataType) {
        ArrayList<EClassifier> tmpResult;
        EClassifier eClassifier;
        ArrayList<EClassifier> result = new ArrayList<EClassifier>();
        if (eDataType == null) {
            return result;
        }
        String itemType = this.getEAnnotationValue((EModelElement)eDataType, ANNOTATION_SOURCE_METADATA, "itemType");
        if (itemType != null) {
            EClassifier eClassifier2 = this.getEClassifier(eDataType.getEPackage(), itemType);
            if (eClassifier2 != null) {
                result.add(eClassifier2);
            }
            return result;
        }
        String memberTypes = this.getEAnnotationValue((EModelElement)eDataType, ANNOTATION_SOURCE_METADATA, "memberTypes");
        if (memberTypes != null) {
            String[] mtypes;
            String[] stringArray = mtypes = memberTypes.split(" ");
            int n = mtypes.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                EClassifier eclassifier = this.getEClassifier(eDataType.getEPackage(), element);
                if (eclassifier != null) {
                    result.addAll(this.getItemTypes((EDataType)eclassifier));
                }
                ++n2;
            }
            return result;
        }
        String baseType = this.getEAnnotationValue((EModelElement)eDataType, ANNOTATION_SOURCE_METADATA, "baseType");
        if (baseType != null && (eClassifier = this.getEClassifier(eDataType.getEPackage(), baseType)) != null && (tmpResult = this.getItemTypes((EDataType)eClassifier)).size() > 0) {
            result.addAll(tmpResult);
            return result;
        }
        if (!Object.class.equals((Object)eDataType.getInstanceClass())) {
            result.add((EClassifier)eDataType);
        }
        return result;
    }

    public EClassifier getEClassifier(EPackage epackage, String searchName) {
        for (EClassifier eclassifier : epackage.getEClassifiers()) {
            if (eclassifier.getName().compareTo(searchName) == 0) {
                return eclassifier;
            }
            String nameAnnotation = this.getEAnnotationValue((EModelElement)eclassifier, ANNOTATION_SOURCE_METADATA, "name");
            if (nameAnnotation == null || searchName.compareTo(nameAnnotation) != 0) continue;
            return eclassifier;
        }
        return null;
    }

    public String getEAnnotationValue(EModelElement eModelElement, String source, String key) {
        EAnnotation eAnnotation = eModelElement.getEAnnotation(source);
        if (eAnnotation == null) {
            return null;
        }
        return (String)eAnnotation.getDetails().get((Object)key);
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(java.util.Date date) {
        XMLGregorianCalendar gregCalendar = this.dataTypeFactory.newXMLGregorianCalendar();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        gregCalendar.setYear(calendar.get(1));
        gregCalendar.setMonth(calendar.get(2) + 1);
        gregCalendar.setDay(calendar.get(5));
        return gregCalendar;
    }

    public XMLGregorianCalendar getXMLGregorianCalendarDateTime(java.util.Date date) {
        XMLGregorianCalendar gregCalendar = this.dataTypeFactory.newXMLGregorianCalendar();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        gregCalendar.setYear(calendar.get(1));
        gregCalendar.setMonth(calendar.get(2) + 1);
        gregCalendar.setDay(calendar.get(5));
        gregCalendar.setHour(calendar.get(11));
        gregCalendar.setMinute(calendar.get(12));
        gregCalendar.setSecond(calendar.get(13));
        gregCalendar.setMillisecond(calendar.get(14));
        return gregCalendar;
    }

    public List<EDataType> getEPrimitives() {
        return PRIMITIVES_ETYPES_LIST;
    }

    public boolean isEPrimitive(EDataType eDataType) {
        return eDataType != null && this.isPrimitive(eDataType.getInstanceClass());
    }

    public boolean isPrimitive(Class<?> clz) {
        if (clz == null) {
            return false;
        }
        return clz.isPrimitive() || PRIMITIVE_OBJECT_TYPE_LIST.contains(clz);
    }

    public List<EDataType> getEWrappers() {
        return WRAPPERS_ETYPES_LIST;
    }

    public boolean isEWrapper(EDataType eDataType) {
        return WRAPPERS_ETYPES_LIST.contains(eDataType);
    }

    public boolean isEString(EDataType eDataType) {
        return String.class == eDataType.getInstanceClass();
    }

    public boolean isEDuration(EDataType eDataType) {
        String className = null;
        if (eDataType.getInstanceClassName() != null) {
            className = eDataType.getInstanceClassName();
        } else if (eDataType.getInstanceClass() != null) {
            className = eDataType.getInstanceClass().getName();
        } else {
            return false;
        }
        return className.compareTo("javax.xml.datatype.Duration") == 0;
    }

    public boolean isEDate(EDataType eDataType, PersistenceOptions po) {
        if (eDataType.equals(xmlDateEDataType)) {
            return true;
        }
        Class ic = eDataType.getInstanceClass();
        if (eDataType.getInstanceClassName() != null && eDataType.getInstanceClassName().compareTo(po.getXSDDateClass()) == 0) {
            return true;
        }
        return java.util.Date.class == ic || Calendar.class == ic || Date.class == ic;
    }

    public boolean isETime(EDataType eDataType) {
        if (eDataType.equals(xmlTimeEDataType)) {
            return true;
        }
        Class ic = eDataType.getInstanceClass();
        return Timestamp.class == ic || java.util.Date.class == ic;
    }

    public boolean isEDateTime(EDataType eDataType) {
        if (eDataType.equals(xmlDateTimeEDataType)) {
            return true;
        }
        Class ic = eDataType.getInstanceClass();
        return Timestamp.class == ic || java.util.Date.class == ic;
    }

    public boolean isSimpleType(EDataType eType, PersistenceOptions po) {
        return this.isEPrimitive(eType) || this.isEWrapper(eType) || this.isEString(eType) || this.isEDate(eType, po) || this.isEDateTime(eType);
    }

    public boolean isBasicType(EDataType eDataType, PersistenceOptions po) {
        return this.isSimpleType(eDataType, po) || this.isEnum((EClassifier)eDataType);
    }

    public boolean isEnum(EClassifier eClassifier) {
        return eClassifier instanceof EEnum;
    }

    public boolean isByteArray(EDataType eType) {
        Class clazz = eType.getInstanceClass();
        if (clazz != null) {
            return clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE);
        }
        return false;
    }
}

