/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.auditing;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbUtil;
import org.eclipse.emf.teneo.hibernate.auditing.AuditDataStore;
import org.eclipse.emf.teneo.hibernate.auditing.AuditHandler;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoAuditCommitInfo;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoAuditEntry;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoAuditKind;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoauditingFactory;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoauditingPackage;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.PostDeleteEvent;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostUpdateEvent;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.tuple.entity.EntityTuplizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditProcessHandler
implements AfterTransactionCompletionProcess,
BeforeTransactionCompletionProcess,
FlushEventListener,
PostDeleteEventListener,
PostInsertEventListener,
PostUpdateEventListener,
ExtensionPoint {
    private static Log log = LogFactory.getLog(AuditProcessHandler.class);
    public static final long DEFAULT_END_TIMESTAMP = -1L;
    public static final long HIGH_NUMBER = 1000000L;
    private static ThreadLocal<String> currentUserName = new ThreadLocal();
    private static ThreadLocal<String> currentComment = new ThreadLocal();
    private static final long serialVersionUID = 1L;
    private AuditDataStore dataStore;
    private Map<Transaction, List<AuditWork>> workQueue = new ConcurrentHashMap<Transaction, List<AuditWork>>();
    private int pruneCounter = 0;
    private long pruneTime = 0L;
    private long pruneInterval = 1000L;
    private List<String> auditEntityNames = null;
    private ThreadLocal<Boolean> inAuditWorkInSession = new ThreadLocal();
    private AuditHandler auditHandler = null;
    private boolean checkInitialAuditEntry = false;

    public static void setCurrentComment(String user) {
        currentComment.set(user);
    }

    public static void setCurrentUserName(String user) {
        currentUserName.set(user);
    }

    private void addToAuditWorkQueue(EventSource session, TeneoAuditKind auditKind, Object entity) {
        List<Object> auditWorks;
        if (!this.auditHandler.isAudited(entity)) {
            return;
        }
        AuditWork auditWork = new AuditWork();
        auditWork.setAuditKind(auditKind);
        auditWork.setEntity(entity);
        Object version = session.getEntityPersister(this.dataStore.toEntityName(this.auditHandler.getEClass(entity)), entity).getVersion(entity);
        if (auditKind == TeneoAuditKind.ADD) {
            auditWork.setVersion(1L);
        } else if (version == null) {
            long tmpVersion = System.currentTimeMillis();
            auditWork.setVersion(tmpVersion);
        } else if (version instanceof Timestamp) {
            auditWork.setVersion(((Timestamp)version).getTime());
        } else {
            auditWork.setVersion(((Number)version).longValue());
        }
        if (auditKind == TeneoAuditKind.DELETE) {
            auditWork.setVersion(1L + auditWork.getVersion());
        }
        if (this.workQueue.containsKey(session.getTransaction())) {
            auditWorks = this.workQueue.get(session.getTransaction());
        } else {
            auditWorks = new ArrayList();
            this.workQueue.put(session.getTransaction(), auditWorks);
            session.getActionQueue().registerProcess((AfterTransactionCompletionProcess)this);
            session.getActionQueue().registerProcess((BeforeTransactionCompletionProcess)this);
        }
        AuditWork existingAuditWork = null;
        for (AuditWork auditWork2 : auditWorks) {
            if (auditWork2.getEntity() != auditWork.getEntity()) continue;
            existingAuditWork = auditWork2;
            break;
        }
        if (existingAuditWork == null || existingAuditWork.getAuditKind() != TeneoAuditKind.ADD || auditWork.getAuditKind() != TeneoAuditKind.UPDATE) {
            if (existingAuditWork != null && existingAuditWork.getAuditKind() == TeneoAuditKind.ADD && auditWork.getAuditKind() == TeneoAuditKind.DELETE) {
                auditWorks.remove(existingAuditWork);
            } else if (existingAuditWork != null && existingAuditWork.getAuditKind() == TeneoAuditKind.UPDATE && auditWork.getAuditKind() == TeneoAuditKind.ADD) {
                auditWorks.remove(existingAuditWork);
            } else {
                if (existingAuditWork != null) {
                    auditWorks.remove(existingAuditWork);
                }
                auditWorks.add(auditWork);
            }
        }
    }

    public void onPostUpdate(PostUpdateEvent event) {
        AuditWork initialRecord = null;
        if (this.checkInitialAuditEntry) {
            Object object = event.getEntity();
            EClass eClass = this.auditHandler.getEClass(object);
            EClass auditEntryEClass = this.auditHandler.getAuditingModelElement(eClass);
            String auditEntryEntityName = HbUtil.getEntityName(auditEntryEClass);
            String objectId = this.auditHandler.entityToIdString((Session)event.getSession(), event.getEntity());
            Query infoQuery = event.getSession().createQuery("select count(teneo_object_id) from " + auditEntryEntityName + " e where teneo_object_id=:objectId and teneo_end=" + -1L);
            infoQuery.setMaxResults(1);
            infoQuery.setString("objectId", objectId);
            Number next = (Number)infoQuery.iterate().next();
            if (next != null && next.intValue() == 0) {
                EntityTuplizer entityTuplizer = event.getPersister().getEntityTuplizer();
                Object oldStateObject = entityTuplizer.instantiate();
                Object[] oldState = event.getOldState();
                entityTuplizer.setPropertyValues(oldStateObject, oldState);
                entityTuplizer.setIdentifier(oldStateObject, entityTuplizer.getIdentifier(object));
                this.addToAuditWorkQueue(event.getSession(), TeneoAuditKind.ADD, oldStateObject);
                List<AuditWork> auditWorks = this.workQueue.get(event.getSession().getTransaction());
                initialRecord = auditWorks.get(auditWorks.size() - 1);
            }
        }
        this.addToAuditWorkQueue(event.getSession(), TeneoAuditKind.UPDATE, event.getEntity());
        if (initialRecord != null) {
            List<AuditWork> auditWorks = this.workQueue.get(event.getSession().getTransaction());
            AuditWork updateRecord = auditWorks.get(auditWorks.size() - 1);
            updateRecord.setInitialRecord(initialRecord);
        }
    }

    public void onPostInsert(PostInsertEvent event) {
        this.addToAuditWorkQueue(event.getSession(), TeneoAuditKind.ADD, event.getEntity());
    }

    public void onPostDelete(PostDeleteEvent event) {
        this.addToAuditWorkQueue(event.getSession(), TeneoAuditKind.DELETE, event.getEntity());
    }

    public void doBeforeTransactionCompletion(SessionImplementor session) {
        if (session.getFlushMode() != FlushMode.MANUAL) {
            session.flush();
            List<AuditWork> auditWorks = this.getRemoveQueue((Session)session, false);
            if (auditWorks == null || auditWorks.isEmpty()) {
                return;
            }
            this.doAuditWorkInSession((Session)session, auditWorks);
        }
    }

    public void onFlush(FlushEvent event) throws HibernateException {
        if (this.inAuditWorkInSession.get() != null && this.inAuditWorkInSession.get().booleanValue()) {
            if (this.workQueue.get(event.getSession().getTransaction()) != null && !this.workQueue.get(event.getSession().getTransaction()).isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (AuditWork auditWork : this.workQueue.get(event.getSession().getTransaction())) {
                    sb.append("\n" + auditWork);
                }
                log.error((Object)("The audit work handling resulted in additional audit entries, this points to an error in dirty checking of properties (false dirties), audit entries: " + sb));
            }
            return;
        }
        List<AuditWork> auditWorks = this.getRemoveQueue((Session)event.getSession(), false);
        if (auditWorks == null || auditWorks.isEmpty()) {
            return;
        }
        this.doAuditWorkInSession((Session)event.getSession(), auditWorks);
    }

    public void doAfterTransactionCompletion(boolean success, SessionImplementor session) {
        if (!success) {
            return;
        }
        List<AuditWork> auditWorks = this.getRemoveQueue((Session)session, true);
        if (auditWorks == null || auditWorks.isEmpty()) {
            this.pruneEntries(session);
            return;
        }
        Session tmpSession = null;
        boolean err = true;
        try {
            tmpSession = session.getFactory().openSession();
            tmpSession.beginTransaction();
            this.doAuditWorkInSession(tmpSession, auditWorks);
            tmpSession.getTransaction().commit();
            err = false;
        }
        finally {
            try {
                if (tmpSession != null && err) {
                    tmpSession.getTransaction().rollback();
                }
            }
            finally {
                if (tmpSession != null) {
                    tmpSession.close();
                }
            }
        }
        this.pruneEntries(session);
    }

    protected long getCommitTime() {
        return System.currentTimeMillis();
    }

    protected void doAuditWorkInSession(Session session, List<AuditWork> auditWorks) {
        this.inAuditWorkInSession.set(true);
        try {
            long commitTime = this.getCommitTime();
            ArrayList<Object> toSaveEntries = new ArrayList<Object>();
            TeneoAuditCommitInfo commitInfo = TeneoauditingFactory.eINSTANCE.createTeneoAuditCommitInfo();
            if (currentUserName.get() != null) {
                commitInfo.setUser(currentUserName.get());
            }
            commitInfo.setCommitTime(commitTime);
            if (currentComment.get() != null) {
                if (currentComment.get().length() > 2000) {
                    commitInfo.setComment(currentComment.get().substring(0, 2000));
                } else {
                    commitInfo.setComment(currentComment.get());
                }
            }
            toSaveEntries.add(commitInfo);
            EClass lastEClass = null;
            EClass auditEntryEClass = null;
            for (AuditWork auditWork : auditWorks) {
                Object object = auditWork.getEntity();
                EClass eClass = this.auditHandler.getEClass(object);
                if (lastEClass != eClass) {
                    auditEntryEClass = this.auditHandler.getAuditingModelElement(eClass);
                    lastEClass = eClass;
                }
                String auditEntryEntityName = HbUtil.getEntityName(auditEntryEClass);
                TeneoAuditEntry auditEntry = (TeneoAuditEntry)auditEntryEClass.getEPackage().getEFactoryInstance().create(auditEntryEClass);
                auditEntry.setTeneo_audit_kind(auditWork.getAuditKind());
                auditEntry.setTeneo_commit_info(commitInfo);
                auditEntry.setTeneo_end(-1L);
                auditEntry.setTeneo_start(commitTime);
                auditEntry.setTeneo_object_id(this.auditHandler.entityToIdString(session, auditWork.getEntity()));
                auditEntry.setTeneo_object_version(auditWork.getVersion());
                this.setContainerInfo(session, auditEntry, auditWork.getEntity());
                this.auditHandler.copyContentToAuditEntry(session, auditWork.getEntity(), auditEntry, auditWork.getAuditKind() != TeneoAuditKind.DELETE);
                Query infoQuery = session.createQuery("select teneo_start, teneo_object_version, teneo_audit_kind from " + auditEntryEntityName + " e where teneo_object_id=:objectId and teneo_end=" + -1L);
                infoQuery.setMaxResults(1);
                infoQuery.setString("objectId", auditEntry.getTeneo_object_id());
                List list = infoQuery.list();
                if (!list.isEmpty()) {
                    Object[] values = (Object[])list.get(0);
                    Long startTime = (Long)values[0];
                    Long version = (Long)values[1];
                    if (this.performVersionCheck() && version > 0L && auditWork.getVersion() > 0L && auditWork.getVersion() < 1000000L && auditWork.getVersion() != version + 1L) {
                        throw new IllegalStateException("Version numbers should incrsement by 1, previous version: " + version + " new version " + auditWork.getVersion());
                    }
                    auditEntry.setTeneo_previous_start(startTime);
                    this.updateEndTime(session, auditEntryEntityName, auditEntry.getTeneo_object_id(), commitTime - 1L, false);
                    this.updateEndTimeDerivedObjects(session, auditEntryEClass, auditEntry.getTeneo_object_id(), commitTime - 1L);
                }
                toSaveEntries.add(auditEntry);
                this.setCommitInfoInReferencedObjects(auditEntry, toSaveEntries);
                if (auditWork.getInitialRecord() == null) continue;
                AuditWork initialRecord = auditWork.getInitialRecord();
                int indexOf = auditWorks.indexOf(initialRecord) + 1;
                TeneoAuditEntry initialAuditEntry = (TeneoAuditEntry)toSaveEntries.get(indexOf);
                long initialRecordTimestamp = auditEntry.getTeneo_start() - 1L;
                initialAuditEntry.setTeneo_start(initialRecordTimestamp);
                initialAuditEntry.setTeneo_end(initialRecordTimestamp);
                auditEntry.setTeneo_previous_start(initialRecordTimestamp);
            }
            session.flush();
            for (AuditWork auditWork : toSaveEntries) {
                session.save(HbUtil.getEntityName(this.auditHandler.getEClass(auditWork)), (Object)auditWork);
            }
            session.flush();
            for (AuditWork auditWork : toSaveEntries) {
                session.evict((Object)auditWork);
            }
            this.getRemoveQueue(session, false);
            ++this.pruneCounter;
        }
        finally {
            this.inAuditWorkInSession.set(null);
        }
    }

    protected boolean performVersionCheck() {
        return false;
    }

    protected void setContainerInfo(Session session, TeneoAuditEntry auditEntry, Object entity) {
        if (entity instanceof EObject) {
            this.auditHandler.setContainerInfo(session, auditEntry, entity);
        }
    }

    private void setCommitInfoInReferencedObjects(TeneoAuditEntry source, List<Object> toSaveObjects) {
        for (EReference eReference : source.eClass().getEAllReferences()) {
            if (!TeneoauditingPackage.eINSTANCE.getTeneoAuditEntry().isSuperTypeOf(eReference.getEReferenceType())) continue;
            if (eReference.isMany()) {
                int i = 0;
                for (Object value : (Collection)source.eGet((EStructuralFeature)eReference)) {
                    TeneoAuditEntry target = (TeneoAuditEntry)value;
                    toSaveObjects.add(target);
                    this.setAuditEntryValues(String.valueOf(eReference.getName()) + "_" + i++, source, target);
                }
                continue;
            }
            if (!source.eIsSet((EStructuralFeature)eReference) || source.eGet((EStructuralFeature)eReference) == null) continue;
            this.setAuditEntryValues(String.valueOf(eReference.getName()) + "_", source, (TeneoAuditEntry)source.eGet((EStructuralFeature)eReference));
            toSaveObjects.add((TeneoAuditEntry)source.eGet((EStructuralFeature)eReference));
        }
    }

    private void updateEndTimeDerivedObjects(Session session, EClass sourceEClass, String objectId, long newEnd) {
        for (EReference eReference : sourceEClass.getEAllReferences()) {
            EClass targetEClass = eReference.getEReferenceType();
            if (!TeneoauditingPackage.eINSTANCE.getTeneoAuditEntry().isSuperTypeOf(targetEClass)) continue;
            this.updateEndTime(session, this.dataStore.toEntityName(targetEClass), objectId, newEnd, true);
        }
    }

    private void updateEndTime(Session session, String entityName, String objectId, long newEnd, boolean useOwner) {
        String qryStr = "update " + entityName + " e set e.teneo_end = :newEnd " + "where e." + (useOwner ? "teneo_owner_object_id" : "teneo_object_id") + " = :objectId and e.teneo_end = :oldEnd";
        Query qry = session.createQuery(qryStr);
        qry.setParameter("newEnd", (Object)newEnd);
        qry.setParameter("objectId", (Object)objectId);
        qry.setParameter("oldEnd", (Object)-1L);
        qry.executeUpdate();
    }

    private void setAuditEntryValues(String prefix, TeneoAuditEntry source, TeneoAuditEntry target) {
        target.setTeneo_commit_info(source.getTeneo_commit_info());
        target.setTeneo_audit_kind(source.getTeneo_audit_kind());
        target.setTeneo_start(source.getTeneo_start());
        target.setTeneo_object_id(String.valueOf(prefix) + "_" + source.getTeneo_object_id());
        target.setTeneo_owner_object_id(source.getTeneo_object_id());
        target.setTeneo_object_version(source.getTeneo_object_version());
        target.setTeneo_previous_start(source.getTeneo_previous_start());
    }

    private synchronized List<AuditWork> getRemoveQueue(Session session, boolean remove) {
        List<AuditWork> auditWorks = this.workQueue.get(session.getTransaction());
        if (auditWorks != null && remove) {
            this.workQueue.remove(session.getTransaction());
        } else {
            this.workQueue.put(session.getTransaction(), new ArrayList());
        }
        return auditWorks;
    }

    public AuditDataStore getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(AuditDataStore dataStore) {
        this.dataStore = dataStore;
        this.pruneTime = 86400000L * Long.parseLong(dataStore.getDataStoreProperties().getProperty("teneo.mapping.auditing.prune.days"));
        this.pruneInterval = Long.parseLong(dataStore.getDataStoreProperties().getProperty("teneo.mapping.auditing.prune.commit.interval"));
        this.auditHandler = dataStore.getAuditHandler();
        boolean checkInitialAuditEntry = Boolean.parseBoolean("" + dataStore.getDataStoreProperties().get("teneo.mapping.auditing.checkInitialAuditEntry"));
        this.setCheckInitialAuditEntry(checkInitialAuditEntry);
    }

    private synchronized void pruneEntries(SessionImplementor session) {
        if (this.pruneTime == 0L) {
            return;
        }
        if ((long)this.pruneCounter > this.pruneInterval) {
            return;
        }
        this.pruneCounter = 0;
        if (this.auditEntityNames == null) {
            this.auditEntityNames = new ArrayList<String>();
            EPackage[] ePackageArray = this.dataStore.getEPackages();
            int n = ePackageArray.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage ePackage = ePackageArray[n2];
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    if (!(eClassifier instanceof EClass) || !StoreUtil.isAuditEntryEClass((EClass)((EClass)eClassifier))) continue;
                    this.auditEntityNames.add(this.dataStore.toEntityName((EClass)eClassifier));
                }
                ++n2;
            }
        }
        Session tmpSession = null;
        boolean err = true;
        try {
            tmpSession = session.getFactory().openSession();
            tmpSession.beginTransaction();
            long currentPruneTime = System.currentTimeMillis() - this.pruneTime;
            for (String auditEntityName : this.auditEntityNames) {
                Query qry = tmpSession.createQuery("select e from " + auditEntityName + " e where e.teneo_start < :pruneTime");
                qry.setParameter("pruneTime", (Object)currentPruneTime);
                ScrollableResults results = qry.scroll(ScrollMode.FORWARD_ONLY);
                while (results.next()) {
                    tmpSession.delete(results.get()[0]);
                }
                results.close();
            }
            tmpSession.getTransaction().commit();
            err = false;
        }
        finally {
            try {
                if (tmpSession != null && err) {
                    tmpSession.getTransaction().rollback();
                }
            }
            finally {
                if (tmpSession != null) {
                    tmpSession.close();
                }
            }
        }
    }

    public void setPruneTime(long thePruneTime) {
        this.pruneTime = thePruneTime;
    }

    public long getPruneTime() {
        return this.pruneTime;
    }

    public AuditHandler getAuditHandler() {
        return this.auditHandler;
    }

    public void setCheckInitialAuditEntry(boolean checkInitialAuditEntry) {
        this.checkInitialAuditEntry = checkInitialAuditEntry;
    }

    public boolean requiresPostCommitHanding(EntityPersister arg0) {
        return true;
    }

    protected class AuditWork {
        private Object entity;
        private TeneoAuditKind auditKind;
        private long version;
        private AuditWork initialRecord;

        protected AuditWork() {
        }

        public Object getEntity() {
            return this.entity;
        }

        public void setInitialRecord(AuditWork initialRecord) {
            this.initialRecord = initialRecord;
        }

        public AuditWork getInitialRecord() {
            return this.initialRecord;
        }

        public void setEntity(Object entity) {
            this.entity = entity;
        }

        public TeneoAuditKind getAuditKind() {
            return this.auditKind;
        }

        public void setAuditKind(TeneoAuditKind auditKind) {
            this.auditKind = auditKind;
        }

        public long getVersion() {
            return this.version;
        }

        public void setVersion(long version) {
            this.version = version;
        }

        public String toString() {
            return "Audit kind " + (Object)((Object)this.auditKind) + " Entity " + this.entity + " version " + this.version;
        }
    }
}

