/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.ecore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.DataStore;
import org.eclipse.emf.teneo.ERuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EModelResolver {
    private static EModelResolver instance = null;
    private Map<EPackage, List<DataStore>> ePackageRegistration = new HashMap<EPackage, List<DataStore>>();

    public static EModelResolver instance() {
        if (instance == null) {
            instance = ERuntime.INSTANCE;
        }
        return instance;
    }

    public static void setInstance(EModelResolver modelResolver) {
        instance = modelResolver;
    }

    public abstract void clear();

    public abstract EClass getEClass(Class<?> var1);

    public abstract boolean isRegistered(EPackage var1);

    public abstract void register(EPackage[] var1);

    public synchronized void registerOwnerShip(DataStore dataStore, EPackage[] epacks) {
        EPackage[] ePackageArray = epacks;
        int n = epacks.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage ePackage = ePackageArray[n2];
            List<DataStore> stores = this.ePackageRegistration.get(ePackage);
            if (stores == null) {
                stores = new ArrayList<DataStore>();
                this.ePackageRegistration.put(ePackage, stores);
            }
            if (!stores.contains(dataStore)) {
                stores.add(dataStore);
            }
            ++n2;
        }
    }

    public synchronized void unregisterOwnerShip(DataStore dataStore, EPackage[] epacks) {
        ArrayList<EPackage> toRemove = new ArrayList<EPackage>();
        EPackage[] ePackageArray = epacks;
        int n = epacks.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage ePackage = ePackageArray[n2];
            List<DataStore> stores = this.ePackageRegistration.get(ePackage);
            if (stores != null) {
                stores.remove(dataStore);
                if (stores.isEmpty()) {
                    this.ePackageRegistration.remove(ePackage);
                    toRemove.add(ePackage);
                }
            }
            ++n2;
        }
        this.removeEPackages(toRemove);
    }

    protected void removeEPackages(List<EPackage> ePackages) {
    }

    public abstract List<Class<?>> getAllClassesAndInterfaces();

    public abstract Class<?> getJavaClass(EClassifier var1);

    public abstract Class<?> getJavaInterfaceClass(EClass var1);

    public abstract boolean hasImplementationClass(EClassifier var1);

    public abstract EPackage[] getEPackages();

    public abstract Object create(EClass var1);

    public Object create(EPackage epackage, String eclassName) {
        EClass eclass = (EClass)epackage.getEClassifier(eclassName);
        if (eclass == null) {
            throw new IllegalArgumentException("No EClass " + eclassName + " found in epackage " + epackage.getName());
        }
        return this.create(eclass);
    }

    public Object create(String eclassName) {
        EPackage[] ePackageArray = this.getEPackages();
        int n = ePackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage epackage = ePackageArray[n2];
            EClass eclass = (EClass)epackage.getEClassifier(eclassName);
            if (eclass != null) {
                return this.create(eclass);
            }
            ++n2;
        }
        throw new IllegalArgumentException("No EClass " + eclassName + " found.");
    }
}

