/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.pannotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CascadeType implements Enumerator
{
    ALL(0, "ALL", "ALL"),
    PERSIST(1, "PERSIST", "PERSIST"),
    MERGE(2, "MERGE", "MERGE"),
    REMOVE(3, "REMOVE", "REMOVE"),
    REFRESH(4, "REFRESH", "REFRESH"),
    NONE(5, "NONE", "NONE");

    public static final int ALL_VALUE = 0;
    public static final int PERSIST_VALUE = 1;
    public static final int MERGE_VALUE = 2;
    public static final int REMOVE_VALUE = 3;
    public static final int REFRESH_VALUE = 4;
    public static final int NONE_VALUE = 5;
    private static final CascadeType[] VALUES_ARRAY;
    public static final List<CascadeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CascadeType[]{ALL, PERSIST, MERGE, REMOVE, REFRESH, NONE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CascadeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CascadeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CascadeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CascadeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CascadeType get(int value) {
        switch (value) {
            case 0: {
                return ALL;
            }
            case 1: {
                return PERSIST;
            }
            case 2: {
                return MERGE;
            }
            case 3: {
                return REMOVE;
            }
            case 4: {
                return REFRESH;
            }
            case 5: {
                return NONE;
            }
        }
        return null;
    }

    private CascadeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

