/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapper.classic;

import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.hibernate.mapper.MappingContext;

public class ClassicMappingContext
extends MappingContext {
    @Override
    protected String trunc(PAnnotation pAnnotation, String truncName, boolean truncSuffix) {
        String useName;
        if (pAnnotation != null && !this.doTrunc(pAnnotation)) {
            if (!truncName.startsWith(this.escapeCharacter) && !truncName.endsWith(this.escapeCharacter)) {
                return String.valueOf(this.escapeCharacter) + truncName + this.escapeCharacter;
            }
            return truncName;
        }
        if (this.currentAFeature != null) {
            boolean override = false;
            override = this.currentAFeature instanceof PAnnotatedEAttribute ? this.getAttributeOverride((PAnnotatedEStructuralFeature)((PAnnotatedEAttribute)this.currentAFeature)) != null : this.getAssociationOverrides((PAnnotatedEReference)this.currentAFeature) != null;
            String otherEntityName = this.getEntityName(this.currentEFeature.getEContainingClass(), false);
            if (!override && this.currentEFeature.getEContainingClass() != this.currentEClass && otherEntityName != null && truncName.toUpperCase().startsWith(otherEntityName.toUpperCase())) {
                log.debug((Object)("Replacing name of table/joincolumn " + truncName));
                useName = String.valueOf(this.getEntityName(this.currentEClass)) + truncName.substring(this.getEntityName(this.currentEFeature.getEContainingClass()).length());
                log.debug((Object)("with " + useName + " because efeature is inherited"));
                log.debug((Object)"This renaming does not work in case of manually specified joincolumn/table names and mappedsuperclass or multiple inheritance!");
            } else {
                useName = truncName;
            }
        } else {
            useName = truncName;
        }
        if (this.maximumSqlNameLength == -1) {
            return this.escape(useName);
        }
        if (useName.length() < this.maximumSqlNameLength) {
            return this.escape(useName);
        }
        int underscore = useName.lastIndexOf(95);
        if (truncSuffix && underscore != -1 && underscore > 0) {
            String usStr = useName.substring(underscore);
            if (this.maximumSqlNameLength - usStr.length() < 0) {
                return this.escape(useName);
            }
            return this.escape(String.valueOf(useName.substring(0, this.maximumSqlNameLength - usStr.length())) + usStr);
        }
        return this.escape(useName.substring(0, this.maximumSqlNameLength));
    }

    protected String escape(String name) {
        if (this.getEscapeCharacter().length() == 0 || name.indexOf(this.getEscapeCharacter()) == 0) {
            return this.getSqlNameStrategy().convert(name);
        }
        return String.valueOf(this.getEscapeCharacter()) + this.getSqlNameStrategy().convert(name) + this.getEscapeCharacter();
    }

    @Override
    @Deprecated
    protected String trunc(String truncName, boolean truncSuffix) {
        return this.trunc(null, truncName, truncSuffix);
    }
}

