/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.util.EcoreDataTypes;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class XSDDateTime
implements UserType {
    static final long serialVersionUID = 1L;
    private static final int[] SQL_TYPES = new int[]{93};
    private final DatatypeFactory dataTypeFactory;

    public XSDDateTime() {
        try {
            this.dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new HbStoreException("Exception ", e);
        }
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public String getName() {
        return "xmldatetime";
    }

    public Class returnedClass() {
        return XMLGregorianCalendar.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getClass() != y.getClass()) {
            return false;
        }
        return x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        Timestamp ts = rs.getTimestamp(names[0]);
        if (ts == null) {
            return null;
        }
        return EcoreDataTypes.INSTANCE.getXMLGregorianCalendarDateTime((Date)ts);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setTimestamp(index, null);
            return;
        }
        Timestamp d = new Timestamp(((XMLGregorianCalendar)value).toGregorianCalendar().getTime().getTime());
        st.setTimestamp(index, d);
    }

    public String toString(Object val) {
        if (val == null) {
            return null;
        }
        return ((XMLGregorianCalendar)val).toString();
    }

    public Object fromStringValue(String s) throws HibernateException {
        return this.dataTypeFactory.newXMLGregorianCalendar(s);
    }

    public int hashCode(Object x) throws HibernateException {
        if (x == null) {
            return 0;
        }
        return x.toString().hashCode();
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return this.toString(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        return this.fromStringValue(cached.toString());
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

