/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HibernateFeatureMapEntry;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.Instantiator;

public class FeatureMapEntryInstantiator
implements Instantiator {
    private static final long serialVersionUID = -1219767393020090471L;
    private static Log log = LogFactory.getLog(FeatureMapEntryInstantiator.class);
    private final PersistentClass persistentClass;
    private final Class<?> proxyInterface;

    public FeatureMapEntryInstantiator(PersistentClass pc) {
        AssertUtil.assertTrue((String)(String.valueOf(pc.getEntityName()) + " does not have a meta attribute"), (pc.getMetaAttribute("featureMap") != null ? 1 : 0) != 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating fme instantiator for " + pc.getEntityName()));
        }
        this.proxyInterface = pc.getProxyInterface();
        this.persistentClass = pc;
    }

    public Object instantiate() {
        HibernateFeatureMapEntry fme = new HibernateFeatureMapEntry();
        fme.setEntityName(this.persistentClass.getEntityName());
        return fme;
    }

    public Object instantiate(Serializable id) {
        return this.instantiate();
    }

    public boolean isInstance(Object object) {
        return HibernateFeatureMapEntry.class.isInstance(object) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }
}

