/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.model;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.model.CDOClass;
import org.eclipse.emf.cdo.common.model.CDOClassRef;
import org.eclipse.emf.cdo.common.model.CDOPackage;
import org.eclipse.emf.cdo.common.model.CDOPackageManager;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;

public final class CDOClassRefImpl
implements CDOClassRef {
    private String packageURI;
    private int classifierID;

    public CDOClassRefImpl() {
    }

    public CDOClassRefImpl(String packageURI, int classifierID) {
        this.packageURI = packageURI;
        this.classifierID = classifierID;
    }

    public CDOClassRefImpl(ExtendedDataInput in, String defaultURI) throws IOException {
        this.packageURI = in.readString();
        if (this.packageURI == null) {
            this.packageURI = defaultURI;
        }
        this.classifierID = in.readInt();
    }

    public void write(ExtendedDataOutput out, String defaultURI) throws IOException {
        out.writeString(this.packageURI.equals(defaultURI) ? null : this.packageURI);
        out.writeInt(this.classifierID);
    }

    public String getPackageURI() {
        return this.packageURI;
    }

    public int getClassifierID() {
        return this.classifierID;
    }

    public CDOClass resolve(CDOPackageManager packageManager) {
        CDOPackage cdoPackage = packageManager.lookupPackage(this.packageURI);
        if (cdoPackage != null) {
            return cdoPackage.lookupClass(this.classifierID);
        }
        return null;
    }

    public String toString() {
        return MessageFormat.format("CDOClassRef({0}, {1})", this.packageURI, this.classifierID);
    }
}

